/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agentevents.engine.builders;

import io.sealights.onpremise.agents.infra.token.TokenValueFormatter;
import lombok.Generated;

public final class CredentialsMaskFormatter {
    public static final String MASK = "***";
    public static final String PASSWORD = "password";
    public static final String SL_TOKEN = "sl.token";
    public static final String USER = "user";
    public static final String MASKED_VALUE_STRING = "<real value removed due to security configuration>";
    private static final String ASSIGN = "=";

    public static String maskArgValue(String originalValue, boolean maskCockpitSensitive) {
        String lowerCase = originalValue.toLowerCase();
        if (lowerCase.contains(PASSWORD)) {
            return CredentialsMaskFormatter.maskValue(originalValue);
        }
        if (lowerCase.contains(USER)) {
            return CredentialsMaskFormatter.maskValue(originalValue);
        }
        if (maskCockpitSensitive && lowerCase.contains(SL_TOKEN)) {
            return TokenValueFormatter.truncateTokenSysProperty(originalValue, null);
        }
        if (maskCockpitSensitive && CredentialsMaskFormatter.isPotentialSensitive(originalValue)) {
            return CredentialsMaskFormatter.maskValue(originalValue);
        }
        return originalValue;
    }

    private static boolean isPotentialSensitive(String originalValue) {
        return originalValue.contains("proxy") || !originalValue.startsWith("-javaagent:") && !originalValue.startsWith("-Dsl.") && !originalValue.startsWith("-XX:") && !originalValue.startsWith("-Djdk.") && !originalValue.startsWith("-Djava.");
    }

    private static String maskValue(String originalValue) {
        String[] keyValuePair = originalValue.split(ASSIGN);
        if (keyValuePair.length >= 2) {
            return keyValuePair[0] + ASSIGN + MASK;
        }
        return originalValue;
    }

    @Generated
    private CredentialsMaskFormatter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

