/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agentevents.engine.builders;

import io.sealights.onpremise.agentevents.engine.AgentInputRequests;
import io.sealights.onpremise.agentevents.engine.builders.AgentStartInfoBuilder;
import io.sealights.onpremise.agentevents.engine.builders.CredentialsMaskFormatter;
import io.sealights.onpremise.agentevents.engine.builders.InfoBuilder;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentStartInfo;
import io.sealights.onpremise.agents.infra.configuration.SystemPropertiesHelper;
import io.sealights.onpremise.agents.infra.env.DefaultDirs;
import io.sealights.onpremise.agents.infra.env.JvmProcessIdInfo;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.onpremise.agents.infra.utils.jvm.JvmUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class AgentInstanceInfoBuilder
extends InfoBuilder<AgentStartInfo.AgentInstanceInfo>
implements InfoBuilder.SysEnvConsumer {
    private static final String TAGS_SEPARATOR = ",";
    private static final String JVM_ARGS_SEPARATOR = " ";
    private static final String SL_ENV_VAR = "SL_".toLowerCase();
    private static final String PATH_ENV_VAR = "PATH".toLowerCase();
    boolean maskSensitiveData = SystemPropertiesHelper.getBoolProperty("sl.maskData", false);
    private AgentInputRequests.AgentStartRequest agentRequest;
    private static final Set<String> VARIABLES_TO_MASK = new HashSet<String>(Arrays.asList("ci_dependency_proxy_server", "ci_environment_url", "ci_server_url", "ci_server_host", "ci_server_name", "circle_repository_url", "jenkins_url", "git_url"));
    private static final Set<String> CI_ENVIRONMENT_NAMES = new HashSet<String>(Arrays.asList("build_number", "build_id", "build_url", "node_name", "job_name", "build_tag", "jenkins_url", "workspace", "git_commit", "git_url", "git_branch", "circle_branch", "circle_build_num", "circle_build_url", "circle_job", "circle_node_index", "circle_node_total", "circle_pr_number", "circle_pr_reponame", "circle_previous_build_num", "circle_project_reponame", "circle_pull_request", "circle_repository_url", "circle_sha1", "circle_tag", "circle_workflow_id", "circle_workflow_job_id", "circle_workflow_workspace_id", "circle_working_directory", "teamcity_version", "teamcity_project_name", "teamcity_buildconf_name", "build_is_personal", "ci_builds_dir", "ci_commit_author", "ci_commit_before_sha", "ci_commit_branch", "ci_commit_description", "ci_commit_message", "ci_commit_ref_name", "ci_commit_ref_slug", "ci_commit_sha", "ci_commit_short_sha", "ci_commit_tag", "ci_commit_timestamp", "ci_commit_title", "ci_concurrent_id", "ci_concurrent_project_id", "ci_config_path", "ci_default_branch", "ci_dependency_proxy_server", "ci_disposable_environment", "ci_environment_name", "ci_environment_slug", "ci_environment_url", "ci_environment_action", "ci_environment_tier", "ci_job_id", "ci_job_image", "ci_job_name", "ci_job_stage", "ci_job_url", "ci_job_started_at", "ci_kubernetes_active", "ci_node_index", "ci_node_total", "ci_pipeline_url", "ci_project_dir", "ci_project_name", "ci_project_namespace", "ci_project_path_slug", "ci_project_path", "ci_project_repository_languages", "ci_project_root_namespace", "ci_project_title", "ci_project_description", "ci_project_url", "ci_registry_image", "ci_repository_url", "ci_server_host", "ci_server_name", "ci_server_url", "ci_server_version_major", "ci_server_version_minor", "ci_server_version_patch", "ci_server_version", "gitlab_ci", "ci_merge_request_approved", "ci_merge_request_assignees", "ci_merge_request_id", "ci_merge_request_iid", "ci_merge_request_labels", "ci_merge_request_milestone", "ci_merge_request_project_id", "ci_merge_request_project_path", "ci_merge_request_project_url", "ci_merge_request_ref_path", "ci_merge_request_source_branch_name", "ci_merge_request_source_branch_sha", "ci_merge_request_source_project_id", "ci_merge_request_source_project_path", "ci_merge_request_source_project_url", "ci_merge_request_target_branch_name", "ci_merge_request_target_branch_sha", "ci_merge_request_title", "ci_merge_request_event_type", "ci_merge_request_diff_id", "ci_merge_request_diff_base_sha", "ci_external_pull_request_iid", "ci_external_pull_request_source_repository", "ci_external_pull_request_target_repository", "ci_external_pull_request_source_branch_name", "ci_external_pull_request_source_branch_sha", "ci_external_pull_request_target_branch_name", "ci_external_pull_request_target_branch_sha", "github_action", "github_action_path", "github_action_repository", "github_base_ref", "github_env", "github_head_ref", "github_job", "github_path", "github_ref", "github_ref_name", "github_ref_type", "github_repository", "github_repository_owner", "github_sha", "github_step_summary", "github_workflow", "github_workspace", "runner_arch", "runner_name", "runner_os", "runner_temp", "runner_tool_cache"));

    AgentInstanceInfoBuilder(AgentInputRequests.AgentStartRequest agentRequest) {
        this.agentRequest = agentRequest;
        this.data = new AgentStartInfo.AgentInstanceInfo(agentRequest.getAgentType(), agentRequest.getAgentDescriptor().getAgentVersion());
    }

    @Override
    protected AgentStartInfo.AgentInstanceInfo getEmptyData() {
        return (AgentStartInfo.AgentInstanceInfo)this.data;
    }

    @Override
    protected void fillData() {
        ((AgentStartInfo.AgentInstanceInfo)this.data).setBuildSessionId(this.agentRequest.getAgentDescriptor().getBuildSessionId());
        ((AgentStartInfo.AgentInstanceInfo)this.data).setAppName(this.agentRequest.getAgentDescriptor().getAppName());
        ((AgentStartInfo.AgentInstanceInfo)this.data).setSendsPing(this.agentRequest.getAgentDescriptor().isSendsPing());
        ((AgentStartInfo.AgentInstanceInfo)this.data).setUniqueModuleId(this.agentRequest.getAgentDescriptor().getModuleName());
        ((AgentStartInfo.AgentInstanceInfo)this.data).setLabId(this.agentRequest.getAgentDescriptor().getLabId());
        if (this.agentRequest.getConfigProperties() != null) {
            ((AgentStartInfo.AgentInstanceInfo)this.data).setAgentConfig(this.agentRequest.getConfigProperties());
        }
        if (this.agentRequest.getToolInfo() != null) {
            ((AgentStartInfo.AgentInstanceInfo)this.data).getTools().add(this.agentRequest.getToolInfo());
        }
        this.fillTags();
        this.fillProccessInfo();
        this.fillRunInfo();
        this.fetchSystemEnv(this);
        AgentStartInfoBuilder.LOG.debug("created {}", this.data);
    }

    private void fillTags() {
        String tagsPropValue = System.getProperty("sl.tags");
        if (StringUtils.isNotEmpty(tagsPropValue)) {
            String[] tags;
            for (String tag : tags = tagsPropValue.split(TAGS_SEPARATOR)) {
                ((AgentStartInfo.AgentInstanceInfo)this.data).addTag(new AgentStartInfo.TagInfo(tag));
            }
        }
    }

    private void fillProccessInfo() {
        ((AgentStartInfo.AgentInstanceInfo)this.data).setProcessId(JvmProcessIdInfo.get());
        String arch = System.getenv("PROCESSOR_ARCHITECTURE");
        String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
        String realArch = arch != null && arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64") ? "x64" : "x32";
        ((AgentStartInfo.AgentInstanceInfo)this.data).setProcessArch(realArch);
    }

    protected void fillCmdLineArgs() {
        String runCmd = JvmUtils.getRunCommand();
        if (runCmd != null) {
            this.addArguments(Arrays.asList(runCmd.split(JVM_ARGS_SEPARATOR)));
        }
    }

    protected void fillJvmArgs() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        this.addArguments(runtimeMxBean.getInputArguments());
    }

    private void addArguments(List<String> args) {
        for (String argv : args) {
            ((AgentStartInfo.AgentInstanceInfo)this.data).getArgv().add(CredentialsMaskFormatter.maskArgValue(argv, this.maskSensitiveData));
        }
    }

    private void fillRunInfo() {
        ((AgentStartInfo.AgentInstanceInfo)this.data).setCwd(DefaultDirs.WORKING_DIR);
        this.fillCmdLineArgs();
        this.fillJvmArgs();
    }

    @Override
    public void consume(String key, String value) {
        String lowCaseKey = key.toLowerCase();
        if (lowCaseKey.startsWith(SL_ENV_VAR) || lowCaseKey.startsWith(PATH_ENV_VAR) || CI_ENVIRONMENT_NAMES.contains(lowCaseKey)) {
            ((AgentStartInfo.AgentInstanceInfo)this.data).getEnvVars().put(lowCaseKey, this.maskSensitiveValues(lowCaseKey, value));
        }
    }

    private String maskSensitiveValues(String variableName, String value) {
        return this.maskSensitiveData && VARIABLES_TO_MASK.contains(variableName) ? "<real value removed due to security configuration>" : value;
    }
}

