/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agentevents.engine;

import io.sealights.onpremise.agentevents.engine.AgentInputRequests;
import io.sealights.onpremise.agentevents.engine.builders.AgentStartInfoBuilder;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentConfigChanged;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentEvent;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentEventCode;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentStartInfo;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentStartedEvent;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AnonymousExecutionEvents;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.ConfigChangedEvent;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.IAgentEventType;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.PingDataEvents;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.SimpleEvents;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.StringCollectionDataEvent;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.StringDataEvents;
import io.sealights.onpremise.agents.infra.configuration.SLAgentConfiguration;
import io.sealights.onpremise.agents.infra.types.ExecutionDescriptor;
import java.util.Collection;
import lombok.Generated;

public final class AgentEventsFactory {
    public static AgentStartedEvent createAgentStartedEvent(AgentInputRequests.AgentStartRequest agentRequest, long currentTimeMs) {
        AgentStartInfo startInfo = AgentStartInfoBuilder.buildAgentStartInfo(agentRequest);
        return new AgentStartedEvent(startInfo, currentTimeMs);
    }

    public static PingDataEvents.PingDataEvent createAgentPingEvent(long currentTimeMs) {
        return new PingDataEvents.PingDataEvent(currentTimeMs);
    }

    public static PingDataEvents.PingDataEvent createAgentPingEvent(String labId, long currentTimeMs) {
        return new PingDataEvents.PingDataEvent(labId, currentTimeMs);
    }

    public static PingDataEvents.AgentShutdownEvent createAgentShutdownEvent(long currentTimeMs) {
        return new PingDataEvents.AgentShutdownEvent(currentTimeMs);
    }

    public static ConfigChangedEvent createAgentConfigChangedEvent(AgentInputRequests.AgentConfigChangeRequest agentRequest, long currentTimeMs) {
        AgentConfigChanged changeInfo = new AgentConfigChanged((SLAgentConfiguration)agentRequest.getData());
        return new ConfigChangedEvent(changeInfo, currentTimeMs);
    }

    public static StringDataEvents.StringDataEvent createAgentMessageEvent(AgentInputRequests.AgentMessage agentMsg, long currentTimeMs) {
        switch (agentMsg.getEventCode()) {
            case GENERIC_MESSAGE: {
                return new StringDataEvents.GenericMessageEvent(agentMsg.getMsg(), currentTimeMs);
            }
            case GENERIC_WARNING: {
                return new StringDataEvents.GenericWarningEvent(agentMsg.getMsg(), currentTimeMs);
            }
            case GENERIC_ERROR: {
                return new StringDataEvents.GenericErrorEvent(agentMsg.getMsg(), currentTimeMs);
            }
            case GENERIC_MESSAGE_SUPERUSER: {
                return new StringDataEvents.GenericMessageSuperUserEvent(agentMsg.getMsg(), currentTimeMs);
            }
            case GENERIC_WARNING_SUPERUSER: {
                return new StringDataEvents.GenericWarningSuperUserEvent(agentMsg.getMsg(), currentTimeMs);
            }
            case GENERIC_ERROR_SUPERUSER: {
                return new StringDataEvents.GenericErrorSuperUserEvent(agentMsg.getMsg(), currentTimeMs);
            }
            case FOOTPRINTS_SUBMISSION_ERROR: {
                return new StringDataEvents.FootprintsSubmitErrorEvent(agentMsg.getMsg(), currentTimeMs);
            }
            case TEST_EVENTS_SUBMISSION_ERROR: {
                return new StringDataEvents.TestEventsSubmitErrorEvent(agentMsg.getMsg(), currentTimeMs);
            }
            case EXTERNAL_DATA_PROCESSOR_SUBMISSION_ERROR: {
                return new StringDataEvents.ExternalDataSubmitErrorEvent(agentMsg.getMsg(), currentTimeMs);
            }
            case BUILD_MAP_SUBMISSION_ERROR: {
                return new StringDataEvents.BuildMapSubmitErrorEvent(agentMsg.getMsg(), currentTimeMs);
            }
            case FAILED_TO_CREATE_EXECUTION_ERROR: {
                return new StringDataEvents.FailedToCreateExecutionError(agentMsg.getMsg(), currentTimeMs);
            }
            case PER_THREAD_COVERAGE_DISABLED: {
                return new StringDataEvents.PerThreadCoverageDisabledWarning(agentMsg.getMsg(), currentTimeMs);
            }
        }
        return null;
    }

    public static AnonymousExecutionEvents.AnonymousExecutionEvent createAnonymousExecutionEvent(boolean executionFound, ExecutionDescriptor executionData, long currentTimeMs) {
        if (executionFound) {
            return new AnonymousExecutionEvents.AnonymousExecutionFoundEvent(executionData, currentTimeMs);
        }
        return new AnonymousExecutionEvents.AnonymousExecutionNotFoundEvent(executionData, currentTimeMs);
    }

    public static AgentEvent createSimpleEvent(AgentEventCode eventCode, long currentTimeMs) {
        switch (eventCode) {
            case FIRST_COVERAGE_INSTRUMENTATION_PERFORMED: {
                return new SimpleEvents.FirstCoveragePerformedEvent(currentTimeMs);
            }
            case AGENT_MUTED: {
                return new SimpleEvents.AgentMutedEvent(currentTimeMs);
            }
            case AGENT_UNMUTED: {
                return new SimpleEvents.AgentUnmutedEvent(currentTimeMs);
            }
            case FIRST_FOOTPRINTS_ADDED_TO_BUFFER: {
                return new SimpleEvents.FirstFootprintsAddedToBufferEvent(currentTimeMs);
            }
        }
        return null;
    }

    public static AgentEvent createStringCollectionAgentEvent(AgentEventCode eventCode, Collection<String> data2, long currentTimeMs) {
        switch (eventCode) {
            case INVALID_CONFIGURATION_AGENT_DISABLED: {
                return new StringCollectionDataEvent.InvalidConfigurationAgentDisabledErrorEvent(data2, currentTimeMs);
            }
            case SOME_EXECUTION_NOT_RESOLVED_BEFORE_SHUTDOWN: {
                return new StringCollectionDataEvent.SomeExecutionsNotResolvedBeforeShutdownWarningEvent((IAgentEventType)eventCode, data2, currentTimeMs);
            }
        }
        return null;
    }

    @Generated
    private AgentEventsFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

