/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agentevents.engine;

import io.sealights.onpremise.agentevents.engine.AgentDescriptor;
import io.sealights.onpremise.agentevents.engine.AgentEventServiceHandler;
import io.sealights.onpremise.agentevents.engine.AgentEventsDispatcher;
import io.sealights.onpremise.agentevents.engine.AgentEventsFactory;
import io.sealights.onpremise.agentevents.engine.AgentInputRequests;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.EndBuildEventRequest;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentEvent;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentEventCode;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentStartInfo;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.ConfigChangedEvent;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.IAgentEventType;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.PingDataEvents;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.StringDataEvents;
import io.sealights.onpremise.agents.infra.configuration.SLAgentConfiguration;
import io.sealights.onpremise.agents.infra.env.AgentId;
import io.sealights.onpremise.agents.infra.logging.ExceptionStackTrace;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.time.sync.TimeClockServiceHandler;
import io.sealights.onpremise.agents.infra.time.sync.TimeSyncStatus;
import io.sealights.onpremise.agents.infra.time.sync.utils.TimeClockDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;

public abstract class AgentEventsController {
    private static final int NUM_UNSUCCESSFUL_TIME_CLOC_SYNC_BEFORE_SENDING_MESSAGE = 50;
    private static final Logger LOG = LogFactory.getLogger(AgentEventsController.class);
    private String agentId;
    private AgentDescriptor agentDescriptor;
    private AgentEventsDispatcher eventsDispatcher;
    protected TimeClockDispatcher timeClockDispatcher;
    private List<TimeSyncStatus> unsuccessfulTimeClockSyncs = new ArrayList<TimeSyncStatus>();

    public AgentEventsController() {
        this.agentId = AgentId.getAgentId();
    }

    public void stop() {
        this.sendShutdownEvent();
    }

    protected void init(AgentDescriptor agentDescriptor, String token, String server, String proxy) {
        this.setAgentDescriptor(agentDescriptor);
        this.timeClockDispatcher = TimeClockDispatcher.getInstance(this.agentId, new TimeClockServiceHandler(token, server, proxy));
        this.eventsDispatcher = new AgentEventsDispatcher(this.agentId, agentDescriptor, new AgentEventServiceHandler(token, server, proxy));
    }

    public void verifyTimeClock(boolean sendImmediately) {
        LOG.debug("Verify time clock ...");
        if (null == this.timeClockDispatcher || !this.timeClockDispatcher.isSyncDone()) {
            LOG.info("Time Clock Dispatcher is not initialized");
            return;
        }
        if (!this.timeClockDispatcher.isEnabled()) {
            LOG.info("Time Clock Dispatcher is disabled");
            return;
        }
        TimeSyncStatus timeSyncStatus = this.timeClockDispatcher.getTimeSyncStatus();
        if (timeSyncStatus == null) {
            LOG.warn("Time sync status is null");
            this.unsuccessfulTimeClockSyncs.add(new TimeSyncStatus(System.currentTimeMillis(), 0L, false));
            if (sendImmediately || this.unsuccessfulTimeClockSyncs.size() > 50) {
                this.eventsDispatcher.handleUrgentEvent(new StringDataEvents.TimeSyncFailedWarning(TimeClockDispatcher.createCockpitMessage("time timeSyncStatus is null")), false);
                this.unsuccessfulTimeClockSyncs.clear();
                return;
            }
            return;
        }
        if (!timeSyncStatus.isSuccess()) {
            LOG.warn("Time sync status is not success");
            this.unsuccessfulTimeClockSyncs.add(timeSyncStatus);
            if (sendImmediately || this.unsuccessfulTimeClockSyncs.size() > 50) {
                this.eventsDispatcher.handleUrgentEvent(new StringDataEvents.TimeSyncFailedWarning(TimeClockDispatcher.createCockpitMessage("timeSyncStatus not success")), false);
                this.unsuccessfulTimeClockSyncs.clear();
            }
        }
    }

    public void sendStartEvent() {
        this.verifyTimeClock(true);
        if (this.isValidDescriptor(AgentEventCode.AGENT_STARTED)) {
            AgentInputRequests.AgentStartRequest agentRequest = this.createAgentStartRequest();
            this.eventsDispatcher.sendStartEvent(AgentEventsFactory.createAgentStartedEvent(agentRequest, this.timeClockDispatcher.getTimeClock()));
        }
    }

    public void sendShutdownEvent() {
        this.verifyTimeClock(true);
        if (this.isValidDescriptor(AgentEventCode.AGENT_SHUTDOWN)) {
            this.eventsDispatcher.sendShutdownEvent(AgentEventsFactory.createAgentShutdownEvent(this.timeClockDispatcher.getTimeClock()));
        }
        this.eventsDispatcher.stop();
        this.timeClockDispatcher.stop();
    }

    public void sendMessage(NotifMsgLevel msgLevel, String msg) {
        this.sendMessageEvent(msgLevel.getMsgEventCode(), msg);
    }

    public void sendSuperUserMessage(NotifMsgLevel msgLevel, String msg) {
        this.sendMessageEvent(msgLevel.getSuperUserMsgEventCode(), msg);
    }

    public void sendSuperUserExceptionMessage(NotifMsgLevel notifMsgLevel, Class<?> scope, String msg, Throwable e) {
        String scopeMsg = scope != null ? "class " + scope.getName() : "unknown scope";
        String fullMsg = String.format("%s, exception at %s : %s", msg, scopeMsg, ExceptionStackTrace.toString(e));
        this.sendSuperUserMessage(notifMsgLevel, fullMsg);
        LOG.info(fullMsg);
    }

    public void sendMessageEvent(AgentEventCode eventCode, String msg) {
        this.verifyTimeClock(false);
        if (this.isValidDescriptor(eventCode)) {
            AgentInputRequests.AgentMessageRequest agentRequest = new AgentInputRequests.AgentMessageRequest(this.agentId, this.agentDescriptor, eventCode, msg);
            StringDataEvents.StringDataEvent messageEvent = AgentEventsFactory.createAgentMessageEvent((AgentInputRequests.AgentMessage)agentRequest.getData(), this.timeClockDispatcher.getTimeClock());
            this.eventsDispatcher.addEvent(messageEvent);
            LOG.debug("{} event was added, local time: {}, event timestamp: {}", messageEvent.getClass(), System.currentTimeMillis(), messageEvent.getUtcTimestamp_ms());
        }
    }

    public void sendSimpleEvent(AgentEventCode eventCode) {
        this.verifyTimeClock(false);
        if (this.isValidDescriptor(eventCode)) {
            AgentEvent event = AgentEventsFactory.createSimpleEvent(eventCode, this.timeClockDispatcher.getTimeClock());
            if (event != null) {
                this.eventsDispatcher.addEvent(AgentEventsFactory.createSimpleEvent(eventCode, this.timeClockDispatcher.getTimeClock()));
                LOG.debug("{} event was sent, local time: {}, event timestamp: {}", event.getClass(), System.currentTimeMillis(), event.getUtcTimestamp_ms());
            } else {
                LOG.info("{} was not sent - no relevant simple event class for this code", (Object)eventCode);
            }
        }
    }

    public void sendPingEvent() {
        this.verifyTimeClock(false);
        if (this.isValidDescriptor(AgentEventCode.AGENT_PING)) {
            PingDataEvents.PingDataEvent pingEvent = AgentEventsFactory.createAgentPingEvent(this.agentDescriptor.getLabId(), this.timeClockDispatcher.getTimeClock());
            this.eventsDispatcher.addEvent(pingEvent);
            LOG.debug("{} event was added, local time: {}, event timestamp: {}", pingEvent.getClass(), System.currentTimeMillis(), pingEvent.getUtcTimestamp_ms());
        }
    }

    public void sendConfigurationChangedEvent(SLAgentConfiguration configuration) {
        this.verifyTimeClock(false);
        if (this.isValidDescriptor(AgentEventCode.AGENT_CONFIG_CHANGED)) {
            AgentInputRequests.AgentConfigChangeRequest agentRequest = new AgentInputRequests.AgentConfigChangeRequest(this.agentId, this.agentDescriptor, configuration);
            ConfigChangedEvent configurationChangedEvent = AgentEventsFactory.createAgentConfigChangedEvent(agentRequest, this.timeClockDispatcher.getTimeClock());
            this.eventsDispatcher.addEvent(configurationChangedEvent);
            LOG.debug("{} event was added, local time: {}, event timestamp: {}", configurationChangedEvent.getClass(), System.currentTimeMillis(), configurationChangedEvent.getUtcTimestamp_ms());
        }
    }

    public <T extends AgentEvent> void sendEvent(T event) {
        if (this.isValidDescriptor(event.getType())) {
            this.eventsDispatcher.addEvent(event);
        }
    }

    public boolean sendBuildEndEvent(EndBuildEventRequest endBuildRequest) {
        return this.eventsDispatcher.sendBuildEndEvent(endBuildRequest);
    }

    protected AgentInputRequests.AgentStartRequest createAgentStartRequest() {
        return new AgentInputRequests.AgentStartRequest(this.getAgentId(), this.agentDescriptor, this.getConfigProperties(), this.getToolInfo());
    }

    protected boolean isValidDescriptor(IAgentEventType eventCode) {
        if (this.agentDescriptor == null) {
            LOG.warn("Agent descriptor is 'null', event {} cannot be sent ", (Object)eventCode);
            return false;
        }
        return true;
    }

    public abstract AgentStartInfo.ToolInfo getToolInfo();

    public abstract Map<String, String> getConfigProperties();

    @Generated
    public String getAgentId() {
        return this.agentId;
    }

    @Generated
    public AgentDescriptor getAgentDescriptor() {
        return this.agentDescriptor;
    }

    @Generated
    public AgentEventsDispatcher getEventsDispatcher() {
        return this.eventsDispatcher;
    }

    @Generated
    public TimeClockDispatcher getTimeClockDispatcher() {
        return this.timeClockDispatcher;
    }

    @Generated
    public List<TimeSyncStatus> getUnsuccessfulTimeClockSyncs() {
        return this.unsuccessfulTimeClockSyncs;
    }

    @Generated
    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    @Generated
    public void setAgentDescriptor(AgentDescriptor agentDescriptor) {
        this.agentDescriptor = agentDescriptor;
    }

    @Generated
    public void setUnsuccessfulTimeClockSyncs(List<TimeSyncStatus> unsuccessfulTimeClockSyncs) {
        this.unsuccessfulTimeClockSyncs = unsuccessfulTimeClockSyncs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentEventsController)) {
            return false;
        }
        AgentEventsController other = (AgentEventsController)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$agentId = this.getAgentId();
        String other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !this$agentId.equals(other$agentId)) {
            return false;
        }
        AgentDescriptor this$agentDescriptor = this.getAgentDescriptor();
        AgentDescriptor other$agentDescriptor = other.getAgentDescriptor();
        if (this$agentDescriptor == null ? other$agentDescriptor != null : !((Object)this$agentDescriptor).equals(other$agentDescriptor)) {
            return false;
        }
        AgentEventsDispatcher this$eventsDispatcher = this.getEventsDispatcher();
        AgentEventsDispatcher other$eventsDispatcher = other.getEventsDispatcher();
        if (this$eventsDispatcher == null ? other$eventsDispatcher != null : !this$eventsDispatcher.equals(other$eventsDispatcher)) {
            return false;
        }
        TimeClockDispatcher this$timeClockDispatcher = this.getTimeClockDispatcher();
        TimeClockDispatcher other$timeClockDispatcher = other.getTimeClockDispatcher();
        if (this$timeClockDispatcher == null ? other$timeClockDispatcher != null : !((Object)this$timeClockDispatcher).equals(other$timeClockDispatcher)) {
            return false;
        }
        List<TimeSyncStatus> this$unsuccessfulTimeClockSyncs = this.getUnsuccessfulTimeClockSyncs();
        List<TimeSyncStatus> other$unsuccessfulTimeClockSyncs = other.getUnsuccessfulTimeClockSyncs();
        return !(this$unsuccessfulTimeClockSyncs == null ? other$unsuccessfulTimeClockSyncs != null : !((Object)this$unsuccessfulTimeClockSyncs).equals(other$unsuccessfulTimeClockSyncs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AgentEventsController;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : $agentId.hashCode());
        AgentDescriptor $agentDescriptor = this.getAgentDescriptor();
        result = result * 59 + ($agentDescriptor == null ? 43 : ((Object)$agentDescriptor).hashCode());
        AgentEventsDispatcher $eventsDispatcher = this.getEventsDispatcher();
        result = result * 59 + ($eventsDispatcher == null ? 43 : $eventsDispatcher.hashCode());
        TimeClockDispatcher $timeClockDispatcher = this.getTimeClockDispatcher();
        result = result * 59 + ($timeClockDispatcher == null ? 43 : ((Object)$timeClockDispatcher).hashCode());
        List<TimeSyncStatus> $unsuccessfulTimeClockSyncs = this.getUnsuccessfulTimeClockSyncs();
        result = result * 59 + ($unsuccessfulTimeClockSyncs == null ? 43 : ((Object)$unsuccessfulTimeClockSyncs).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AgentEventsController(agentId=" + this.getAgentId() + ", agentDescriptor=" + this.getAgentDescriptor() + ", eventsDispatcher=" + this.getEventsDispatcher() + ", timeClockDispatcher=" + this.getTimeClockDispatcher() + ", unsuccessfulTimeClockSyncs=" + this.getUnsuccessfulTimeClockSyncs() + ")";
    }

    @Generated
    public void setEventsDispatcher(AgentEventsDispatcher eventsDispatcher) {
        this.eventsDispatcher = eventsDispatcher;
    }

    @Generated
    public void setTimeClockDispatcher(TimeClockDispatcher timeClockDispatcher) {
        this.timeClockDispatcher = timeClockDispatcher;
    }

    public static enum NotifMsgLevel {
        ERROR(AgentEventCode.GENERIC_ERROR, AgentEventCode.GENERIC_ERROR_SUPERUSER),
        WARNING(AgentEventCode.GENERIC_WARNING, AgentEventCode.GENERIC_WARNING_SUPERUSER),
        INFO(AgentEventCode.GENERIC_MESSAGE, AgentEventCode.GENERIC_MESSAGE_SUPERUSER);

        private final AgentEventCode msgEventCode;
        private final AgentEventCode superUserMsgEventCode;

        private NotifMsgLevel(AgentEventCode msgEventCode, AgentEventCode superUserMsgEventCode) {
            this.msgEventCode = msgEventCode;
            this.superUserMsgEventCode = superUserMsgEventCode;
        }

        @Generated
        public AgentEventCode getMsgEventCode() {
            return this.msgEventCode;
        }

        @Generated
        public AgentEventCode getSuperUserMsgEventCode() {
            return this.superUserMsgEventCode;
        }
    }
}

