/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.maven.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.w3c.dom.Document;
import org.w3c.dom.Text;

public final class PomFileUtils {
    private static final String DIGITS = "0123456789";

    public static String prepareIndentStr(String indentStr, String format) {
        char[] charArray = format.toCharArray();
        StringBuilder result = new StringBuilder();
        StringBuilder indentCntSb = new StringBuilder();
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] == '{') {
                char next;
                while (DIGITS.contains(String.valueOf(next = charArray[++i]))) {
                    indentCntSb.append(next);
                }
                PomFileUtils.indent(result, indentStr, Integer.parseInt(indentCntSb.toString()));
                indentCntSb.setLength(0);
                continue;
            }
            result.append(charArray[i]);
        }
        return result.toString();
    }

    public static String prepareIndentStr(String indentStr, int indentLevel) {
        return PomFileUtils.prepareIndentStr(indentStr, "{" + indentLevel + "}");
    }

    public static Text prepareIndentText(Document document, String indentStr, String format) {
        return document.createTextNode(PomFileUtils.prepareIndentStr(indentStr, format));
    }

    private static void indent(StringBuilder sb, String indentStr, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(indentStr);
        }
    }

    public static String modifyArgLine(String originArgLine, String propsToAdd) {
        List<String> currentValueList = Arrays.asList(originArgLine.split("\\s+"));
        List<String> propsToAddList = Arrays.asList(propsToAdd.split("\\s+"));
        ArrayList<String> newValueList = new ArrayList<String>();
        newValueList.add(originArgLine);
        for (String propToAddElement : propsToAddList) {
            if (currentValueList.contains(propToAddElement) || currentValueList.contains(propToAddElement.replace('$', '@')) || currentValueList.contains(propToAddElement.replace('@', '$'))) continue;
            newValueList.add(propToAddElement);
        }
        String result = newValueList.stream().filter(s2 -> s2 != null && !s2.isEmpty()).collect(Collectors.joining(" "));
        return result;
    }

    @Generated
    private PomFileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

