/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.maven.integration;

import io.sealights.agents.infra.integration.IntegrationLogger;
import io.sealights.agents.infra.integration.SeaLightsPluginInfo;
import io.sealights.agents.infra.integration.enums.ExecutionType;
import io.sealights.agents.infra.integration.enums.LogDestination;
import io.sealights.agents.infra.integration.maven.PluginStringBuilder;
import io.sealights.agents.infra.integration.maven.entities.PomFile;
import io.sealights.agents.infra.integration.maven.integration.MavenIntegrationInfo;
import io.sealights.agents.infra.integration.maven.integration.PluginIntegrator;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SealightsMavenPluginIntegrator
extends PluginIntegrator {
    private static final Logger LOGGER = IntegrationLogger.getLogger();
    private static final String METADATA_KEY = "metadata";
    private static final String SEALIGHTS_JVM_PARAMS_KEY = "sealightsJvmParams";
    private static final String BUILD_SCANNER_PARAMS_KEY = "buildScannerParams";
    private static final String PROFILES = "profiles";
    private static final String PROFILE = "profile";
    private static final String PLUGIN_MANAGEMENT = "pluginManagement";
    private String overridePluginVersion;
    private SeaLightsPluginInfo pluginInfo;
    private Document pomDoc;
    private MavenIntegrationInfo.SealightsProfilesInfo sealightsProfilesInfo;

    public SealightsMavenPluginIntegrator(MavenIntegrationInfo mavenIntegrationInfo, PomFile pomFile) {
        super(pomFile);
        this.pluginInfo = mavenIntegrationInfo.getSeaLightsPluginInfo();
        this.overridePluginVersion = mavenIntegrationInfo.getOverridePluginVersion();
        this.sealightsProfilesInfo = mavenIntegrationInfo.getSealightsProfilesInfo();
        this.pomDoc = pomFile.parseDocument();
    }

    public void setPomDoc() {
        this.pomFile.parseDocument();
    }

    private String toPluginText() {
        PluginStringBuilder plugin = new PluginStringBuilder(3, "    ");
        plugin.appendGroupId(this.groupId());
        plugin.appendArtifactId(this.artifactId());
        if (StringUtils.isNotEmpty(this.overridePluginVersion)) {
            plugin.appendVersion(this.overridePluginVersion);
        }
        this.addConfigurationToPluginText(plugin);
        this.addExecutionsToPluginText(plugin);
        return plugin.toString();
    }

    private void tryAddPullRequestSessionInfoToPluginText(PluginStringBuilder plugin) {
        this.tryAppendValue(plugin, String.valueOf(this.pluginInfo.isCreatePRBuildSessionId()), "createPRBuildSessionId");
        this.tryAppendValue(plugin, this.pluginInfo.getRepositoryUrl(), "repositoryUrl");
        this.tryAppendIntegerValue(plugin, this.pluginInfo.getPullRequestNumber(), "pullRequestNumber");
        this.tryAppendValue(plugin, this.pluginInfo.getLatestCommit(), "latestCommit");
        this.tryAppendValue(plugin, this.pluginInfo.getTargetBranch(), "targetBranch");
    }

    private void tryAddSessionParamsToPluginText(PluginStringBuilder plugin) {
        this.tryAppendValue(plugin, this.pluginInfo.getBuildSessionId(), "buildSessionId");
        this.tryAppendValue(plugin, this.pluginInfo.getBuildSessionIdFile(), "buildSessionIdFile");
        this.tryAppendValue(plugin, String.valueOf(this.pluginInfo.isCreateBuildSessionId()), "createBuildSessionId");
    }

    private void tryAddTokenParamsToPluginText(PluginStringBuilder plugin) {
        if (this.pluginInfo.getToken() != null) {
            this.tryAppendValue(plugin, this.pluginInfo.getToken(), "token");
        } else if (this.pluginInfo.getTokenFile() != null) {
            this.tryAppendValue(plugin, this.pluginInfo.getTokenFile(), "tokenFile");
        } else {
            this.tryAppendValue(plugin, this.pluginInfo.getCustomerId(), "customerid");
            this.tryAppendValue(plugin, this.pluginInfo.getServerUrl(), "server");
        }
    }

    private void tryAddAppParamsToPluginText(PluginStringBuilder plugin) {
        String appName = this.pluginInfo.getAppName();
        this.tryAppendValue(plugin, appName, "appName");
        this.tryAppendValue(plugin, this.pluginInfo.getModuleName(), "moduleName");
        if (this.pluginInfo.isModuleNameArtifactId()) {
            this.appendBooleanValue(plugin, true, "moduleNameArtifactId");
        }
        this.tryAppendValue(plugin, this.pluginInfo.getWorkspacepath(), "workspacepath");
        this.tryAppendValue(plugin, this.pluginInfo.getBuildName(), "build");
        this.tryAppendValue(plugin, this.pluginInfo.getBranchName(), "branch");
        this.tryAppendValue(plugin, this.pluginInfo.getPackagesIncluded(), "packagesincluded");
    }

    private void tryAddExcludesToPluginText(PluginStringBuilder plugin) {
        if (StringUtils.isNotEmpty(this.pluginInfo.getPackagesExcluded())) {
            plugin.appendTextTag("packagesexcluded", "*FastClassByGuice*, *ByCGLIB*, *EnhancerByMockitoWithCGLIB*, *EnhancerBySpringCGLIB*, " + this.pluginInfo.getPackagesExcluded());
        }
        if (StringUtils.isNotEmpty(this.pluginInfo.getClassLoadersExcluded())) {
            plugin.appendTextTag("classLoadersExcluded", "org.powermock.core.classloader.MockClassLoader, " + this.pluginInfo.getClassLoadersExcluded());
        }
        this.tryAppendValue(plugin, this.pluginInfo.getFilesExcluded(), "filesexcluded");
    }

    private void tryAddEnvironmentParamsToPluginText(PluginStringBuilder plugin) {
        this.tryAppendValue(plugin, this.pluginInfo.getFilesIncluded(), "filesincluded");
        this.tryAppendValue(plugin, this.pluginInfo.getScannerJar(), "buildScannerJar");
        this.tryAppendValue(plugin, this.pluginInfo.getListenerJar(), "testListenerJar");
        this.tryAppendValue(plugin, this.pluginInfo.getFilesStorage(), "filesStorage");
        this.tryAppendValue(plugin, this.pluginInfo.getListenerConfigFile(), "testListenerConfigFile");
        this.tryAppendValue(plugin, this.pluginInfo.getEnvironment(), "environment");
        this.tryAppendValue(plugin, this.pluginInfo.getTestStage(), "testStage");
        this.tryAppendValue(plugin, this.pluginInfo.getLabId(), "labId");
        this.tryAppendBooleanValue(plugin, this.pluginInfo.getRunFunctionalTests(), "runFunctionalTests");
    }

    private void tryAddOverrideParamsToPluginText(PluginStringBuilder plugin) {
        this.tryAppendValue(plugin, this.pluginInfo.getOverrideMetaJsonPath(), "overrideMetaJsonPath");
        this.tryAppendValue(plugin, this.pluginInfo.getOverrideTestListenerPath(), "overrideTestListenerPath");
    }

    private void tryAddLogParamsToPluginText(PluginStringBuilder plugin) {
        if (this.pluginInfo.isLogEnabled()) {
            this.appendBooleanValue(plugin, true, "logEnabled");
        }
        if (this.pluginInfo.isLogPluginMinimal()) {
            this.appendBooleanValue(plugin, true, "logPluginMinimal");
        }
        String logLevel = "OFF";
        if (this.pluginInfo.getLogLevel() != null) {
            logLevel = this.pluginInfo.getLogLevel().name();
        }
        this.tryAppendValue(plugin, logLevel, "logLevel");
        LogDestination logDestination = this.pluginInfo.getLogDestination();
        if (logDestination != null) {
            this.appendBooleanValue(plugin, true, logDestination.getPomTag());
        }
        this.tryAppendValue(plugin, this.pluginInfo.getLogFolder(), "logFolder");
    }

    private PluginStringBuilder addConfigurationToPluginText(PluginStringBuilder plugin) {
        plugin.openConfigurationTag();
        if (!this.pluginInfo.isEnabled()) {
            this.appendBooleanValue(plugin, false, "enable");
        }
        this.tryAddTokenParamsToPluginText(plugin);
        this.tryAppendValue(plugin, this.pluginInfo.getProxy(), "proxy");
        this.tryAddSessionParamsToPluginText(plugin);
        this.tryAddAppParamsToPluginText(plugin);
        if (this.pluginInfo.isCreatePRBuildSessionId()) {
            this.tryAddPullRequestSessionInfoToPluginText(plugin);
        }
        this.tryAddExcludesToPluginText(plugin);
        this.tryAddEnvironmentParamsToPluginText(plugin);
        this.tryAddOverrideParamsToPluginText(plugin);
        if (!this.pluginInfo.isRecursive()) {
            this.appendBooleanValue(plugin, false, "recursive");
        }
        this.tryAddLogParamsToPluginText(plugin);
        if (this.pluginInfo.getMetadata() != null) {
            this.addMetadataToConfigurationInPluginText(plugin);
        }
        if (this.pluginInfo.getSelightsJvmParams() != null) {
            this.addJvmParamsToConfigurationInPluginText(plugin, this.pluginInfo.getSelightsJvmParams());
        }
        if (this.pluginInfo.getSealightsJvmParams() != null) {
            this.addJvmParamsToConfigurationInPluginText(plugin, this.pluginInfo.getSealightsJvmParams());
        }
        if (this.pluginInfo.getBuildScannerParams() != null) {
            this.addBuildScannerParamsToConfigurationInPluginText(plugin);
        }
        this.appendBooleanValue(plugin, this.pluginInfo.isIncludeResources(), "includeResources");
        if (this.pluginInfo.getIncludeTokenResource() != null) {
            this.appendBooleanValue(plugin, this.pluginInfo.getIncludeTokenResource(), "includeTokenResource");
        }
        plugin.closeConfigurationTag();
        return plugin;
    }

    private PluginStringBuilder addMetadataToConfigurationInPluginText(PluginStringBuilder plugin) {
        TreeMap<String, String> metadata = new TreeMap<String, String>(this.pluginInfo.getMetadata());
        return this.addMapConfigurationToPluginText(plugin, METADATA_KEY, metadata);
    }

    private PluginStringBuilder addJvmParamsToConfigurationInPluginText(PluginStringBuilder plugin, Map<String, String> jvmParams) {
        jvmParams = new TreeMap<String, String>(jvmParams);
        return this.addMapConfigurationToPluginText(plugin, SEALIGHTS_JVM_PARAMS_KEY, jvmParams);
    }

    private PluginStringBuilder addBuildScannerParamsToConfigurationInPluginText(PluginStringBuilder plugin) {
        TreeMap<String, String> jvmParams = new TreeMap<String, String>(this.pluginInfo.getBuildScannerParams());
        return this.addMapConfigurationToPluginText(plugin, BUILD_SCANNER_PARAMS_KEY, jvmParams);
    }

    private PluginStringBuilder addMapConfigurationToPluginText(PluginStringBuilder plugin, String key, Map<String, String> configMap) {
        if (configMap != null && !configMap.isEmpty()) {
            plugin.openConfigurationMapTag(key);
            for (Map.Entry<String, String> pair : configMap.entrySet()) {
                this.tryAppendValue(plugin, pair.getValue(), pair.getKey());
            }
            plugin.closeConfigurationMapTag(key);
        }
        return plugin;
    }

    private PluginStringBuilder addExecutionsToPluginText(PluginStringBuilder plugin) {
        ExecutionType executionType;
        plugin.openExecutionsTag();
        ExecutionType executionType2 = executionType = this.pluginInfo.getExecutionType() == null ? ExecutionType.FULL : this.pluginInfo.getExecutionType();
        if (executionType.shouldRunScanner()) {
            this.appendExecution(plugin, "a1", "build-scanner");
        }
        if (executionType.shouldRunTestListener()) {
            this.appendExecution(plugin, "a2", "test-listener");
            this.appendExecution(plugin, "a3", "prepare-test-listener");
        }
        plugin.closeExecutionsTag();
        return plugin;
    }

    private void appendExecution(PluginStringBuilder plugin, String executionId, String goal) {
        plugin.openTag("execution");
        plugin.appendTextTag("id", executionId);
        plugin.openTag("goals");
        plugin.appendTextTag("goal", goal);
        plugin.closeTag("goals");
        plugin.closeTag("execution");
    }

    private void tryAppendValue(PluginStringBuilder plugin, String value, String elementName) {
        if (StringUtils.isNotEmpty(value)) {
            this.appendValue(plugin, value, elementName);
        }
    }

    private void appendValue(PluginStringBuilder plugin, String value, String elementName) {
        plugin.appendTextTag(elementName, value);
    }

    private void appendBooleanValue(PluginStringBuilder plugin, boolean value, String elementName) {
        this.appendValue(plugin, Boolean.toString(value), elementName);
    }

    private void tryAppendBooleanValue(PluginStringBuilder plugin, Boolean value, String elementName) {
        if (value != null) {
            this.appendBooleanValue(plugin, value, elementName);
        }
    }

    private void tryAppendIntegerValue(PluginStringBuilder plugin, Integer value, String elementName) {
        if (value != null) {
            this.appendValue(plugin, value.toString(), elementName);
        }
    }

    @Override
    public String artifactId() {
        return "sealights-maven-plugin";
    }

    @Override
    public String groupId() {
        return "io.sealights.on-premise.agents.plugin";
    }

    @Override
    protected void integrate() throws XPathExpressionException {
        String pluginBodyAsXml = this.toPluginText();
        this.integrate(pluginBodyAsXml, this.pomDoc.getDocumentElement());
        this.integrateToAllProfiles(pluginBodyAsXml, this.pomDoc.getDocumentElement());
        CONSOLE_LOG.debug("Integrated to plugin '" + this.pluginDescriptor() + "'.");
    }

    @Override
    public boolean isAlreadyIntegrated() {
        this.scanProfilesForSealightsIntegration();
        return this.exists() && this.sealightsProfilesInfo.isEmpty();
    }

    void scanProfilesForSealightsIntegration() {
        try {
            List<Element> profilesList = this.pomFile.getElements(PROFILES, this.pomDoc.getDocumentElement());
            for (Element profiles : profilesList) {
                List<Element> profileList = this.pomFile.getElements(PROFILE, profiles);
                for (Element profile : profileList) {
                    if (!this.pomFile.isPluginDefinedInProfile(this.artifactId(), profile)) {
                        this.sealightsProfilesInfo.addProfile(this.pomFile.resolveProfileId(profile));
                        continue;
                    }
                    if (this.sealightsProfilesInfo.isSealightsDefinedInProfilePluginManagement()) continue;
                    this.sealightsProfilesInfo.setSealightsDefinedInProfilePluginManagement(this.pomFile.isPluginExistInProfilePluginManagement(this.artifactId(), profile));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void integrateToAllProfiles(String pluginBodyAsXml, Element parent) throws XPathExpressionException {
        List<Element> profilesList = this.pomFile.getElements(PROFILES, parent);
        for (Element profiles : profilesList) {
            List<Element> profileList = this.pomFile.getElements(PROFILE, profiles);
            for (Element profile : profileList) {
                String profileId = this.pomFile.resolveProfileId(profile);
                if (this.sealightsProfilesInfo.containsProfile(profileId)) {
                    this.integrate(pluginBodyAsXml, profile);
                    continue;
                }
                LOGGER.info("'{}' already exists in the profile {}", (Object)this.artifactId(), (Object)profileId);
            }
        }
    }

    private void integrate(String pluginBodyAsXml, Element parent) throws XPathExpressionException {
        List<Element> buildElements = this.pomFile.getOrCreateElements("build", parent);
        for (Element buildElement : buildElements) {
            this.pomFile.appendToPluginsElement(this.artifactId(), pluginBodyAsXml, buildElement);
            if (!this.sealightsProfilesInfo.isSealightsDefinedInProfilePluginManagement()) {
                if (!this.pomFile.isNodeExist(PLUGIN_MANAGEMENT, buildElement)) continue;
                List<Element> pluginManagementElements = this.pomFile.getOrCreateElements(PLUGIN_MANAGEMENT, buildElement);
                if (this.pomFile.isPluginExistInPluginManagement(this.artifactId())) continue;
                this.pomFile.appendToPluginsElement(this.artifactId(), pluginBodyAsXml, pluginManagementElements.get(0));
                continue;
            }
            LOGGER.info("'{}' was not added to the project '{}', since it is already defined in '{}' of one of the profiles", this.artifactId(), PLUGIN_MANAGEMENT, PLUGIN_MANAGEMENT);
        }
    }
}

