/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.maven.integration;

import io.sealights.agents.infra.integration.maven.entities.PomFile;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;

public abstract class PluginIntegrator {
    protected static final ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    protected PomFile pomFile;

    public PluginIntegrator(PomFile pomFile) {
        this.pomFile = pomFile;
    }

    public final boolean exists() {
        return this.pomFile.isPluginExistInEntirePom(this.artifactId());
    }

    protected abstract String artifactId();

    protected abstract String groupId();

    public final String pluginDescriptor() {
        return this.groupId() + ":" + this.artifactId();
    }

    protected final String skipPropertyName() {
        return "sealights." + this.artifactId() + ".skip";
    }

    public final void integrateSafe() {
        try {
            if (this.shouldSkipIntegration()) {
                CONSOLE_LOG.info("'" + this.skipPropertyName() + "' property is set to 'true'. Skipping '" + this.pluginDescriptor() + "' plugin integration.");
                return;
            }
            this.integrate();
        }
        catch (Exception e) {
            CONSOLE_LOG.error("Unable to integrate to plugin '" + this.pluginDescriptor() + "'. Error:", e);
        }
    }

    protected boolean shouldSkipIntegration() throws XPathExpressionException {
        String skipPropertyName = this.skipPropertyName();
        List<Element> propertyElementList = this.pomFile.getProperties();
        for (Element propertyElement : propertyElementList) {
            if (!skipPropertyName.equals(propertyElement.getTagName()) || !"true".equalsIgnoreCase(propertyElement.getTextContent())) continue;
            return true;
        }
        return false;
    }

    protected abstract void integrate() throws Exception;

    public abstract boolean isAlreadyIntegrated();
}

