/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.maven.integration;

import io.sealights.agents.infra.integration.IntegrationLogger;
import io.sealights.agents.infra.integration.SeaLightsPluginInfo;
import io.sealights.agents.infra.integration.maven.entities.CollectedPomFiles;
import io.sealights.agents.infra.integration.maven.entities.PomFile;
import io.sealights.agents.infra.integration.maven.integration.LazerycodeJMeterPluginIntegrator;
import io.sealights.agents.infra.integration.maven.integration.MavenIntegrationInfo;
import io.sealights.agents.infra.integration.maven.integration.SealightsMavenPluginIntegrator;
import io.sealights.onpremise.agents.infra.utils.FileAndFolderUtils;
import io.sealights.onpremise.agents.infra.utils.PathUtils;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MavenIntegration {
    private static final Logger LOGGER = IntegrationLogger.getLogger();
    public static final String SYNTHETIC_FILE_NAME_INFIX = "-sl-";
    private MavenIntegrationInfo mavenIntegrationInfo;
    private boolean isJenkinsEnvironment;

    public MavenIntegration(MavenIntegrationInfo mavenIntegrationInfo) {
        this(mavenIntegrationInfo, true);
    }

    public MavenIntegration(MavenIntegrationInfo mavenIntegrationInfo, boolean isJenkinsEnvironment) {
        this.mavenIntegrationInfo = mavenIntegrationInfo;
        this.isJenkinsEnvironment = isJenkinsEnvironment;
    }

    public void integrate() {
        this.integrate(true);
    }

    public void integrate(boolean shouldBackup) {
        LOGGER.info("MavenIntegration.integrate - starting");
        CollectedPomFiles collectedPomFiles = this.mavenIntegrationInfo.getCollectedPomFiles();
        String sourceFilename = collectedPomFiles.getRootPomFile().getFilename();
        try {
            this.integrateRootPomFile(shouldBackup);
            List<PomFile> otherPomFiles = collectedPomFiles.getRemainingPomFiles();
            for (PomFile pomFile : otherPomFiles) {
                sourceFilename = pomFile.getFilename();
                this.integrateToPomFile(pomFile, shouldBackup);
            }
        }
        catch (Exception e) {
            LOGGER.error("MavenIntegration.integrate - Unable to integrate sealights to pom : " + sourceFilename + ". Error:", e);
        }
    }

    private void integrateToPomFile(PomFile pomFile, boolean shouldBackup) throws Exception {
        if (!this.shouldIntegrateToPom(pomFile)) {
            LOGGER.info("Skipping the Sealights integration with the pom '" + pomFile.getFilename() + "'.");
            return;
        }
        if (this.shouldOverrideTempPaths(pomFile)) {
            this.updateOverriddenTempPaths();
        }
        if (shouldBackup) {
            pomFile.backup(this.mavenIntegrationInfo.getSeaLightsPluginInfo().getWorkspacepath());
        }
        LOGGER.info("MavenIntegration.integrateToPomFile - About to modify pom: " + pomFile.getFilename());
        this.integrateToAllProfiles(pomFile);
    }

    private void updateOverriddenTempPaths() {
        SeaLightsPluginInfo pluginInfo = this.mavenIntegrationInfo.getSeaLightsPluginInfo();
        pluginInfo.setOverrideTestListenerPath(this.createOverrideTestListenerPath());
        pluginInfo.setOverrideMetaJsonPath(this.createOverrideMetaJsonPath());
    }

    private boolean shouldOverrideTempPaths(PomFile pomFile) {
        SeaLightsPluginInfo pluginInfo = this.mavenIntegrationInfo.getSeaLightsPluginInfo();
        LazerycodeJMeterPluginIntegrator lazerycodeJMeterPluginIntegrator = new LazerycodeJMeterPluginIntegrator(pluginInfo, pomFile);
        return lazerycodeJMeterPluginIntegrator.exists();
    }

    private boolean shouldIntegrateToPom(PomFile pomFile) {
        SeaLightsPluginInfo pluginInfo;
        LazerycodeJMeterPluginIntegrator lazerycodeJMeterPluginIntegrator;
        boolean shouldIntegrate = true;
        SealightsMavenPluginIntegrator sealightsMavenPluginIntegrator = new SealightsMavenPluginIntegrator(this.mavenIntegrationInfo, pomFile);
        if (sealightsMavenPluginIntegrator.isAlreadyIntegrated()) {
            LOGGER.info("MavenIntegration.shouldIntegrateToPom - SeaLights plugin is already defined in the the POM file. Should skip Sealights integration.");
            shouldIntegrate = false;
        }
        if (!pomFile.isValidPom(this.mavenIntegrationInfo.getSeaLightsPluginInfo().getExecutionType())) {
            LOGGER.info("MavenIntegration.shouldIntegrateToPom - invalid pom. Should skip Sealights integration.");
            shouldIntegrate = false;
        }
        if ((lazerycodeJMeterPluginIntegrator = new LazerycodeJMeterPluginIntegrator(pluginInfo = this.mavenIntegrationInfo.getSeaLightsPluginInfo(), pomFile)).isAlreadyIntegrated()) {
            LOGGER.info("MavenIntegration.shouldIntegrateToPom - Sealights is already integrated in '" + lazerycodeJMeterPluginIntegrator.pluginDescriptor() + "' plugin. Should skip Sealights integration.");
            shouldIntegrate = false;
        }
        return shouldIntegrate;
    }

    private void integrateToAllProfiles(PomFile pomFile) {
        SealightsMavenPluginIntegrator sealightsMavenPluginIntegrator = new SealightsMavenPluginIntegrator(this.mavenIntegrationInfo, pomFile);
        sealightsMavenPluginIntegrator.integrateSafe();
        SeaLightsPluginInfo pluginInfo = this.mavenIntegrationInfo.getSeaLightsPluginInfo();
        LazerycodeJMeterPluginIntegrator jmeterPluginIntegratorLazerycode = new LazerycodeJMeterPluginIntegrator(pluginInfo, pomFile);
        jmeterPluginIntegratorLazerycode.integrateSafe();
        pomFile.verifyArgLineModificationSafe(pluginInfo.getFailsafeArgLine(), pluginInfo.getSurefireArgLine());
        this.savePom(pomFile);
    }

    private void savePom(PomFile pomFile) {
        String targetFile = pomFile.getTargetFilename();
        if (StringUtils.isNullOrEmpty(targetFile)) {
            targetFile = pomFile.getFilename();
        }
        pomFile.removeSyntheticProfileIds();
        this.savePom(targetFile, pomFile);
    }

    private void savePom(String filename, PomFile pomFile) {
        try {
            pomFile.save(filename);
        }
        catch (Exception e) {
            LOGGER.error("Failed saving POM file. Error:", e);
        }
    }

    protected String createOverrideTestListenerPath() {
        String fileName = "java-test-listener_" + UUID.randomUUID() + ".jar";
        return this.createAbsolutePathInFilesStorage(fileName);
    }

    protected String createOverrideMetaJsonPath() {
        String fileName = "metadata_" + UUID.randomUUID() + ".json";
        return this.createAbsolutePathInFilesStorage(fileName);
    }

    private String createAbsolutePathInFilesStorage(String fileName) {
        String machineTmpFolder = System.getProperty("java.io.tmpdir");
        SeaLightsPluginInfo pluginInfo = this.mavenIntegrationInfo.getSeaLightsPluginInfo();
        String filesStorage = pluginInfo.getFilesStorage();
        if (StringUtils.isNotEmpty(filesStorage)) {
            return FileAndFolderUtils.join(filesStorage, fileName);
        }
        return FileAndFolderUtils.join(machineTmpFolder, "sealights", fileName);
    }

    private void integrateRootPomFile(boolean shouldBackup) throws Exception {
        PomFile rootPomFile = this.mavenIntegrationInfo.getCollectedPomFiles().getRootPomFile();
        List<PomFile> externalParentPoms = this.mavenIntegrationInfo.getCollectedPomFiles().getExternalParentPomFiles();
        if (externalParentPoms != null) {
            boolean argLineOccurs = false;
            for (int i = externalParentPoms.size() - 1; i >= 0; --i) {
                PomFile parent = externalParentPoms.get(i);
                if (!parent.hasArgsLine() && !argLineOccurs) continue;
                PomFile child = i > 0 ? externalParentPoms.get(i - 1) : rootPomFile;
                argLineOccurs = true;
                child.setParentHasArgLine(true);
                String syntheticTargetFilename = this.generateSyntheticFileName(parent.getFilename());
                parent.setTargetFilename(syntheticTargetFilename);
                this.connectPomWithParent(child, parent);
            }
            for (PomFile parent : externalParentPoms) {
                if (!parent.hasArgsLine() && !parent.parentHasArgLine()) continue;
                IntegrationLogger.logStatus("Creating synthetic parent pom file outside workspace: " + parent.getTargetFilename());
                this.integrateToPomFile(parent, true);
            }
        }
        this.integrateToPomFile(rootPomFile, shouldBackup);
    }

    private void connectPomWithParent(PomFile child, PomFile parent) throws Exception {
        Document document = child.getDocument();
        Element parentElement = child.getElements("parent", document.getDocumentElement()).get(0);
        this.removePreviousRelativePath(parentElement);
        Element relativePathElement = document.createElement("relativePath");
        String relativePathFromPomToParent = PathUtils.relativePath(parent.getTargetFilename(), PathUtils.containingDir(child.getFilename()));
        relativePathElement.setTextContent(relativePathFromPomToParent);
        parentElement.appendChild(relativePathElement);
    }

    private void removePreviousRelativePath(Element parentElement) {
        Node relativePathNode = null;
        NodeList childNodes = parentElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!node.getNodeName().equals("relativePath")) continue;
            relativePathNode = node;
        }
        if (relativePathNode != null) {
            parentElement.removeChild(relativePathNode);
        }
    }

    private String generateSyntheticFileName(String originalFileName) {
        String suffix = UUID.randomUUID().toString();
        return originalFileName + SYNTHETIC_FILE_NAME_INFIX + suffix;
    }
}

