/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.maven.integration;

import io.sealights.agents.infra.integration.SeaLightsPluginInfo;
import io.sealights.agents.infra.integration.enums.LogDestination;
import io.sealights.agents.infra.integration.enums.LogLevel;
import io.sealights.agents.infra.integration.maven.entities.PomFile;
import io.sealights.agents.infra.integration.maven.integration.PluginIntegrator;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LazerycodeJMeterPluginIntegrator
extends PluginIntegrator {
    private SeaLightsPluginInfo pluginInfo;
    private Document pomDoc;

    public LazerycodeJMeterPluginIntegrator(SeaLightsPluginInfo pluginInfo, PomFile pomFile) {
        super(pomFile);
        this.pluginInfo = pluginInfo;
        this.pomDoc = pomFile.parseDocument();
    }

    private List<Element> createArgumentElementList() throws Exception {
        ArrayList<Element> argumentElementList = new ArrayList<Element>();
        List<String> slArgumentList = LazerycodeJMeterPluginIntegrator.createSLArgumentList(this.pluginInfo, "jMeter");
        for (String arg : slArgumentList) {
            String xmlArg = "<argument>" + arg + "</argument>";
            Element argElement = this.pomFile.createElement(xmlArg);
            if (argElement == null) {
                CONSOLE_LOG.warn("Unable to add argument element '" + xmlArg + "' to '" + this.pluginDescriptor() + "' plugin.");
                continue;
            }
            argumentElementList.add(argElement);
        }
        return argumentElementList;
    }

    @Override
    protected String artifactId() {
        return "jmeter-maven-plugin";
    }

    @Override
    protected String groupId() {
        return "com.lazerycode.jmeter";
    }

    @Override
    protected void integrate() throws Exception {
        List<Element> jMeterPlugins = this.pomFile.getPluginsOccurrencesInPom(this.artifactId(), this.pomDoc.getDocumentElement());
        for (Element jMeterPlugin : jMeterPlugins) {
            Element arguments = this.getOrCreateArgumentsElement(jMeterPlugin);
            if (arguments == null) {
                CONSOLE_LOG.warn("Unable to find/create 'jMeterProcessJVMSettings/arguments' element in '" + jMeterPlugin.getBaseURI() + "'");
                continue;
            }
            List<Element> slArgumentList = this.createArgumentElementList();
            for (Element slArgument : slArgumentList) {
                arguments.appendChild(slArgument);
            }
            CONSOLE_LOG.debug("Integrated to plugin '" + this.pluginDescriptor() + "'.");
        }
    }

    private Element getOrCreateArgumentsElement(Element jMeterPlugin) {
        try {
            List<Element> executionsElementList = this.pomFile.getOrCreateElements("executions", jMeterPlugin);
            List<Element> executionElementList = this.pomFile.getOrCreateElements("execution", executionsElementList.get(0));
            List<Element> configurationElementList = this.pomFile.getOrCreateElements("configuration", executionElementList.get(0));
            List<Element> jMeterProcessJVMSettings = this.pomFile.getOrCreateElements("jMeterProcessJVMSettings", configurationElementList.get(0));
            List<Element> arguments = this.pomFile.getOrCreateElements("arguments", jMeterProcessJVMSettings.get(0));
            if (!arguments.isEmpty()) {
                return arguments.get(0);
            }
        }
        catch (Exception e) {
            CONSOLE_LOG.error("Unable to find or create 'arguments' tag in jMeter plugin. Error:", e);
        }
        return null;
    }

    private boolean isSealightsAlreadyConfigured(Element argumentsElement) throws XPathExpressionException {
        List<Element> argumentElementList = this.pomFile.getElements("argument", argumentsElement);
        for (Element e : argumentElementList) {
            String arg = e.getTextContent();
            if (!arg.contains("-Dsl.customerId") && !arg.contains("-Dsl.token")) continue;
            CONSOLE_LOG.info("Found sealights argument '" + arg + "' in '" + this.pluginDescriptor() + "' plugin. Assuming sealights is already configured. Skipping this plugin integration.");
            return true;
        }
        return false;
    }

    public static List<String> createSLArgumentList(SeaLightsPluginInfo pluginInfo, String logFolderName) throws Exception {
        String fixedListenerPath;
        ArrayList<String> argumentList = new ArrayList<String>();
        if (!pluginInfo.isEnabled()) {
            LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.enabled", "false");
        }
        LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.enableUpgrade", "false");
        if (pluginInfo.getToken() != null) {
            LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.token", pluginInfo.getToken());
        } else {
            LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.customerId", pluginInfo.getCustomerId());
            LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.server", pluginInfo.getServerUrl());
        }
        LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.buildSessionId", pluginInfo.getBuildSessionId());
        LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.proxy", pluginInfo.getProxy());
        String appName = pluginInfo.getAppName();
        LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.appName", appName);
        LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.moduleName", pluginInfo.getModuleName());
        LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.buildName", pluginInfo.getBuildName());
        LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.branchName", pluginInfo.getBranchName());
        LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.includes", pluginInfo.getPackagesIncluded());
        String packagesExcluded = "*FastClassByGuice*, *ByCGLIB*, *EnhancerByMockitoWithCGLIB*, *EnhancerBySpringCGLIB*";
        if (StringUtils.isNotEmpty(pluginInfo.getPackagesExcluded())) {
            packagesExcluded = packagesExcluded + ", " + pluginInfo.getPackagesExcluded();
        }
        LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.excludes", packagesExcluded);
        String classLoaderExcluded = "org.powermock.core.classloader.MockClassLoader";
        if (StringUtils.isNotEmpty(pluginInfo.getClassLoadersExcluded())) {
            classLoaderExcluded = classLoaderExcluded + ", " + pluginInfo.getClassLoadersExcluded();
        }
        LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.classLoadersExcluded", classLoaderExcluded);
        LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.fileStorage", pluginInfo.getFilesStorage());
        LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.config.file", pluginInfo.getListenerConfigFile());
        LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.environmentName", pluginInfo.getEnvironment());
        LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.pathToMetaJson", pluginInfo.getOverrideMetaJsonPath());
        if (pluginInfo.isLogEnabled()) {
            LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.log.enabled", "true");
            String logLevel = LogLevel.INFO.name();
            if (pluginInfo.getLogLevel() != null) {
                logLevel = pluginInfo.getLogLevel().name();
            }
            LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.log.level", logLevel);
            if (pluginInfo.getLogDestination() != null && LogDestination.FILE == pluginInfo.getLogDestination()) {
                LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.log.toFile", "true");
                LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.log.filename", "test-listener");
                LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.log.folder", pluginInfo.getLogFolder());
            }
            if (pluginInfo.getLogDestination() != null && LogDestination.CONSOLE == pluginInfo.getLogDestination()) {
                LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.log.toConsole", "true");
            }
        }
        if (pluginInfo.isLogPluginMinimal()) {
            LazerycodeJMeterPluginIntegrator.tryAppendValue(argumentList, "sl.log.pluginMinimal", "true");
        }
        if (StringUtils.isNullOrEmpty(fixedListenerPath = pluginInfo.getOverrideTestListenerPath())) {
            throw new Exception("Unable to add argument '-javaagent' to the plugin. Missing path to the java agent.");
        }
        String listenerArgument = "-javaagent:" + fixedListenerPath;
        argumentList.add(listenerArgument);
        return argumentList;
    }

    private static void tryAppendValue(List<String> argumentList, String property, String value) {
        if (StringUtils.isNotEmpty(value)) {
            argumentList.add("-D" + property + "=" + value);
        }
    }

    @Override
    public boolean isAlreadyIntegrated() {
        try {
            List<Element> jMeterPlugins = this.pomFile.getPluginsOccurrencesInPom(this.artifactId(), this.pomDoc.getDocumentElement());
            for (Element jMeterPlugin : jMeterPlugins) {
                Element arguments = this.getOrCreateArgumentsElement(jMeterPlugin);
                boolean isSealightsConfigured = this.isSealightsAlreadyConfigured(arguments);
                if (!isSealightsConfigured) continue;
                return true;
            }
        }
        catch (Exception e) {
            CONSOLE_LOG.error("Unable to check if the pom was integrated manually with Sealights. Assuming that Sealights is already integrated. Error: ", e);
            return true;
        }
        return false;
    }
}

