/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.maven.entities;

import io.sealights.agents.infra.integration.IntegrationLogger;
import io.sealights.agents.infra.integration.enums.ExecutionType;
import io.sealights.agents.infra.integration.maven.PluginStringBuilder;
import io.sealights.agents.infra.integration.maven.entities.EmptyDocument;
import io.sealights.agents.infra.integration.maven.utils.PomFileUtils;
import io.sealights.agents.infra.xml.XmlFileParser;
import io.sealights.onpremise.agents.infra.utils.PathUtils;
import io.sealights.onpremise.agents.infra.utils.TextFileUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpressionException;
import lombok.Generated;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PomFile
extends XmlFileParser {
    public static final String BACKUP_EXTENSION = ".slback";
    public static final String SYNTHETIC_PARENT_POM_PATH_FILE_NAME = "syntheticParentPomPath.slback";
    public static final String SYNTHETIC_PARENT_POM_LIST_SEPARATOR = "\n";
    protected static final Logger LOGGER = IntegrationLogger.getLogger();
    private static final String PLUGIN_XPATH = "//plugin";
    private static final String CONFIGURATION_ELEMENT = "configuration";
    private static final String ARGLINE_ELEMENT = "argLine";
    private static final String FAILSAFE_XPATH = "./artifactId[.='maven-failsafe-plugin']";
    private static final String SUREFIRE_XPATH = "./artifactId[.='maven-surefire-plugin']";
    private static final String ALL_XPATH = "*";
    private static final String PARENT_ELEMENT_NAME = "parent";
    private static final String GROUP_ID_ELEMENT_NAME = "groupId";
    private static final String ARTIFACT_ID_ELEMENT_NAME = "artifactId";
    private static final String VERSION_ELEMENT_NAME = "version";
    private static final String RELATIVE_PATH_ELEMENT_NAME = "relativePath";
    private static final List<String> TEST_PLUGIN_NAMES = Arrays.asList("maven-surefire-plugin", "maven-failsafe-plugin");
    public static final int PLUGIN_INDENT_LEVEL = 3;
    public static final String POM_INTENT_STR = "    ";
    private ParentProject parentProject;
    private Project project = new Project();
    private final boolean isExternalParent;
    private final String uniqueIdPrefix;
    protected String targetFilename;
    private boolean parentHasArgLine;

    public PomFile(String filename) {
        this(filename, false);
    }

    public PomFile(String filename, boolean isExternalParent) {
        super(filename);
        this.isExternalParent = isExternalParent;
        this.parseDocument();
        this.collectProjectData();
        this.uniqueIdPrefix = UUID.randomUUID().toString();
    }

    public PomFile(String filename, String targetFilename, boolean isExternalParent) {
        this(filename, isExternalParent);
        this.targetFilename = targetFilename;
    }

    public PomFile(String filename, String targetFilename) {
        this(filename, targetFilename, false);
    }

    public boolean isPluginExistInEntirePom(String artifactId) {
        try {
            String xpath = this.buildGlobalPluginXPath(artifactId);
            boolean exists = this.isNodeExist(xpath, this.getDocumentElement());
            if (exists) {
                LOGGER.info("plugin '{}' is already defined in the project", (Object)artifactId);
            }
            return exists;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isPluginDefinedInProfile(String artifactId, Element profile) {
        return this.isPluginExistInProfile(artifactId, profile) || this.isPluginExistInProfilePluginManagement(artifactId, profile);
    }

    public boolean isPluginExistInProfile(String artifactId, Element profile) {
        try {
            String xpath = this.buildPluginInProfileXPath(artifactId, profile);
            boolean exists = this.isNodeExist(xpath, profile);
            if (exists) {
                LOGGER.info("plugin '{}' is already defined in the profile '{}' plugins", (Object)artifactId, (Object)this.resolveProfileId(profile));
            }
            return exists;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isPluginExistInProfilePluginManagement(String artifactId, Element profile) {
        try {
            String xpath = this.buildPluginInProfilePluginManagementXPath(artifactId, profile);
            boolean exists = this.isNodeExist(xpath, profile);
            if (exists) {
                LOGGER.info("plugin '{}' is already defined in the profile '{}' pluginManagement", (Object)artifactId, (Object)this.resolveProfileId(profile));
            }
            return exists;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isPluginExistInPluginManagement(String artifactId) {
        try {
            String xpath = this.buildPluginInPluginManagementXPath(artifactId);
            boolean exists = this.isNodeExist(xpath, this.getDocumentElement());
            if (exists) {
                LOGGER.info("plugin '{}' is already defined in the project pluginManagement", (Object)artifactId);
            }
            return exists;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void verifyArgLineModificationSafe(String testStage, String sealightsArgLine) {
        try {
            this.verifyArgLineModification(this.getDocumentElement(), testStage, sealightsArgLine);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isPluginInsideConfiguration(Element plugin) {
        Node item = plugin.getParentNode();
        while (item.getOwnerDocument() != null) {
            if (item.getNodeName().equals(CONFIGURATION_ELEMENT)) {
                return true;
            }
            item = item.getParentNode();
        }
        return false;
    }

    private void verifyArgLineModification(Element docElement, String failsafeArgLine, String surefireArgLine) {
        if (docElement == null) {
            LOGGER.warn("Couldn't read pom file (documentElement is null) while trying to verify surefire 'argLine' modification.");
            return;
        }
        try {
            List<Element> pluginElements = this.getElements(PLUGIN_XPATH, docElement);
            for (Element plugin : pluginElements) {
                Element argLine;
                if (this.isPluginInsideConfiguration(plugin)) continue;
                if (this.isNodeExist(SUREFIRE_XPATH, plugin)) {
                    if ("@{sealightsArgLine} ${argLine}".equals(surefireArgLine)) {
                        this.tryAddSealightsPropertiesToArgLine(plugin, surefireArgLine);
                    } else {
                        argLine = this.extractOrCreateArgLine(plugin);
                        this.modifyArgLine(argLine, " " + surefireArgLine);
                        this.addDollarArgLineToArgLineElement(argLine);
                    }
                }
                if (!this.isNodeExist(FAILSAFE_XPATH, plugin)) continue;
                argLine = this.extractOrCreateArgLine(plugin);
                this.modifyArgLine(argLine, " " + failsafeArgLine);
                this.addDollarArgLineToArgLineElement(argLine);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed while trying to verify surefire 'argLine' modification. Error:", e);
        }
    }

    private Element extractOrCreateArgLine(Element plugin) throws XPathExpressionException {
        Text indentBeforeConfigurationElement = PomFileUtils.prepareIndentText(this.getDocument(), POM_INTENT_STR, "{1}");
        Text indentAfterConfigurationElement = PomFileUtils.prepareIndentText(this.getDocument(), POM_INTENT_STR, "\n{3}");
        List<Element> configuration = this.getOrCreateElements(CONFIGURATION_ELEMENT, plugin, indentBeforeConfigurationElement, indentAfterConfigurationElement);
        Text indentBeforeArgLineElement = PomFileUtils.prepareIndentText(this.getDocument(), POM_INTENT_STR, "\n{5}");
        Text indentAfterArgLineElement = PomFileUtils.prepareIndentText(this.getDocument(), POM_INTENT_STR, "\n{4}");
        List<Element> argLineList = this.getOrCreateElements(ARGLINE_ELEMENT, configuration.get(0), indentBeforeArgLineElement, indentAfterArgLineElement);
        return argLineList.get(0);
    }

    private void addDollarArgLineToArgLineElement(Element argLine) {
        this.modifyArgLine(argLine, "${argLine}");
    }

    private void tryAddSealightsPropertiesToArgLine(Element plugin, String sealightsArgLine) throws XPathExpressionException {
        List<Element> argLineElements = this.getElements("./configuration/argLine", plugin);
        if (argLineElements.size() > 0) {
            this.modifyArgLine(argLineElements.get(0), " " + sealightsArgLine);
            Element argLine = this.extractOrCreateArgLine(plugin);
            this.addDollarArgLineToArgLineElement(argLine);
        }
    }

    private void modifyArgLine(Element argLine, String propsToAdd) {
        String originArgLine = argLine.getTextContent();
        String newArgLine = PomFileUtils.modifyArgLine(originArgLine, propsToAdd);
        argLine.setTextContent(newArgLine.trim());
    }

    public boolean isValidPom(ExecutionType targetExecutionType) {
        Element documentElement = this.getDocumentElement();
        if (documentElement == null) {
            LOGGER.warn("Couldn't read pom file (documentElement is null).");
            return false;
        }
        try {
            List<Element> pluginElements = this.getElements(PLUGIN_XPATH, documentElement);
            for (Element element : pluginElements) {
                if (!this.isNodeExist(SUREFIRE_XPATH, element) || this.isSurefireValid(element, targetExecutionType)) continue;
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed while trying to validate the pom. Error:", e);
            return false;
        }
        return true;
    }

    private boolean isSurefireValid(Element surefirePlugin, ExecutionType executionType) throws XPathExpressionException {
        if (executionType == ExecutionType.SCAN_ONLY) {
            return true;
        }
        if (!this.isValidForkCount(surefirePlugin)) {
            LOGGER.warn("Found an unsupported 'forkCount' value of SureFire. Value cannot be '0'.");
            System.err.println("[SeaLights Jenkins Plugin] - WARNING - Found an unsupported 'forkCount' value of SureFire. Value cannot be '0'.");
            return false;
        }
        if (!this.isValidForkMode(surefirePlugin)) {
            LOGGER.warn("Found an unsupported 'forkMode' value of SureFire. Value cannot be 'never' or combination of 'perthread' with 'threadCount' of 0.");
            System.err.println("[SeaLights Jenkins Plugin] - WARNING - Found an unsupported 'forkMode' value of SureFire. Value cannot be 'never' or combination of 'perthread' with 'threadCount' of 0..");
            return false;
        }
        if (this.isParallelExist(surefirePlugin)) {
            LOGGER.warn("Found an unsupported 'parallel' value of SureFire.");
            System.err.println("[SeaLights Jenkins Plugin] - WARNING - Found an unsupported 'parallel' tag of SureFire.");
        }
        return true;
    }

    private boolean isParallelExist(Element surefirePlugin) throws XPathExpressionException {
        List<Element> forkModeElements = this.getElements("./configuration/parallel", surefirePlugin);
        return !forkModeElements.isEmpty();
    }

    private boolean isValidForkMode(Element surefirePlugin) throws XPathExpressionException {
        List<Element> forkModeElements = this.getElements("./configuration/forkMode", surefirePlugin);
        if (forkModeElements.isEmpty()) {
            return true;
        }
        Element forkMode = forkModeElements.get(0);
        String currentValue = forkMode.getTextContent();
        return (!"perthread".equalsIgnoreCase(currentValue) || this.isValidPerThreadForkMode(surefirePlugin)) && !"never".equalsIgnoreCase(currentValue);
    }

    private boolean isValidPerThreadForkMode(Element surefirePlugin) throws XPathExpressionException {
        List<Element> threadCountElements = this.getElements("./configuration/threadCount", surefirePlugin);
        if (threadCountElements.isEmpty()) {
            return false;
        }
        Element threadCountElement = threadCountElements.get(0);
        String currentValue = threadCountElement.getTextContent();
        return !"0".equals(currentValue);
    }

    private boolean isValidForkCount(Element surefirePlugin) throws XPathExpressionException {
        List<Element> forkCountElements = this.getElements("./configuration/forkCount", surefirePlugin);
        if (forkCountElements.isEmpty()) {
            return true;
        }
        Element forkCount = forkCountElements.get(0);
        String currentValue = forkCount.getTextContent();
        return !"0".equals(currentValue);
    }

    public void save(String filename) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        DOMSource domSource = new DOMSource(this.parseDocument());
        this.saveInternal(filename, transformer, domSource);
    }

    protected void saveInternal(String filename, Transformer transformer, DOMSource domSource) throws Exception {
        StreamResult streamResult = new StreamResult(new File(filename));
        transformer.transform(domSource, streamResult);
    }

    public Document parseDocument() {
        try {
            this.parse();
        }
        catch (Exception e) {
            this.setDocument(new EmptyDocument());
            LOGGER.error("Failed to get XML document. Error:", e);
        }
        return this.getDocument();
    }

    public List<Element> getPluginsOccurrencesInPom(String artifactId, Element parent) throws XPathExpressionException {
        String xpath = this.buildGlobalPluginXPath(artifactId);
        return this.getElements(xpath, parent);
    }

    private String buildGlobalPluginXPath(String artifactId) {
        return String.format("//plugin[artifactId='%s']", artifactId);
    }

    private String buildPluginInPluginManagementXPath(String artifactId) {
        return String.format("/project/build/pluginManagement/plugins/plugin[artifactId='%s']", artifactId);
    }

    private String buildPluginInProfilePluginManagementXPath(String artifactId, Element profile) throws XPathExpressionException {
        return String.format("/project/profiles/profile[id='%s']/build/pluginManagement/plugins/plugin[artifactId='%s']", this.resolveProfileId(profile), artifactId);
    }

    private String buildPluginInProfileXPath(String artifactId, Element profile) throws XPathExpressionException {
        return String.format("/project/profiles/profile[id='%s']/build/plugins/plugin[artifactId='%s']", this.resolveProfileId(profile), artifactId);
    }

    public String resolveProfileId(Element profile) throws XPathExpressionException {
        String idXpath = "./id";
        List<Element> maybeIdElement = this.getElements(idXpath, profile);
        if (maybeIdElement.isEmpty()) {
            this.addSyntheticId(profile);
        }
        return this.getElements(idXpath, profile).get(0).getFirstChild().getNodeValue();
    }

    @Override
    public boolean isNodeExist(String xpath, Element parent) throws XPathExpressionException {
        NodeList nodes = this.getNodeList(xpath, parent);
        return nodes.getLength() > 0;
    }

    private List<Element> getOrCreateElements(String name, String xpath, Element parent, Text indentBeforeChild, Text indentAfterChild) throws XPathExpressionException {
        List<Element> childElements = this.getElements(xpath, parent);
        if (childElements.isEmpty()) {
            Element child = this.getDocument().createElement(name);
            if (indentBeforeChild != null) {
                parent.appendChild(indentBeforeChild);
            }
            parent.appendChild(child);
            childElements.add(child);
            if (indentAfterChild != null) {
                parent.appendChild(indentAfterChild);
            }
        }
        return childElements;
    }

    public List<Element> getOrCreateElements(String nameAndXpath, Element parent, Text indentBeforeChild, Text indentAfterChild) throws XPathExpressionException {
        return this.getOrCreateElements(nameAndXpath, nameAndXpath, parent, indentBeforeChild, indentAfterChild);
    }

    public List<Element> getOrCreateElements(String nameAndXpath, Element parent) throws XPathExpressionException {
        return this.getOrCreateElements(nameAndXpath, parent, null, null);
    }

    public void appendToPluginsElement(String artifactId, String pluginBodyAsXml, Element parentElement, Text indentBeforeChild, Text indentAfterChild) {
        if (parentElement == null) {
            LOGGER.error("Unable to verify that 'plugins' element exists. The parent element is 'null'");
            return;
        }
        try {
            LOGGER.info("Appending '{}' to 'plugins' of '{}' element", (Object)artifactId, (Object)parentElement.getNodeName());
            List<Element> pluginsElements = this.getOrCreateElements("plugins", parentElement, indentBeforeChild, indentAfterChild);
            for (Element pluginsElement : pluginsElements) {
                this.addPluginToPluginsElement(pluginBodyAsXml, pluginsElement);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to verify that 'plugins' element exists in '" + parentElement.getBaseURI() + "'. Error: ", e);
        }
    }

    public void appendToPluginsElement(String artifactId, String pluginBodyAsXml, Element parentElement) {
        this.appendToPluginsElement(artifactId, pluginBodyAsXml, parentElement, null, null);
    }

    private void addPluginToPluginsElement(String pluginBodyAsXml, Element pluginsElement) {
        PluginStringBuilder pluginStringBuilder = new PluginStringBuilder(3, POM_INTENT_STR);
        pluginStringBuilder.openPluginTag();
        pluginStringBuilder.append(pluginBodyAsXml);
        pluginStringBuilder.closePluginTag();
        String xml = pluginStringBuilder.toString();
        Element newElement = this.createElement(xml);
        LOGGER.debug("Plugin injected to " + pluginsElement.getNodeName());
        pluginsElement.appendChild(this.getDocument().createTextNode(PomFileUtils.prepareIndentStr(POM_INTENT_STR, "{1}")));
        pluginsElement.appendChild(newElement);
        pluginsElement.appendChild(this.getDocument().createTextNode(PomFileUtils.prepareIndentStr(POM_INTENT_STR, "{2}\n")));
        pluginsElement.appendChild(this.getDocument().createTextNode(PomFileUtils.prepareIndentStr(POM_INTENT_STR, "{2}")));
    }

    public Element createElement(String xmlAsString) {
        Element element = null;
        try {
            element = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xmlAsString.getBytes(StandardCharsets.UTF_8))).getDocumentElement();
            element = (Element)this.getDocument().importNode(element, true);
        }
        catch (Exception e) {
            LOGGER.error("Unable to parse string '" + xmlAsString + "' to xml element. Error: ", e);
        }
        return element;
    }

    public List<Element> getProperties() throws XPathExpressionException {
        List<Element> propertiesElementList = this.getElements("properties", this.getDocumentElement());
        if (propertiesElementList.isEmpty()) {
            return new ArrayList<Element>();
        }
        Element propertiesElement = propertiesElementList.get(0);
        return this.getChildrenElements(propertiesElement);
    }

    public String getTargetFilename() {
        return this.targetFilename;
    }

    public void backup(String workspacePath) throws Exception {
        if (this.isExternalParent) {
            String path = workspacePath == null ? SYNTHETIC_PARENT_POM_PATH_FILE_NAME : PathUtils.join(workspacePath, SYNTHETIC_PARENT_POM_PATH_FILE_NAME);
            TextFileUtils.writeToFile(path, this.targetFilename + SYNTHETIC_PARENT_POM_LIST_SEPARATOR, false);
        } else {
            String backupFile = this.getFilename() + BACKUP_EXTENSION;
            LOGGER.info("JenkinsPomFile - creating a back up file: " + backupFile);
            Files.copy(Paths.get(this.getFilename(), new String[0]), Paths.get(backupFile, new String[0]), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
    }

    public void removeSyntheticProfileIds() {
        try {
            List<Element> profiles = this.getElements("/project/profiles/profile", this.getDocumentElement());
            for (Element profile : profiles) {
                this.removeSyntheticId(profile);
            }
        }
        catch (XPathExpressionException e) {
            LOGGER.error("Error while trying to remove synthetic profile ids.");
        }
    }

    private void removeSyntheticId(Element profile) throws XPathExpressionException {
        Element idElement = this.getElements("./id", profile).get(0);
        if (idElement.getFirstChild().getNodeValue().startsWith(this.uniqueIdPrefix)) {
            profile.removeChild(idElement);
        }
    }

    public boolean hasArgsLine() {
        List<Element> elements;
        try {
            elements = this.getElements("//plugin/configuration/argLine", this.getDocumentElement());
        }
        catch (XPathExpressionException e) {
            return false;
        }
        for (Element element : elements) {
            NodeList childNodes = element.getParentNode().getParentNode().getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node item = childNodes.item(i);
                if (!TEST_PLUGIN_NAMES.contains(item.getTextContent())) continue;
                return true;
            }
        }
        return false;
    }

    private void addSyntheticId(Element profile) {
        Element idElement = this.createElement(String.format("<id>%s-%s</id>", this.uniqueIdPrefix, profile.hashCode()));
        profile.appendChild(idElement);
    }

    private void collectProjectData() {
        try {
            for (Element element : this.getElements(ALL_XPATH, this.getDocumentElement())) {
                if (element.getTagName().equals(PARENT_ELEMENT_NAME)) {
                    this.populateParentProjectFields(element);
                }
                this.populateProjectFields(this.project, element);
            }
            this.completeProjectInfoOnParent();
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't resolve pom files '" + this.filename + "' project and parent properties.");
        }
    }

    private void completeProjectInfoOnParent() {
        if (this.parentProject == null || this.parentProject.getProject() == null) {
            return;
        }
        if (this.project.getGroupId() == null) {
            this.project.setGroupId(this.parentProject.getProject().getGroupId());
        }
        if (this.project.getArtifactId() == null) {
            this.project.setArtifactId(this.parentProject.getProject().getArtifactId());
        }
        if (this.project.getVersion() == null) {
            this.project.setVersion(this.parentProject.getProject().getVersion());
        }
    }

    private void populateParentProjectFields(Element parentElement) throws XPathExpressionException {
        this.parentProject = new ParentProject();
        for (Element element : this.getElements(ALL_XPATH, parentElement)) {
            this.populateProjectFields(this.parentProject.getProject(), element);
            if (!element.getTagName().equals(RELATIVE_PATH_ELEMENT_NAME)) continue;
            this.parentProject.setRelativePath(element.getTextContent());
        }
    }

    private void populateProjectFields(Project project, Element element) {
        String tagName;
        switch (tagName = element.getTagName()) {
            case "groupId": {
                project.setGroupId(element.getTextContent());
                break;
            }
            case "artifactId": {
                project.setArtifactId(element.getTextContent());
                break;
            }
            case "version": {
                project.setVersion(element.getTextContent());
            }
        }
    }

    public ParentProject getParentProject() {
        return this.parentProject;
    }

    public Project getProject() {
        return this.project;
    }

    public boolean parentHasArgLine() {
        return this.parentHasArgLine;
    }

    @Generated
    public boolean isExternalParent() {
        return this.isExternalParent;
    }

    @Generated
    public void setTargetFilename(String targetFilename) {
        this.targetFilename = targetFilename;
    }

    @Generated
    public void setParentHasArgLine(boolean parentHasArgLine) {
        this.parentHasArgLine = parentHasArgLine;
    }

    public static class Project {
        private String groupId;
        private String artifactId;
        private String version;

        @Generated
        public String getGroupId() {
            return this.groupId;
        }

        @Generated
        public String getArtifactId() {
            return this.artifactId;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Generated
        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        @Generated
        public void setVersion(String version) {
            this.version = version;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Project)) {
                return false;
            }
            Project other = (Project)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Project;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PomFile.Project(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ")";
        }

        @Generated
        public Project() {
        }

        @Generated
        public Project(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }
    }

    public static class ParentProject {
        private Project project;
        private String relativePath;

        public ParentProject() {
            this.project = new Project();
        }

        @Generated
        public Project getProject() {
            return this.project;
        }

        @Generated
        public String getRelativePath() {
            return this.relativePath;
        }

        @Generated
        public void setProject(Project project) {
            this.project = project;
        }

        @Generated
        public void setRelativePath(String relativePath) {
            this.relativePath = relativePath;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParentProject)) {
                return false;
            }
            ParentProject other = (ParentProject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Project this$project = this.getProject();
            Project other$project = other.getProject();
            if (this$project == null ? other$project != null : !((Object)this$project).equals(other$project)) {
                return false;
            }
            String this$relativePath = this.getRelativePath();
            String other$relativePath = other.getRelativePath();
            return !(this$relativePath == null ? other$relativePath != null : !this$relativePath.equals(other$relativePath));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParentProject;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Project $project = this.getProject();
            result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
            String $relativePath = this.getRelativePath();
            result = result * 59 + ($relativePath == null ? 43 : $relativePath.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PomFile.ParentProject(project=" + this.getProject() + ", relativePath=" + this.getRelativePath() + ")";
        }

        @Generated
        public ParentProject(Project project, String relativePath) {
            this.project = project;
            this.relativePath = relativePath;
        }
    }
}

