/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.maven;

import io.sealights.agents.infra.integration.IntegrationLogger;
import io.sealights.agents.infra.integration.maven.ExternalParentPomFinder;
import io.sealights.agents.infra.integration.maven.entities.CollectedPomFiles;
import io.sealights.agents.infra.integration.maven.entities.PomFile;
import io.sealights.onpremise.agents.infra.utils.FileAndFolderUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

public class PomFilesCollector {
    private static final Logger LOGGER = IntegrationLogger.getLogger();
    public static final String POM_FILE_EXTENSION = "pom.xml";
    private final ExternalParentPomFinder externalParentPomFinder;
    private String directoryToCollect;
    private boolean recursive;

    public PomFilesCollector(ExternalParentPomFinder externalParentPomFinder, String directoryToCollect) {
        this(externalParentPomFinder, directoryToCollect, true);
    }

    public PomFilesCollector(ExternalParentPomFinder externalParentPomFinder, String directoryToCollect, boolean recursive) {
        this.externalParentPomFinder = externalParentPomFinder;
        this.directoryToCollect = directoryToCollect;
        this.recursive = recursive;
    }

    public CollectedPomFiles collect() {
        List<File> files = this.recursive ? FileAndFolderUtils.collectFilesByExtensionRecursivelyFilesFirst(this.directoryToCollect, POM_FILE_EXTENSION) : FileAndFolderUtils.collectFolderFilesByExtention(this.directoryToCollect, POM_FILE_EXTENSION);
        return this.createPomFiles(files);
    }

    protected CollectedPomFiles createPomFiles(List<File> files) {
        ArrayList<PomFile> pomFiles = new ArrayList<PomFile>();
        if (files.isEmpty()) {
            return new CollectedPomFiles(null, null, pomFiles);
        }
        for (File file : files) {
            PomFile pomFile = new PomFile(file.getAbsolutePath());
            pomFiles.add(pomFile);
        }
        File projectRootPom = files.get(0);
        List<Object> externalParentPoms = Collections.emptyList();
        try {
            externalParentPoms = this.externalParentPomFinder.findExternalParentPoms(projectRootPom.getAbsolutePath());
        }
        catch (Exception e) {
            LOGGER.warn("There was an error when checking for external parent pom files.", e);
        }
        if (externalParentPoms.isEmpty()) {
            LOGGER.info("No external parent pom file detected.");
        } else {
            LOGGER.info("Integrating with external parent pom file(s): " + externalParentPoms);
        }
        ArrayList<PomFile> remainingPomFiles = pomFiles.size() > 1 ? pomFiles.subList(1, pomFiles.size()) : new ArrayList<PomFile>();
        return new CollectedPomFiles((PomFile)pomFiles.get(0), externalParentPoms, remainingPomFiles);
    }

    @Generated
    public ExternalParentPomFinder getExternalParentPomFinder() {
        return this.externalParentPomFinder;
    }

    @Generated
    public String getDirectoryToCollect() {
        return this.directoryToCollect;
    }

    @Generated
    public boolean isRecursive() {
        return this.recursive;
    }

    @Generated
    public void setDirectoryToCollect(String directoryToCollect) {
        this.directoryToCollect = directoryToCollect;
    }

    @Generated
    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PomFilesCollector)) {
            return false;
        }
        PomFilesCollector other = (PomFilesCollector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRecursive() != other.isRecursive()) {
            return false;
        }
        ExternalParentPomFinder this$externalParentPomFinder = this.getExternalParentPomFinder();
        ExternalParentPomFinder other$externalParentPomFinder = other.getExternalParentPomFinder();
        if (this$externalParentPomFinder == null ? other$externalParentPomFinder != null : !((Object)this$externalParentPomFinder).equals(other$externalParentPomFinder)) {
            return false;
        }
        String this$directoryToCollect = this.getDirectoryToCollect();
        String other$directoryToCollect = other.getDirectoryToCollect();
        return !(this$directoryToCollect == null ? other$directoryToCollect != null : !this$directoryToCollect.equals(other$directoryToCollect));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PomFilesCollector;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRecursive() ? 79 : 97);
        ExternalParentPomFinder $externalParentPomFinder = this.getExternalParentPomFinder();
        result = result * 59 + ($externalParentPomFinder == null ? 43 : ((Object)$externalParentPomFinder).hashCode());
        String $directoryToCollect = this.getDirectoryToCollect();
        result = result * 59 + ($directoryToCollect == null ? 43 : $directoryToCollect.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PomFilesCollector(externalParentPomFinder=" + this.getExternalParentPomFinder() + ", directoryToCollect=" + this.getDirectoryToCollect() + ", recursive=" + this.isRecursive() + ")";
    }
}

