/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.maven;

import io.sealights.agents.infra.integration.maven.utils.PomFileUtils;

public class PluginStringBuilder {
    private static final String PLUGIN_TAG = "plugin";
    private static final String GROUP_ID_TAG = "groupId";
    private static final String ARTIFACT_ID_TAG = "artifactId";
    private static final String VERSION_TAG = "version";
    private static final String CONFIGURATION_TAG = "configuration";
    private static final String EXECUTIONS_TAG = "executions";
    private int pluginIndentLevel;
    private int currentIndent;
    private String indentStr;
    private final StringBuilder sb = new StringBuilder();

    public PluginStringBuilder(int pluginIndentLevel, String indentStr) {
        this.pluginIndentLevel = pluginIndentLevel;
        this.currentIndent = pluginIndentLevel + 1;
        this.indentStr = indentStr;
    }

    private PluginStringBuilder incrementIndent() {
        ++this.currentIndent;
        return this;
    }

    private PluginStringBuilder decrementIndent() {
        --this.currentIndent;
        return this;
    }

    public PluginStringBuilder append(int indentLevel, String str) {
        this.sb.append(PomFileUtils.prepareIndentStr(this.indentStr, indentLevel)).append(str);
        return this;
    }

    public PluginStringBuilder append(String str) {
        return this.append(0, str);
    }

    public PluginStringBuilder openTag(int indentLevel, String tag) {
        return this.append(indentLevel, "<").append(tag).append(">");
    }

    public PluginStringBuilder openTag(String tag) {
        return this.openTag(this.currentIndent, tag).newLine().incrementIndent();
    }

    private PluginStringBuilder openTextTag(String tag) {
        return this.openTag(this.currentIndent, tag);
    }

    private PluginStringBuilder closeTag(int indent, String tag) {
        return this.append(indent, "</" + tag + ">").newLine();
    }

    public PluginStringBuilder closeTag(String tag) {
        return this.decrementIndent().closeTag(this.currentIndent, tag);
    }

    private PluginStringBuilder closeTextTag(String tag) {
        return this.closeTag(0, tag);
    }

    public PluginStringBuilder newLine() {
        this.sb.append("\n");
        return this;
    }

    public PluginStringBuilder openPluginTag() {
        return this.openTag(PLUGIN_TAG);
    }

    public PluginStringBuilder closePluginTag() {
        return this.closeTag(this.pluginIndentLevel, PLUGIN_TAG);
    }

    public PluginStringBuilder appendGroupId(String groupId) {
        return this.appendTextTag(GROUP_ID_TAG, groupId);
    }

    public PluginStringBuilder appendArtifactId(String artifactId) {
        return this.appendTextTag(ARTIFACT_ID_TAG, artifactId);
    }

    public PluginStringBuilder appendVersion(String version) {
        return this.appendTextTag(VERSION_TAG, version);
    }

    public PluginStringBuilder openConfigurationTag() {
        return this.openTag(CONFIGURATION_TAG);
    }

    public PluginStringBuilder closeConfigurationTag() {
        return this.closeTag(CONFIGURATION_TAG);
    }

    public PluginStringBuilder openConfigurationMapTag(String tag) {
        return this.openTag(tag);
    }

    public PluginStringBuilder closeConfigurationMapTag(String tag) {
        return this.closeTag(tag);
    }

    public PluginStringBuilder appendTextTag(String key, String value) {
        return this.openTextTag(key).append(value).closeTextTag(key);
    }

    public PluginStringBuilder openExecutionsTag() {
        return this.openTag(EXECUTIONS_TAG);
    }

    public PluginStringBuilder closeExecutionsTag() {
        return this.closeTag(EXECUTIONS_TAG);
    }

    public String toString() {
        return this.sb.toString();
    }
}

