/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.maven;

import io.sealights.agents.infra.integration.IntegrationLogger;
import io.sealights.agents.infra.integration.maven.entities.PomFile;
import io.sealights.onpremise.agents.infra.utils.FileAndFolderUtils;
import io.sealights.onpremise.agents.infra.utils.PathUtils;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

public class ExternalParentPomFinder {
    private static final Logger LOGGER = IntegrationLogger.getLogger();
    private static final String GROUP_ID_SEPARATOR = "\\.";
    private static final String CACHED_POM_FILE_NAME_SEPARATOR = "-";
    private static final String POM_IN_REPO_EXTENSION = ".pom";
    private String mavenLocalRepoPath;
    private boolean modifyParentPomRelevant;

    public ExternalParentPomFinder() {
        this(null, false);
    }

    public ExternalParentPomFinder(String mavenLocalRepoPath) {
        this(mavenLocalRepoPath, true);
    }

    private ExternalParentPomFinder(String mavenLocalRepoPath, boolean modifyParentPomRelevant) {
        this.mavenLocalRepoPath = mavenLocalRepoPath;
        this.modifyParentPomRelevant = modifyParentPomRelevant;
    }

    public List<PomFile> findExternalParentPoms(String rootPomPath) throws IOException {
        return this.findExternalParentPoms(rootPomPath, new ArrayList<PomFile>());
    }

    private List<PomFile> findExternalParentPoms(String rootPomPath, List<PomFile> results) throws IOException {
        String parentPath = this.findParentPath(rootPomPath);
        if (parentPath == null) {
            return results;
        }
        results.add(new PomFile(parentPath, true));
        return this.findExternalParentPoms(parentPath, results);
    }

    private String findParentPath(String rootPomPath) throws IOException {
        if (!this.modifyParentPomRelevant) {
            return null;
        }
        LOGGER.debug("Looking for parent pom file of pom '{}'", (Object)rootPomPath);
        PomFile pomFile = new PomFile(rootPomPath);
        PomFile.ParentProject parentProject = pomFile.getParentProject();
        if (parentProject == null) {
            return null;
        }
        String projectDir = PathUtils.containingDir(rootPomPath);
        String declaredRelativeParentPath = parentProject.getRelativePath();
        String confirmedRelativeParentPath = this.checkForRelativePathToParent(declaredRelativeParentPath, projectDir);
        if (confirmedRelativeParentPath != null) {
            return confirmedRelativeParentPath;
        }
        if (declaredRelativeParentPath != null) {
            LOGGER.warn("Relative parent path specified in '{}', but the file '{}' was not found.", (Object)rootPomPath, (Object)declaredRelativeParentPath);
            return null;
        }
        String usualParentPomPath = this.checkDirOneLevelAbove(pomFile.getParentProject().getProject(), projectDir);
        if (usualParentPomPath != null) {
            return usualParentPomPath;
        }
        if (StringUtils.isNullOrEmpty(this.mavenLocalRepoPath)) {
            LOGGER.debug("No Maven local repository path specified. Skipping check for external parent pom there.");
            return null;
        }
        LOGGER.debug("Looking for external parent pom in Maven local repository '{}'", (Object)this.mavenLocalRepoPath);
        String pomInLocalRepoPath = this.pathInRepo(pomFile.getParentProject().getProject());
        if (FileAndFolderUtils.isFileExists(pomInLocalRepoPath)) {
            this.logStatus(pomInLocalRepoPath, "local maven repository");
            return pomInLocalRepoPath;
        }
        return null;
    }

    private String checkForRelativePathToParent(String relativeParentPath, String projectDir) {
        if (relativeParentPath != null) {
            LOGGER.debug("Looking for external parent pom in relative path '{}'", (Object)relativeParentPath);
            String parentPath = new File(PathUtils.join(projectDir, relativeParentPath)).getAbsolutePath();
            if (FileAndFolderUtils.isFileExists(parentPath)) {
                this.logStatus(relativeParentPath, "relative path");
                return parentPath;
            }
        }
        return null;
    }

    private String checkDirOneLevelAbove(PomFile.Project project, String projectDir) throws IOException {
        String directoryAbove = PathUtils.containingDir(projectDir);
        List<File> pomsAbove = FileAndFolderUtils.collectFolderFilesByExtention(directoryAbove, "pom.xml");
        LOGGER.debug("Looking for external parent pom in path '{}'", (Object)directoryAbove);
        for (File pom : pomsAbove) {
            String pomPath = pom.getAbsolutePath();
            PomFile pomAbove = new PomFile(pomPath);
            if (!pomAbove.getProject().equals(project)) continue;
            if (!FileAndFolderUtils.isFileExists(pomPath)) break;
            this.logStatus(pomPath, "directory one level above workspace");
            return pomPath;
        }
        return null;
    }

    private String pathInRepo(PomFile.Project project) {
        String groupId = project.getGroupId();
        String artifactId = project.getArtifactId();
        String version = project.getVersion();
        if (StringUtils.isNullOrEmpty(groupId) || StringUtils.isNullOrEmpty(artifactId) || StringUtils.isNullOrEmpty(version)) {
            return null;
        }
        ArrayList<String> pathParts = new ArrayList<String>();
        pathParts.add(this.mavenLocalRepoPath);
        ArrayList<String> groupIdPathParts = new ArrayList<String>(Arrays.asList(groupId.split(GROUP_ID_SEPARATOR)));
        pathParts.addAll(groupIdPathParts);
        pathParts.add(artifactId);
        pathParts.add(version);
        pathParts.add(artifactId + CACHED_POM_FILE_NAME_SEPARATOR + version + POM_IN_REPO_EXTENSION);
        return PathUtils.join(pathParts.toArray(new String[0]));
    }

    private void logStatus(String parentPath, String searchStage) {
        String message = String.format("Found external parent pom: '%s' in %s", parentPath, searchStage);
        IntegrationLogger.logStatus(message);
    }

    @Generated
    public String getMavenLocalRepoPath() {
        return this.mavenLocalRepoPath;
    }

    @Generated
    public boolean isModifyParentPomRelevant() {
        return this.modifyParentPomRelevant;
    }

    @Generated
    public void setMavenLocalRepoPath(String mavenLocalRepoPath) {
        this.mavenLocalRepoPath = mavenLocalRepoPath;
    }

    @Generated
    public void setModifyParentPomRelevant(boolean modifyParentPomRelevant) {
        this.modifyParentPomRelevant = modifyParentPomRelevant;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalParentPomFinder)) {
            return false;
        }
        ExternalParentPomFinder other = (ExternalParentPomFinder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isModifyParentPomRelevant() != other.isModifyParentPomRelevant()) {
            return false;
        }
        String this$mavenLocalRepoPath = this.getMavenLocalRepoPath();
        String other$mavenLocalRepoPath = other.getMavenLocalRepoPath();
        return !(this$mavenLocalRepoPath == null ? other$mavenLocalRepoPath != null : !this$mavenLocalRepoPath.equals(other$mavenLocalRepoPath));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExternalParentPomFinder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isModifyParentPomRelevant() ? 79 : 97);
        String $mavenLocalRepoPath = this.getMavenLocalRepoPath();
        result = result * 59 + ($mavenLocalRepoPath == null ? 43 : $mavenLocalRepoPath.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ExternalParentPomFinder(mavenLocalRepoPath=" + this.getMavenLocalRepoPath() + ", modifyParentPomRelevant=" + this.isModifyParentPomRelevant() + ")";
    }
}

