/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.gradle.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.sealights.agents.infra.integration.gradle.serialization.EnvVarPlaceholderResolver;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public abstract class StringToStringMapSerializer
extends StdSerializer<Map> {
    protected static final String QUOTE = "\"";
    private static final String NULL = "null";
    protected EnvVarPlaceholderResolver envVarPlaceholderResolver = new EnvVarPlaceholderResolver();

    protected StringToStringMapSerializer() {
        super(Map.class);
    }

    protected abstract String entryBeginning();

    protected abstract String entryEnd();

    protected abstract String entryTemplate();

    protected abstract String entriesSeparator();

    protected abstract String emptyMapLiteral();

    @Override
    public void serialize(Map map2, JsonGenerator gen, SerializerProvider provider) throws IOException {
        String fieldName = gen.getOutputContext().getCurrentName();
        if (map2.isEmpty()) {
            gen.writeRawValue(fieldName + this.emptyMapLiteral());
            return;
        }
        StringBuilder serialized = new StringBuilder(fieldName + this.entryBeginning());
        this.addEntries(map2, serialized);
        serialized.append(this.entryEnd());
        gen.writeRawValue(serialized.toString());
    }

    private void addEntries(Map map2, StringBuilder serialized) {
        Iterator mapEntries = map2.entrySet().iterator();
        while (mapEntries.hasNext()) {
            Map.Entry entry = mapEntries.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.validate(key, value);
            String val = value == null ? NULL : StringUtils.inQuotes(this.envVarPlaceholderResolver.resolve((String)value));
            serialized.append(String.format(this.entryTemplate(), this.envVarPlaceholderResolver.resolve((String)key), val));
            if (!mapEntries.hasNext()) continue;
            serialized.append(this.entriesSeparator());
        }
    }

    private void validate(Object key, Object value) {
        if (this.isNullOrString(key) && this.isNullOrString(value)) {
            return;
        }
        throw new IllegalArgumentException("Trying to serialize a non-Map<String, String> mapping.");
    }

    private boolean isNullOrString(Object object) {
        return object == null || object instanceof String;
    }
}

