/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.gradle.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import io.sealights.agents.infra.integration.SeaLightsPluginInfo;
import io.sealights.agents.infra.integration.gradle.serialization.ExecutionTypeSerializer;
import io.sealights.agents.infra.integration.gradle.serialization.LogDestinationSerializer;
import io.sealights.agents.infra.integration.gradle.serialization.SeaLightsPluginInfoMixin;
import io.sealights.agents.infra.integration.gradle.serialization.StringSerializer;
import io.sealights.agents.infra.integration.gradle.serialization.groovy.StringToGroovyStringMapSerializer;
import io.sealights.agents.infra.integration.gradle.serialization.kotlin.BooleanKotlinSerializer;
import io.sealights.agents.infra.integration.gradle.serialization.kotlin.StringToKotlinStringMapSerializer;

public class PluginInfoWriter {
    private final ObjectWriter objectWriter;

    private PluginInfoWriter(ObjectWriter objectWriter) {
        this.objectWriter = objectWriter;
    }

    public static PluginInfoWriter forGroovy() {
        return new PluginInfoWriter(PluginInfoWriter.prepareObjectWriter(PluginInfoWriter.getConfigForGroovy()));
    }

    public static PluginInfoWriter forKotlin() {
        return new PluginInfoWriter(PluginInfoWriter.prepareObjectWriter(PluginInfoWriter.getConfigForKotlin()));
    }

    public String asString(SeaLightsPluginInfo pluginInfo) throws Exception {
        return this.objectWriter.writeValueAsString(pluginInfo);
    }

    private static ObjectWriter prepareObjectWriter(Module config) {
        JavaPropsMapper objectMapper = new JavaPropsMapper();
        objectMapper.addMixIn(SeaLightsPluginInfo.class, SeaLightsPluginInfoMixin.class);
        objectMapper.registerModule(config);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return objectMapper.writer();
    }

    private static Module getConfigForGroovy() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(new StringSerializer());
        simpleModule.addSerializer(new StringToGroovyStringMapSerializer());
        simpleModule.addSerializer(LogDestinationSerializer.forGroovy());
        simpleModule.addSerializer(ExecutionTypeSerializer.forGroovy());
        return simpleModule;
    }

    private static Module getConfigForKotlin() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(new StringSerializer());
        simpleModule.addSerializer(new StringToKotlinStringMapSerializer());
        simpleModule.addSerializer(LogDestinationSerializer.forKotlin());
        simpleModule.addSerializer(ExecutionTypeSerializer.forKotlin());
        simpleModule.addSerializer(Boolean.TYPE, new BooleanKotlinSerializer());
        simpleModule.addSerializer(Boolean.class, new BooleanKotlinSerializer());
        return simpleModule;
    }
}

