/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.gradle.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.sealights.agents.infra.integration.enums.LogDestination;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class LogDestinationSerializer
extends StdSerializer<LogDestination> {
    private final Map<LogDestination, String> logDestinationAssignments;

    private LogDestinationSerializer(Map<LogDestination, String> logDestinationAssignments) {
        super(LogDestination.class);
        this.logDestinationAssignments = logDestinationAssignments;
    }

    @Override
    public void serialize(LogDestination value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (!this.logDestinationAssignments.containsKey((Object)value)) {
            gen.writeRawValue("");
            return;
        }
        gen.writeRawValue(this.logDestinationAssignments.get((Object)value) + "\n");
    }

    public static LogDestinationSerializer forGroovy() {
        return new LogDestinationSerializer(LogDestinationSerializer.logDestinationToGroovyAssignment());
    }

    public static LogDestinationSerializer forKotlin() {
        return new LogDestinationSerializer(LogDestinationSerializer.logDestinationToKotlinAssignment());
    }

    private static Map<LogDestination, String> logDestinationToGroovyAssignment() {
        HashMap<LogDestination, String> mapping = new HashMap<LogDestination, String>();
        mapping.put(LogDestination.CONSOLE, "logToConsole=true");
        mapping.put(LogDestination.FILE, "logToFile=true");
        return mapping;
    }

    private static Map<LogDestination, String> logDestinationToKotlinAssignment() {
        HashMap<LogDestination, String> mapping = new HashMap<LogDestination, String>();
        mapping.put(LogDestination.CONSOLE, "isLogToConsole=true");
        mapping.put(LogDestination.FILE, "isLogToFile=true");
        return mapping;
    }
}

