/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.gradle.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.sealights.agents.infra.integration.enums.ExecutionType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ExecutionTypeSerializer
extends StdSerializer<ExecutionType> {
    private final Map<ExecutionType, String> executionTypeStringMap;

    private ExecutionTypeSerializer(Map<ExecutionType, String> executionTypeStringMap) {
        super(ExecutionType.class);
        this.executionTypeStringMap = executionTypeStringMap;
    }

    @Override
    public void serialize(ExecutionType value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (!this.executionTypeStringMap.containsKey((Object)value)) {
            gen.writeRawValue("");
            return;
        }
        gen.writeRawValue(this.executionTypeStringMap.get((Object)value) + "\n");
    }

    public static ExecutionTypeSerializer forGroovy() {
        return new ExecutionTypeSerializer(ExecutionTypeSerializer.executionTypeToGroovyAssignment());
    }

    public static ExecutionTypeSerializer forKotlin() {
        return new ExecutionTypeSerializer(ExecutionTypeSerializer.executionTypeToKotlinAssignment());
    }

    private static Map<ExecutionType, String> executionTypeToGroovyAssignment() {
        HashMap<ExecutionType, String> mapping = new HashMap<ExecutionType, String>();
        mapping.put(ExecutionType.FULL, ExecutionTypeSerializer.groovyScanOnly(false) + "\n" + ExecutionTypeSerializer.groovyTestOnly(false));
        mapping.put(ExecutionType.SCAN_ONLY, ExecutionTypeSerializer.groovyScanOnly(true));
        mapping.put(ExecutionType.TESTS_ONLY, ExecutionTypeSerializer.groovyTestOnly(true));
        return mapping;
    }

    private static Map<ExecutionType, String> executionTypeToKotlinAssignment() {
        HashMap<ExecutionType, String> mapping = new HashMap<ExecutionType, String>();
        mapping.put(ExecutionType.FULL, ExecutionTypeSerializer.kotlinScanOnly(false) + "\n" + ExecutionTypeSerializer.kotlinTestOnly(false));
        mapping.put(ExecutionType.SCAN_ONLY, ExecutionTypeSerializer.kotlinScanOnly(true));
        mapping.put(ExecutionType.TESTS_ONLY, ExecutionTypeSerializer.kotlinTestOnly(true));
        return mapping;
    }

    private static String groovyScanOnly(boolean setting) {
        return "runScanOnly=" + setting;
    }

    private static String groovyTestOnly(boolean setting) {
        return "runTestOnly=" + setting;
    }

    private static String kotlinScanOnly(boolean setting) {
        return "isRunScanOnly=" + setting;
    }

    private static String kotlinTestOnly(boolean setting) {
        return "isRunTestOnly=" + setting;
    }
}

