/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.gradle.serialization;

import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EnvVarPlaceholderResolver {
    public static final EnvVarPlaceholderResolver ENVIRONMENT_VARIABLE_RESOLVER = new EnvVarPlaceholderResolver();
    private static final String PLACEHOLDER_REGEX = "\\$\\{env:(.*?)\\}";
    private static final Pattern INTERPOLATION_PATTERN = Pattern.compile("\\$\\{env:(.*?)\\}");
    private final String getenvTemplate = "\\$\\{System.getenv(\"%s\")\\}";

    public String resolve(String s2) {
        ArrayList<String> envVars = this.extractEnvVariableNames(s2);
        if (envVars.isEmpty()) {
            return s2;
        }
        return this.substituteEnvVariableValues(s2, envVars);
    }

    private ArrayList<String> extractEnvVariableNames(String s2) {
        Matcher matcher = INTERPOLATION_PATTERN.matcher(s2);
        ArrayList<String> envVars = new ArrayList<String>();
        while (matcher.find()) {
            String envVarName = matcher.group(1);
            if (StringUtils.isNullOrEmpty(envVarName)) {
                throw new IllegalArgumentException(String.format("There is an empty environment variable placeholder in '%s' at char %d", s2, matcher.start()));
            }
            envVars.add(envVarName);
        }
        return envVars;
    }

    private String substituteEnvVariableValues(String s2, ArrayList<String> envVars) {
        String result = s2;
        for (String v : envVars) {
            Matcher matcher = INTERPOLATION_PATTERN.matcher(result);
            String value = String.format("\\$\\{System.getenv(\"%s\")\\}", v);
            result = matcher.replaceFirst(value);
        }
        return result;
    }
}

