/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.gradle.scripts;

import io.sealights.agents.infra.integration.IntegrationLogger;
import io.sealights.agents.infra.integration.gradle.scripts.CodeEvaluator;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import org.slf4j.Logger;

public class StringEvaluator {
    private static final Logger LOGGER = IntegrationLogger.getLogger();
    private CodeEvaluator codeEvaluator;

    public StringEvaluator(CodeEvaluator codeEvaluator) {
        this.codeEvaluator = codeEvaluator;
    }

    public String evaluate(String stringExpression) {
        if (stringExpression == null) {
            return null;
        }
        try {
            return this.codeEvaluator.evaluate(StringUtils.inQuotes(stringExpression)).toString();
        }
        catch (Exception e) {
            LOGGER.error("Error during evaluation of expression: \"{}\", error: {}", (Object)stringExpression, (Object)e);
            return null;
        }
    }
}

