/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.gradle.scripts;

import io.sealights.agents.infra.integration.GradleProjectConfig;
import io.sealights.agents.infra.integration.IntegrationLogger;
import io.sealights.agents.infra.integration.SeaLightsPluginInfo;
import io.sealights.agents.infra.integration.gradle.model.ScriptLanguage;
import io.sealights.agents.infra.integration.gradle.serialization.PluginInfoWriter;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class SealightsScriptGenerator {
    private static final Logger LOGGER = IntegrationLogger.getLogger();
    private static final String ORIGINAL_SCRIPT_PLACEHOLDER = "$$ORIGINAL_SCRIPT$$";
    private static final String REPO_CONFIG_PLACEHOLDER = "$$REPO_CONFIG$$";
    private static final String PLUGIN_VERSION_PLACEHOLDER = "$$PLUGIN_VERSION$$";
    private static final String EXCLUDED_PROJECTS_PLACEHOLDER = "$$EXCLUDED_PROJECTS$$";
    private static final String INCLUDED_PROJECTS_PLACEHOLDER = "$$INCLUDED_PROJECTS$$";
    private static final String CONFIG_CLOSURE_PLACEHOLDER = "$$CONFIG_CLOSURE$$";
    private static final String REPO_SECTION_PLACEHOLDER = "$$REPO_SECTION$$";
    private static final String DEFAULT_REPO_SECTION = "    repositories {\n        $$REPO_CONFIG$$\n    }";
    private static final String COMMA = ",";

    public String generate(String originalScript, SeaLightsPluginInfo pluginInfo, String pluginVersion, ScriptLanguage scriptLanguage) throws Exception {
        String template = this.readFromResources(scriptLanguage.getScriptTemplateResource());
        GradleProjectConfig gradleProjectConfig = pluginInfo.getGradleProjectConfig();
        String includedProjectsString = this.toCommaSeparatedList(gradleProjectConfig.getIncludedProjects());
        String excludedProjectsString = this.toCommaSeparatedList(gradleProjectConfig.getExcludedProjects());
        PluginInfoWriter pluginInfoWriter = scriptLanguage.getPluginInfoWriter();
        String configClosureString = pluginInfoWriter.asString(pluginInfo);
        String repoConfigParam = gradleProjectConfig.getRepoConfig();
        String repoConfig = StringUtils.isNullOrEmpty(repoConfigParam) ? scriptLanguage.getDefaultMavenRepoCode() : repoConfigParam;
        String repoSection = gradleProjectConfig.isUseOnlyProjectRepoSection() ? "" : DEFAULT_REPO_SECTION.replace(REPO_CONFIG_PLACEHOLDER, repoConfig);
        return this.fillTemplate(originalScript, pluginVersion, template, includedProjectsString, excludedProjectsString, configClosureString, repoSection);
    }

    private String fillTemplate(String originalScript, String pluginVersion, String template, String includedProjectsString, String excludedProjectsString, String configClosureString, String repoSection) {
        return template.replace(ORIGINAL_SCRIPT_PLACEHOLDER, originalScript).replace(REPO_SECTION_PLACEHOLDER, repoSection).replace(PLUGIN_VERSION_PLACEHOLDER, pluginVersion).replace(EXCLUDED_PROJECTS_PLACEHOLDER, excludedProjectsString).replace(INCLUDED_PROJECTS_PLACEHOLDER, includedProjectsString).replace(CONFIG_CLOSURE_PLACEHOLDER, configClosureString);
    }

    private String toCommaSeparatedList(List<String> strings) {
        if (strings == null || strings.isEmpty()) {
            return "";
        }
        ArrayList<String> quoted = new ArrayList<String>();
        for (String s2 : strings) {
            quoted.add(StringUtils.inQuotes(s2));
        }
        return StringUtils.join(quoted, COMMA);
    }

    private String readFromResources(String scriptTemplateResourcePath) throws IOException {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(scriptTemplateResourcePath);
        try {
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8));
            int c = 0;
            while ((c = bufferedReader.read()) != -1) {
                stringBuilder.append((char)c);
            }
            return stringBuilder.toString();
        }
        catch (Exception e) {
            LOGGER.error("Couldn't read the SeaLights integration script from resources.", e);
            throw e;
        }
    }
}

