/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.gradle.scripts;

import io.sealights.agents.infra.integration.IntegrationLogger;
import io.sealights.agents.infra.integration.PluginVersionResolver;
import io.sealights.agents.infra.integration.SeaLightsPluginInfo;
import io.sealights.agents.infra.integration.gradle.io.FilesFacade;
import io.sealights.agents.infra.integration.gradle.model.ScriptLanguage;
import io.sealights.agents.infra.integration.gradle.scripts.SealightsScriptGenerator;
import io.sealights.onpremise.agents.infra.types.Component;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.FileNotFoundException;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

public class BuildScriptIntegrator {
    private static final Logger LOGGER = IntegrationLogger.getLogger();
    public static final String BACKUP_EXTENSION = ".slback";
    private static final String FNFE_NO_SUCH_FILE_OR_DIRECTORY_MESSAGE = " (No such file or directory)";
    private static final String FNFE_ACCESS_IS_DENIED_MESSAGE = " (Access is denied)";
    private static final String FNFE_PERMISSION_DENIED_MESSAGE = " (Permission denied)";
    private final SealightsScriptGenerator sealightsScriptGenerator;
    private final PluginVersionResolver pluginVersionResolver;
    private final FilesFacade fileHandler;
    private final List<String> errors = new ArrayList<String>();
    private final String buildScriptAbsolutePath;
    private final String backupFilePath;
    private final ScriptLanguage scriptLanguage;

    public BuildScriptIntegrator(String buildScriptAbsolutePath, ScriptLanguage scriptLanguage, SealightsScriptGenerator sealightsScriptGenerator, PluginVersionResolver pluginVersionResolver, FilesFacade fileHandler) {
        this.buildScriptAbsolutePath = buildScriptAbsolutePath;
        this.scriptLanguage = scriptLanguage;
        this.sealightsScriptGenerator = sealightsScriptGenerator;
        this.pluginVersionResolver = pluginVersionResolver;
        this.fileHandler = fileHandler;
        this.backupFilePath = this.getBackupPath();
    }

    public boolean integrate(SeaLightsPluginInfo pluginInfo, String evaluatedToken) {
        boolean result;
        boolean bl = result = this.createBackupFile() && this.writeModifiedScript(pluginInfo, evaluatedToken);
        if (result) {
            LOGGER.info("Successfully finished SeaLights integration.");
        } else {
            String message = StringUtils.join(this.errors, "");
            LOGGER.error("Failed to integrate SeaLights into Gradle project: {}", (Object)message);
        }
        return result;
    }

    public boolean restoreProject() {
        boolean result;
        boolean revertedToBackup = this.revertToBackup();
        boolean backupDeleted = this.deleteBackupFile();
        boolean bl = result = revertedToBackup && backupDeleted;
        if (result) {
            LOGGER.info("Restored Gradle project with root build script '{}' to original state.", (Object)this.buildScriptAbsolutePath);
        } else {
            String message = StringUtils.join(this.errors, "");
            LOGGER.error("Restoring project finished with errors: {}", (Object)message);
        }
        return result;
    }

    private boolean createBackupFile() {
        try {
            this.fileHandler.copy(this.buildScriptAbsolutePath, this.backupFilePath);
            LOGGER.info("Created backup file '{}'.", (Object)this.backupFilePath);
            return true;
        }
        catch (Exception e) {
            LOGGER.error(String.format("Error while creating backup file '%s'", this.backupFilePath), e);
            this.addError(e);
            return false;
        }
    }

    private String generateScriptWithSeaLights(SeaLightsPluginInfo pluginInfo, String evaluatedToken) {
        try {
            String originalScript = this.fileHandler.readText(this.buildScriptAbsolutePath);
            String pluginVersion = this.pluginVersionResolver.resolve(evaluatedToken, pluginInfo, Component.GRADLE_PLUGIN);
            String generate = this.sealightsScriptGenerator.generate(originalScript, pluginInfo, pluginVersion, this.scriptLanguage);
            LOGGER.info("Integrated SeaLights to build script {}.", (Object)this.buildScriptAbsolutePath);
            return generate;
        }
        catch (Exception e) {
            LOGGER.error("Error while creating SeaLights script", e);
            this.addError(e);
            this.deleteBackupFile();
            return null;
        }
    }

    private boolean writeModifiedScript(SeaLightsPluginInfo pluginInfo, String evaluatedToken) {
        String modifiedScript = this.generateScriptWithSeaLights(pluginInfo, evaluatedToken);
        if (modifiedScript == null) {
            this.deleteBackupFile();
            return false;
        }
        try {
            this.fileHandler.write(this.buildScriptAbsolutePath, modifiedScript);
            LOGGER.info("Modified script '{}' to use SeaLights.", (Object)this.buildScriptAbsolutePath);
            return true;
        }
        catch (Exception e) {
            LOGGER.error(String.format("Error while modifying Gradle root project script '%s'", this.buildScriptAbsolutePath), e);
            this.addError(e);
            this.deleteBackupFile();
            return false;
        }
    }

    private boolean revertToBackup() {
        try {
            if (this.fileHandler.exists(this.backupFilePath)) {
                this.fileHandler.copy(this.backupFilePath, this.buildScriptAbsolutePath);
                LOGGER.info("Reverted '{}' from backup file '{}'.", (Object)this.buildScriptAbsolutePath, (Object)this.backupFilePath);
                return true;
            }
            LOGGER.error("The backup file '{}' is missing!", (Object)this.backupFilePath);
            this.addError("Backup file is missing.");
        }
        catch (Exception e) {
            LOGGER.error(String.format("Failed restoring script file '%s' from backup file '%s'", this.buildScriptAbsolutePath, this.backupFilePath), e);
            this.addError(e);
        }
        return false;
    }

    private boolean deleteBackupFile() {
        try {
            if (this.fileHandler.exists(this.backupFilePath)) {
                this.fileHandler.delete(this.backupFilePath);
                LOGGER.info("Deleted backup file '{}'.", (Object)this.backupFilePath);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error(String.format("Failed to delete the backup file '%s'", this.backupFilePath), e);
            this.addError(e);
            return false;
        }
    }

    private void addError(Exception e) {
        String exceptionMsg = e.getMessage();
        String message = e instanceof NoSuchFileException ? String.format("File '%s' is missing.", exceptionMsg) : (e instanceof AccessDeniedException ? String.format("Access to file '%s' is denied.", exceptionMsg) : (e instanceof FileNotFoundException ? this.handleFileNotFoundMessage(exceptionMsg) : exceptionMsg));
        this.addError(message);
    }

    private String handleFileNotFoundMessage(String exceptionMsg) {
        String message;
        if (exceptionMsg.endsWith(FNFE_ACCESS_IS_DENIED_MESSAGE)) {
            String filePath = this.fnfeMessageToPath(exceptionMsg, FNFE_ACCESS_IS_DENIED_MESSAGE);
            message = String.format("Access to file '%s' denied.", filePath);
        } else if (exceptionMsg.endsWith(FNFE_NO_SUCH_FILE_OR_DIRECTORY_MESSAGE)) {
            String filePath = this.fnfeMessageToPath(exceptionMsg, FNFE_NO_SUCH_FILE_OR_DIRECTORY_MESSAGE);
            message = String.format("There is no such file '%s'.", filePath);
        } else if (exceptionMsg.endsWith(FNFE_PERMISSION_DENIED_MESSAGE)) {
            String filePath = this.fnfeMessageToPath(exceptionMsg, FNFE_PERMISSION_DENIED_MESSAGE);
            message = String.format("Permission to file '%s' denied.", filePath);
        } else {
            message = exceptionMsg;
        }
        return message;
    }

    private String fnfeMessageToPath(String exceptionMsg, String fnfeNoSuchFileOrDirectoryMessage) {
        return exceptionMsg.substring(0, exceptionMsg.length() - fnfeNoSuchFileOrDirectoryMessage.length());
    }

    private void addError(String message) {
        this.errors.add("\n\t=> " + message);
    }

    private String getBackupPath() {
        return this.buildScriptAbsolutePath + BACKUP_EXTENSION;
    }

    @Generated
    public String getBuildScriptAbsolutePath() {
        return this.buildScriptAbsolutePath;
    }

    @Generated
    public ScriptLanguage getScriptLanguage() {
        return this.scriptLanguage;
    }
}

