/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.gradle.scripts;

import io.sealights.agents.infra.integration.IntegrationLogger;
import io.sealights.agents.infra.integration.PluginVersionResolver;
import io.sealights.agents.infra.integration.gradle.exceptions.GradleIntegrationException;
import io.sealights.agents.infra.integration.gradle.io.FilesFacade;
import io.sealights.agents.infra.integration.gradle.model.ScriptLanguage;
import io.sealights.agents.infra.integration.gradle.scripts.BuildScriptIntegrator;
import io.sealights.agents.infra.integration.gradle.scripts.SealightsScriptGenerator;
import io.sealights.onpremise.agents.infra.utils.PathUtils;
import org.slf4j.Logger;

public class BuildScriptFinder {
    private static final Logger LOGGER = IntegrationLogger.getLogger();
    private final SealightsScriptGenerator sealightsScriptGenerator;
    private final FilesFacade fileHandler;
    private final PluginVersionResolver versionResolver;

    public BuildScriptFinder() {
        this(new SealightsScriptGenerator(), new PluginVersionResolver(), new FilesFacade());
    }

    public BuildScriptFinder(SealightsScriptGenerator sealightsScriptGenerator, PluginVersionResolver versionResolver, FilesFacade fileHandler) {
        this.sealightsScriptGenerator = sealightsScriptGenerator;
        this.versionResolver = versionResolver;
        this.fileHandler = fileHandler;
    }

    public BuildScriptIntegrator findRootScript(String workspacePath) {
        String workspaceAbsolutePath = this.fileHandler.absolutePath(workspacePath);
        String scriptAbsolutePath = null;
        ScriptLanguage scriptLanguage = null;
        for (ScriptLanguage language : ScriptLanguage.values()) {
            scriptAbsolutePath = this.rootScriptPath(workspaceAbsolutePath, language);
            if (scriptAbsolutePath == null) continue;
            scriptLanguage = language;
            break;
        }
        if (scriptLanguage != null) {
            LOGGER.info("Found Gradle build script '{}'", (Object)scriptAbsolutePath);
            return new BuildScriptIntegrator(scriptAbsolutePath, scriptLanguage, this.sealightsScriptGenerator, this.versionResolver, this.fileHandler);
        }
        throw new GradleIntegrationException(String.format("Didn't find Gradle build script in workspace '%s'.", workspaceAbsolutePath));
    }

    private String rootScriptPath(String workspaceAbsolutePath, ScriptLanguage scriptLanguage) {
        String path = PathUtils.join(workspaceAbsolutePath, scriptLanguage.getMainScriptFileName());
        if (this.fileHandler.exists(path)) {
            return path;
        }
        return null;
    }
}

