/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.gradle.io;

import io.sealights.agents.infra.integration.IntegrationLogger;
import io.sealights.onpremise.agents.infra.utils.FileAndFolderUtils;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class FilesFacade {
    private static final Logger LOGGER = IntegrationLogger.getLogger();
    private static final int LOGGING_TEXT_CHAR_LIMIT = 30;
    private static final String ELLIPSIS = "...";

    public void copy(String sourcePath, String targetPath) {
        com.google.common.io.Files.copy(new File(sourcePath), new File(targetPath));
        LOGGER.debug("Copied file '{}' to '{}'.", (Object)sourcePath, (Object)targetPath);
    }

    public void write(String targetPath, String text) {
        File targetFile = FileAndFolderUtils.getOrCreateFile(targetPath);
        com.google.common.io.Files.write(text, targetFile, StandardCharsets.UTF_8);
        LOGGER.debug("(Re)Wrote file '{}' with string '{}'", (Object)this.truncateForLogs(text), (Object)targetPath);
    }

    public void delete(String targetPath) {
        Files.delete(Paths.get(targetPath, new String[0]));
        LOGGER.debug("Deleted file '{}'", (Object)targetPath);
    }

    public String getContainingDirPath(String path) {
        return Paths.get(path, new String[0]).getParent().toAbsolutePath().toString();
    }

    public String absolutePath(String workspacePath) {
        return FileAndFolderUtils.resolveAbsolutePath(workspacePath);
    }

    public List<String> readAllLines(String path) {
        return Files.readAllLines(Paths.get(path, new String[0]), StandardCharsets.UTF_8);
    }

    public String readText(String path) {
        List<String> lines = Files.readAllLines(Paths.get(path, new String[0]), StandardCharsets.UTF_8);
        return StringUtils.join(lines, "\n");
    }

    private String truncateForLogs(String text) {
        if (text.length() > 30) {
            return text.substring(0, 30) + ELLIPSIS;
        }
        return text;
    }

    public boolean exists(String path) {
        return new File(path).exists();
    }

    public List<String> collectFilePathsByExtentionRecursively(String path, String extension) {
        ArrayList<String> result = new ArrayList<String>();
        for (File file : FileAndFolderUtils.collectFilesByExtentionRecursively(path, extension)) {
            result.add(file.getAbsolutePath());
        }
        return result;
    }
}

