/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.gradle;

import io.sealights.agents.infra.integration.IntegrationLogger;
import io.sealights.agents.infra.integration.gradle.io.FilesFacade;
import io.sealights.agents.infra.integration.gradle.model.ScriptLanguage;
import io.sealights.onpremise.agents.infra.configuration.validation.ValidationResult;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class WorkspaceValidator {
    private static final Logger LOGGER = IntegrationLogger.getLogger();
    static final String SEALIGHTS_ALREADY_PRESENT_MSG_TEMPLATE = "SeaLights already present in file '%s', line(s): %s.";
    static final String JAVA_EXEC_WARNING_MSG_TEMPLATE = "It looks like a separate Java process is spawned in '%s', line(s): %s. SeaLights may not be applied to this new process.";
    static final String COULDNT_READ_FILE_MSG_TEMPLATE = "Couldn't read file '%s' for validation.";
    static final String WORKSPACE_MISSING_MSG_TEMPLATE = "Specified workspace directory '%s' doesn't exist.";
    private static final String JAVA_EXEC_TASK = "JavaExec";
    private static final ScriptLinesCheck SEALIGHTS_ALREADY_PRESENT_CHECK = new ScriptLinesCheck(){

        @Override
        protected boolean meetsCriterion(String line) {
            return line.contains("sealights-gradle-plugin") || line.contains("io.sealights.on-premise.agents.plugin") || line.contains("io.sealights.onpremise.agents.plugin");
        }

        @Override
        protected void handleErrors(List<Integer> affectedLinesNumbers, String filePath, ValidationResult validationResult) {
            String message = String.format(WorkspaceValidator.SEALIGHTS_ALREADY_PRESENT_MSG_TEMPLATE, filePath, affectedLinesNumbers);
            validationResult.addError(message);
        }
    };
    private static final ScriptLinesCheck SEPARATE_JAVA_PROCESS_SPAWNED_CHECK = new ScriptLinesCheck(){

        @Override
        protected boolean meetsCriterion(String line) {
            return line.contains(WorkspaceValidator.JAVA_EXEC_TASK);
        }

        @Override
        protected void handleErrors(List<Integer> affectedLinesNumbers, String filePath, ValidationResult validationResult) {
            String message = String.format(WorkspaceValidator.JAVA_EXEC_WARNING_MSG_TEMPLATE, filePath, affectedLinesNumbers);
            validationResult.addWarning(message);
        }
    };
    private final FilesFacade fileHandler;

    public WorkspaceValidator() {
        this(new FilesFacade());
    }

    public WorkspaceValidator(FilesFacade fileHandler) {
        this.fileHandler = fileHandler;
    }

    public ValidationResult validate(String path) {
        if (!this.fileHandler.exists(path)) {
            return new ValidationResult().addError(String.format(WORKSPACE_MISSING_MSG_TEMPLATE, path));
        }
        ValidationResult result = new ValidationResult();
        block2: for (ScriptLanguage language : ScriptLanguage.values()) {
            List<String> gradleScripts = this.fileHandler.collectFilePathsByExtentionRecursively(path, language.getScriptExtension());
            for (String scriptPath : gradleScripts) {
                List<String> lines;
                try {
                    lines = this.fileHandler.readAllLines(scriptPath);
                }
                catch (Exception e) {
                    result.addError(String.format(COULDNT_READ_FILE_MSG_TEMPLATE, scriptPath));
                    LOGGER.error("Validation skipped for the file '{}'. There was an error when reading this file.", (Object)scriptPath);
                    continue block2;
                }
                result.add(SEALIGHTS_ALREADY_PRESENT_CHECK.check(lines, scriptPath));
                result.add(SEPARATE_JAVA_PROCESS_SPAWNED_CHECK.check(lines, scriptPath));
            }
        }
        result.logWarnings(LOGGER);
        return result;
    }

    private static abstract class ScriptLinesCheck {
        private ScriptLinesCheck() {
        }

        public ValidationResult check(List<String> lines, String filePath) {
            ArrayList<Integer> affectedLinesNumbers = new ArrayList<Integer>();
            for (int lineNumber = 0; lineNumber < lines.size(); ++lineNumber) {
                String line = lines.get(lineNumber);
                if (!this.meetsCriterion(line)) continue;
                affectedLinesNumbers.add(lineNumber + 1);
            }
            ValidationResult result = new ValidationResult();
            if (!affectedLinesNumbers.isEmpty()) {
                this.handleErrors(affectedLinesNumbers, filePath, result);
            }
            return result;
        }

        protected abstract boolean meetsCriterion(String var1);

        protected abstract void handleErrors(List<Integer> var1, String var2, ValidationResult var3);
    }
}

