/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration.gradle;

import io.sealights.agents.infra.integration.IntegrationLogger;
import io.sealights.agents.infra.integration.SeaLightsPluginInfo;
import io.sealights.agents.infra.integration.gradle.WorkspaceValidator;
import io.sealights.agents.infra.integration.gradle.model.IntegrationParams;
import io.sealights.agents.infra.integration.gradle.scripts.BuildScriptFinder;
import io.sealights.agents.infra.integration.gradle.scripts.BuildScriptIntegrator;
import io.sealights.agents.infra.integration.gradle.scripts.StringEvaluator;
import io.sealights.agents.infra.integration.gradle.scripts.groovy.GroovyEvaluator;
import io.sealights.onpremise.agents.infra.configuration.validation.ValidationResult;
import io.sealights.onpremise.agents.infra.token.TokenData;
import io.sealights.onpremise.agents.infra.token.TokenError;
import io.sealights.onpremise.agents.infra.token.TokenParser;
import io.sealights.onpremise.agents.infra.utils.ArgumentFileReader;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class GradleIntegration {
    private static final Logger LOGGER = IntegrationLogger.getLogger();
    public static final String ERROR_PREFIX = "\n\t=> ";
    private final BuildScriptFinder buildScriptFinder;
    private final WorkspaceValidator workspaceValidator;

    public GradleIntegration() {
        this(new BuildScriptFinder(), new WorkspaceValidator());
    }

    public GradleIntegration(BuildScriptFinder buildScriptFinder, WorkspaceValidator workspaceValidator) {
        this.buildScriptFinder = buildScriptFinder;
        this.workspaceValidator = workspaceValidator;
    }

    public boolean integrate(IntegrationParams integrationParams) {
        ValidationResult workspaceValidationResult = this.workspaceValidator.validate(integrationParams.getWorkspacePath());
        if (!workspaceValidationResult.isValid()) {
            this.logWorkspaceErrors(workspaceValidationResult);
            return false;
        }
        BuildScriptIntegrator buildScriptIntegrator = this.buildScriptFinder.findRootScript(integrationParams.getWorkspacePath());
        SeaLightsPluginInfo pluginInfo = integrationParams.getPluginInfo();
        String evaluatedToken = this.evaluateToken(pluginInfo);
        if (evaluatedToken == null) {
            return false;
        }
        TokenData tokenData = TokenParser.parseAndValidate(evaluatedToken);
        if (!tokenData.isValid()) {
            this.logTokenErrors(tokenData);
            return false;
        }
        return buildScriptIntegrator.integrate(pluginInfo, evaluatedToken);
    }

    public boolean restore(String workspacePath) {
        BuildScriptIntegrator buildScriptIntegrator = this.buildScriptFinder.findRootScript(workspacePath);
        return buildScriptIntegrator.restoreProject();
    }

    private String evaluateToken(SeaLightsPluginInfo pluginInfo) {
        GroovyEvaluator codeEvaluator = new GroovyEvaluator();
        StringEvaluator stringEvaluator = new StringEvaluator(codeEvaluator);
        String evaluatedToken = stringEvaluator.evaluate(pluginInfo.getToken());
        String evaluatedTokenFile = stringEvaluator.evaluate(pluginInfo.getTokenFile());
        if (evaluatedToken == null && evaluatedTokenFile == null) {
            LOGGER.error("Couldn't evaluate the expression passed as neither token nor tokenFile");
            return null;
        }
        return ArgumentFileReader.resolve(evaluatedToken, evaluatedTokenFile);
    }

    private void logWorkspaceErrors(ValidationResult workspaceValidationResult) {
        List<String> errors = workspaceValidationResult.getErrors();
        String message = ERROR_PREFIX + StringUtils.join(errors, ERROR_PREFIX);
        LOGGER.error("Invalid workspace for Gradle integration:" + message);
    }

    private void logTokenErrors(TokenData tokenData) {
        ArrayList<String> errors = new ArrayList<String>();
        for (TokenError error : tokenData.getValidationErrors()) {
            errors.add(error.getProblem());
        }
        String message = ERROR_PREFIX + StringUtils.join(errors, ERROR_PREFIX);
        LOGGER.error("Invalid SeaLights token:" + message);
    }
}

