/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.agents.infra.integration;

import io.sealights.agents.infra.integration.IntegrationLogger;
import io.sealights.agents.infra.integration.SeaLightsPluginInfo;
import io.sealights.agents.infra.integration.VersionServiceProvider;
import io.sealights.agents.infra.integration.exceptions.IntegrationException;
import io.sealights.onpremise.agents.infra.serviceproxy.version.GetVersionResponse;
import io.sealights.onpremise.agents.infra.serviceproxy.version.VersionServiceProxy;
import io.sealights.onpremise.agents.infra.types.Component;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import org.slf4j.Logger;

public class PluginVersionResolver {
    private static final Logger LOG = IntegrationLogger.getLogger();
    private final VersionServiceProvider versionServiceProvider;

    public PluginVersionResolver() {
        this(new VersionServiceProvider());
    }

    public PluginVersionResolver(VersionServiceProvider versionServiceProvider) {
        this.versionServiceProvider = versionServiceProvider;
    }

    public String resolve(String token, SeaLightsPluginInfo pluginInfo, Component component) {
        String pluginVersion = pluginInfo.getPluginVersion();
        if (StringUtils.isNotEmpty(pluginVersion)) {
            return pluginVersion;
        }
        String version = this.fetchVersion(token, pluginInfo, component);
        if (version == null) {
            String message = String.format("Couldn't resolve gradle-plugin version based on plugin configuration '%s'", pluginInfo);
            throw new IntegrationException(message);
        }
        return version;
    }

    private String fetchVersion(String token, SeaLightsPluginInfo pluginInfo, Component component) {
        GetVersionResponse recommendedVersion;
        VersionServiceProxy versionService = this.versionServiceProvider.provideProxy(token, pluginInfo);
        try {
            recommendedVersion = versionService.getRecommendedVersion(component.getComponentArchive());
        }
        catch (Exception e) {
            LOG.error("Couldn't get the recommended version from the server. {}", (Object)e.toString());
            throw new IntegrationException(e.toString());
        }
        if (recommendedVersion == null || recommendedVersion.getAgent() == null) {
            return null;
        }
        return recommendedVersion.getAgent().getVersion();
    }
}

