/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.StringCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import java.net.URI;
import reactor.util.annotation.Nullable;

final class UriCodec
extends AbstractCodec<URI> {
    private final StringCodec delegate;

    UriCodec(ByteBufAllocator byteBufAllocator) {
        super(URI.class);
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.delegate = new StringCodec(byteBufAllocator);
    }

    @Override
    public Parameter encodeNull() {
        return this.delegate.encodeNull();
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return this.delegate.doCanDecode(type, format);
    }

    @Override
    URI doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends URI> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return URI.create(((String)this.delegate.doDecode(buffer, dataType, format, String.class)).trim());
    }

    @Override
    Parameter doEncode(URI value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.delegate.doEncode(value.toString());
    }
}

