/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractNumericCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import reactor.util.annotation.Nullable;

final class LongCodec
extends AbstractNumericCodec<Long> {
    private final ByteBufAllocator byteBufAllocator;

    LongCodec(ByteBufAllocator byteBufAllocator) {
        super(Long.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public Parameter encodeNull() {
        return LongCodec.createNull(PostgresqlObjectId.INT8, Format.FORMAT_BINARY);
    }

    @Override
    Long doDecode(ByteBuf buffer, PostgresqlObjectId dataType, Format format, @Nullable Class<? extends Long> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        Assert.requireNonNull(format, "format must not be null");
        return this.decodeNumber(buffer, dataType, format, Long.class, Number::longValue);
    }

    @Override
    Parameter doEncode(Long value) {
        Assert.requireNonNull(value, "value must not be null");
        return LongCodec.create(PostgresqlObjectId.INT8, Format.FORMAT_BINARY, () -> this.byteBufAllocator.buffer(8).writeLong(value.longValue()));
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return PostgresqlObjectId.INT8;
    }
}

