/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import reactor.util.annotation.Nullable;

final class InetAddressCodec
extends AbstractCodec<InetAddress> {
    private final ByteBufAllocator byteBufAllocator;

    InetAddressCodec(ByteBufAllocator byteBufAllocator) {
        super(InetAddress.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public Parameter encodeNull() {
        return InetAddressCodec.createNull(PostgresqlObjectId.INET, Format.FORMAT_TEXT);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.INET == type;
    }

    @Override
    InetAddress doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends InetAddress> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        try {
            if (format == Format.FORMAT_BINARY) {
                int readableBytes = buffer.readableBytes();
                if (readableBytes == 8) {
                    buffer.skipBytes(4);
                    byte[] addr = new byte[4];
                    buffer.readBytes(addr);
                    return InetAddress.getByAddress(addr);
                }
                throw new IllegalArgumentException("Cannot decode InetAddress. Available bytes: " + readableBytes);
            }
            return InetAddress.getByName(ByteBufUtils.decode(buffer));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    Parameter doEncode(InetAddress value) {
        Assert.requireNonNull(value, "value must not be null");
        return InetAddressCodec.create(PostgresqlObjectId.INET, Format.FORMAT_TEXT, () -> ByteBufUtils.encode(this.byteBufAllocator, value.getHostAddress()));
    }
}

