/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import io.r2dbc.postgresql.client.SSLMode;
import io.r2dbc.postgresql.util.Assert;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import reactor.netty.tcp.SslProvider;
import reactor.util.annotation.Nullable;

public final class SSLConfig {
    @Nullable
    private final HostnameVerifier hostnameVerifier;
    private final SSLMode sslMode;
    @Nullable
    private final Supplier<SslProvider> sslProvider;

    public SSLConfig(SSLMode sslMode, @Nullable Supplier<SslProvider> sslProvider, @Nullable HostnameVerifier hostnameVerifier) {
        if (sslMode != SSLMode.DISABLE) {
            Assert.requireNonNull(sslProvider, "Ssl provider is required for ssl mode " + (Object)((Object)sslMode));
        }
        if (sslMode.verifyPeerName()) {
            Assert.requireNonNull(hostnameVerifier, "Hostname verifier is required for ssl mode verify-full");
        }
        this.sslMode = sslMode;
        this.sslProvider = sslProvider;
        this.hostnameVerifier = hostnameVerifier;
    }

    public static SSLConfig disabled() {
        return new SSLConfig(SSLMode.DISABLE, null, (hostname, session) -> true);
    }

    HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public SSLMode getSslMode() {
        return this.sslMode;
    }

    public Supplier<SslProvider> getSslProvider() {
        if (this.sslProvider == null) {
            throw new IllegalStateException("SSL Mode disabled. SslProvider not available");
        }
        return this.sslProvider;
    }

    public SSLConfig mutateMode(SSLMode newMode) {
        return new SSLConfig(newMode, this.sslProvider, this.hostnameVerifier);
    }
}

