/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2;

import io.r2dbc.h2.ColumnSource;
import io.r2dbc.h2.H2ColumnMetadata;
import io.r2dbc.h2.codecs.Codecs;
import io.r2dbc.h2.util.Assert;
import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.RowMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.h2.result.ResultInterface;

public class H2RowMetadata
extends ColumnSource
implements RowMetadata,
Collection<String> {
    H2RowMetadata(List<H2ColumnMetadata> columnMetadatas) {
        super(Assert.requireNonNull(columnMetadatas, "columnMetadatas must not be null"));
    }

    public ColumnMetadata getColumnMetadata(int index) {
        return this.getColumn(index);
    }

    public ColumnMetadata getColumnMetadata(String name) {
        return this.getColumn(name);
    }

    @Override
    public List<H2ColumnMetadata> getColumnMetadatas() {
        return Collections.unmodifiableList(super.getColumnMetadatas());
    }

    static H2RowMetadata toRowMetadata(Codecs codecs, ResultInterface result) {
        Assert.requireNonNull(codecs, "codecs must not be null");
        Assert.requireNonNull(result, "result must not be null");
        return new H2RowMetadata(H2RowMetadata.getColumnMetadatas(codecs, result));
    }

    private static List<H2ColumnMetadata> getColumnMetadatas(Codecs codecs, ResultInterface result) {
        ArrayList<H2ColumnMetadata> columnMetadatas = new ArrayList<H2ColumnMetadata>(result.getVisibleColumnCount());
        for (int i = 0; i < result.getVisibleColumnCount(); ++i) {
            columnMetadatas.add(H2ColumnMetadata.toColumnMetadata(codecs, result, i));
        }
        return columnMetadatas;
    }

    public Collection<String> getColumnNames() {
        return this;
    }

    @Override
    public int size() {
        return this.getColumnCount();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof String) {
            return this.findColumn((String)o) != null;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<String> iterator() {
        final Iterator<H2ColumnMetadata> iterator = super.getColumnMetadatas().iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public String next() {
                return ((H2ColumnMetadata)iterator.next()).getName();
            }
        };
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toArray();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.getColumn(i).getName();
        }
        return result;
    }

    @Override
    public boolean add(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

