/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime.telemetry;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.UrlAttributes;
import io.quarkus.websockets.next.runtime.telemetry.ConnectionInterceptor;
import java.util.HashMap;
import java.util.Map;

final class TracesConnectionInterceptor
implements ConnectionInterceptor {
    static final String CONNECTION_OPENED_SPAN_CTX = "io.quarkus.websockets.next.connection-opened-span-ctx";
    private final Tracer tracer;
    private final String path;
    private final Map<String, Object> contextData;
    private final SpanKind spanKind;

    TracesConnectionInterceptor(Tracer tracer, SpanKind spanKind, String path) {
        this.tracer = tracer;
        this.path = path;
        this.contextData = new HashMap<String, Object>();
        this.spanKind = spanKind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionOpened() {
        Span span = this.tracer.spanBuilder("OPEN " + this.path).setSpanKind(this.spanKind).addLink(TracesConnectionInterceptor.previousSpanContext()).setAttribute(UrlAttributes.URL_PATH, (Object)this.path).startSpan();
        try (Scope ignored = span.makeCurrent();){
            this.contextData.put(CONNECTION_OPENED_SPAN_CTX, span.getSpanContext());
        }
        finally {
            span.end();
        }
    }

    @Override
    public void connectionOpeningFailed(Throwable cause) {
        this.tracer.spanBuilder("OPEN " + this.path).setSpanKind(this.spanKind).addLink((SpanContext)this.contextData.get(CONNECTION_OPENED_SPAN_CTX)).setAttribute(UrlAttributes.URL_PATH, (Object)this.path).startSpan().recordException(cause).end();
    }

    @Override
    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    private static SpanContext previousSpanContext() {
        Span span = Span.current();
        if (span.getSpanContext().isValid()) {
            return span.getSpanContext();
        }
        return null;
    }
}

