/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime.telemetry;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ConnectionInterceptor {
    public void connectionOpened();

    public void connectionOpeningFailed(Throwable var1);

    public Map<String, Object> getContextData();

    public static final class CompositeConnectionInterceptor
    implements ConnectionInterceptor {
        private final List<ConnectionInterceptor> leaves;

        CompositeConnectionInterceptor(List<ConnectionInterceptor> leaves) {
            this.leaves = List.copyOf(leaves);
        }

        @Override
        public void connectionOpened() {
            for (ConnectionInterceptor leaf : this.leaves) {
                leaf.connectionOpened();
            }
        }

        @Override
        public void connectionOpeningFailed(Throwable cause) {
            for (ConnectionInterceptor leaf : this.leaves) {
                leaf.connectionOpeningFailed(cause);
            }
        }

        @Override
        public Map<String, Object> getContextData() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (ConnectionInterceptor leaf : this.leaves) {
                map.putAll(leaf.getContextData());
            }
            return Collections.unmodifiableMap(map);
        }
    }
}

