/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.websockets.next.CloseReason;
import io.quarkus.websockets.next.runtime.WebSocketConnectionImpl;
import io.vertx.core.Vertx;
import jakarta.enterprise.inject.Instance;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public class SecuritySupport {
    private static final Logger LOG = Logger.getLogger(SecuritySupport.class);
    static final SecuritySupport NOOP = new SecuritySupport(null, null, null, null);
    private final Instance<CurrentIdentityAssociation> currentIdentity;
    private final SecurityIdentity identity;
    private final Runnable onClose;
    private final ManagedContext requestContext;

    SecuritySupport(Instance<CurrentIdentityAssociation> currentIdentity, SecurityIdentity identity, Vertx vertx, WebSocketConnectionImpl connection) {
        this.currentIdentity = currentIdentity;
        if (this.currentIdentity != null) {
            this.identity = Objects.requireNonNull(identity);
            this.onClose = SecuritySupport.closeConnectionWhenIdentityExpired(vertx, connection, this.identity);
        } else {
            this.identity = null;
            this.onClose = null;
        }
        this.requestContext = Arc.container().requestContext();
    }

    void start() {
        if (this.currentIdentity != null && this.requestContext.isActive()) {
            CurrentIdentityAssociation current = (CurrentIdentityAssociation)this.currentIdentity.get();
            current.setIdentity(this.identity);
        }
    }

    void onClose() {
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    private static Runnable closeConnectionWhenIdentityExpired(Vertx vertx, WebSocketConnectionImpl connection, SecurityIdentity identity) {
        Object object = identity.getAttribute("quarkus.identity.expire-time");
        if (object instanceof Long) {
            Long expireAt = (Long)object;
            long timerId = vertx.setTimer(TimeUnit.SECONDS.toMillis(expireAt) - System.currentTimeMillis(), ignored -> connection.close(new CloseReason(1008, "Authentication expired")).subscribe().with(v -> LOG.tracef("Closed connection due to expired authentication: %s", (Object)connection), e -> LOG.errorf("Unable to close connection [%s] after authentication expired due to unhandled failure: %s", (Object)connection, e)));
            return () -> vertx.cancelTimer(timerId);
        }
        return null;
    }
}

