/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.quarkus.websockets.next.runtime.WebSocketConnectionBase;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import java.util.Objects;
import org.jboss.logging.Logger;

public class ContextSupport {
    private static final Logger LOG = Logger.getLogger(ContextSupport.class);
    static final String WEB_SOCKET_CONN_KEY = WebSocketConnectionBase.class.getName();
    private final WebSocketConnectionBase connection;
    private final InjectableContext.ContextState sessionContextState;
    private final ManagedContext sessionContext;
    private final ManagedContext requestContext;

    ContextSupport(WebSocketConnectionBase connection, InjectableContext.ContextState sessionContextState, ManagedContext sessionContext, ManagedContext requestContext) {
        this.connection = connection;
        this.sessionContext = sessionContext;
        this.requestContext = requestContext;
        this.sessionContextState = sessionContext != null ? Objects.requireNonNull(sessionContextState) : null;
    }

    void start() {
        this.start(null);
    }

    void start(InjectableContext.ContextState requestContextState) {
        LOG.debugf("Start contexts: %s", (Object)this.connection);
        this.startSession();
        if (this.requestContext != null) {
            this.requestContext.activate(requestContextState);
        }
    }

    void startSession() {
        if (this.sessionContext != null) {
            this.sessionContext.activate(this.sessionContextState);
        }
    }

    void end(boolean terminateSession) {
        this.end(true, terminateSession);
    }

    void end(boolean terminateRequest, boolean terminateSession) {
        LOG.debugf("End contexts: %s [terminateRequest: %s, terminateSession: %s]", (Object)this.connection, (Object)terminateRequest, (Object)terminateSession);
        if (this.requestContext != null) {
            if (terminateRequest) {
                this.requestContext.terminate();
            } else {
                this.requestContext.deactivate();
            }
        }
        if (terminateSession) {
            this.endSession();
        } else if (this.sessionContext != null) {
            this.sessionContext.deactivate();
        }
    }

    void endSession() {
        if (this.sessionContext != null) {
            this.sessionContext.terminate();
        }
    }

    static Context createNewDuplicatedContext(Context context, WebSocketConnectionBase connection) {
        Context duplicated = VertxContext.createNewDuplicatedContext((Context)context);
        VertxContextSafetyToggle.setContextSafe((Context)duplicated, (boolean)true);
        duplicated.putLocal((Object)WEB_SOCKET_CONN_KEY, (Object)connection);
        LOG.debugf("New vertx duplicated context [%s] created: %s", (Object)duplicated, (Object)connection);
        return duplicated;
    }
}

