/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.tests;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;

public abstract class DevUIJsonRPCTest {
    protected static final Logger log = Logger.getLogger(DevUIJsonRPCTest.class);
    protected URI uri;
    private final ObjectMapper mapper = new ObjectMapper();
    private final JsonFactory factory = this.mapper.getFactory();
    private final Random random = new Random();
    private final String namespace;
    private static final LinkedBlockingDeque<String> MESSAGES = new LinkedBlockingDeque();

    public DevUIJsonRPCTest(String namespace) {
        this.namespace = namespace;
        String testUrl = (String)ConfigProvider.getConfig().getValue("test.url", String.class);
        Object nonApplicationRoot = ConfigProvider.getConfig().getOptionalValue("quarkus.http.non-application-root-path", String.class).orElse("q");
        if (!((String)nonApplicationRoot).startsWith("/")) {
            nonApplicationRoot = "/" + (String)nonApplicationRoot;
        }
        this.uri = URI.create(testUrl + (String)nonApplicationRoot + "/dev-ui/json-rpc-ws");
    }

    public JsonNode executeJsonRPCMethod(String methodName) throws Exception {
        return this.executeJsonRPCMethod(methodName, null);
    }

    public JsonNode executeJsonRPCMethod(String methodName, Map<String, String> params) throws Exception {
        try (Session session = ContainerProvider.getWebSocketContainer().connectToServer(Client.class, this.uri);){
            Assertions.assertEquals((Object)"CONNECT", (Object)MESSAGES.poll(10L, TimeUnit.SECONDS));
            int id = this.random.nextInt(Integer.MAX_VALUE);
            String request = this.createJsonRPCRequest(id, methodName, params);
            log.debug((Object)("request = " + request));
            session.getAsyncRemote().sendText(request);
            JsonNode response = this.parseJsonRPCResponse(id);
            log.debug((Object)("response = " + response.toPrettyString()));
            JsonNode jsonNode = response;
            return jsonNode;
        }
    }

    protected JsonNode toJsonNode(String json) {
        try {
            JsonParser parser = this.factory.createParser(json);
            return (JsonNode)this.mapper.readTree(parser);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private JsonNode parseJsonRPCResponse(int id) throws InterruptedException, IOException {
        return this.parseJsonRPCResponse(id, 0);
    }

    private JsonNode parseJsonRPCResponse(int id, int loopCount) throws InterruptedException, IOException {
        int responseId;
        String response = MESSAGES.poll(10L, TimeUnit.SECONDS);
        JsonNode jsonResponse = this.toJsonNode(response);
        if (jsonResponse.isObject() && (responseId = jsonResponse.get("id").asInt()) == id) {
            return jsonResponse.get("result").get("object");
        }
        if (loopCount > 10) {
            throw new RuntimeException("Too many recursions, message not returned for id [" + id + "]");
        }
        return this.parseJsonRPCResponse(id, loopCount + 1);
    }

    private String createJsonRPCRequest(int id, String methodName, Map<String, String> params) throws IOException {
        ObjectNode request = this.mapper.createObjectNode();
        request.put("jsonrpc", "2.0");
        request.put("id", id);
        request.put("method", this.namespace + "." + methodName);
        ObjectNode jsonParams = this.mapper.createObjectNode();
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, String> p : params.entrySet()) {
                jsonParams.put(p.getKey(), p.getValue());
            }
        }
        request.set("params", (JsonNode)jsonParams);
        return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)request);
    }

    @ClientEndpoint
    public static class Client {
        @OnOpen
        public void open(Session session) {
            MESSAGES.add("CONNECT");
        }

        @OnMessage
        public void message(String msg) {
            MESSAGES.add(msg);
        }
    }
}

