/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.tests;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public abstract class DevUIBuildTimeDataTest {
    protected static final Logger log = Logger.getLogger(DevUIBuildTimeDataTest.class);
    protected URI uri;
    private final ObjectMapper mapper = new ObjectMapper();
    private final JsonFactory factory = this.mapper.getFactory();
    private static final String CONST = "export const ";
    private static final String SPACE = " ";
    private static final String EQUALS = "=";
    private static final String OPEN_CURLY_BRACKET = "{";

    public DevUIBuildTimeDataTest(String namespace) {
        String testUrl = (String)ConfigProvider.getConfig().getValue("test.url", String.class);
        Object nonApplicationRoot = ConfigProvider.getConfig().getOptionalValue("quarkus.http.non-application-root-path", String.class).orElse("q");
        if (!((String)nonApplicationRoot).startsWith("/")) {
            nonApplicationRoot = "/" + (String)nonApplicationRoot;
        }
        this.uri = URI.create(testUrl + (String)nonApplicationRoot + "/dev-ui/" + namespace + "-data.js");
    }

    public JsonNode getBuildTimeData(String key) throws Exception {
        String[] kvs;
        String data = this.readDataFromUrl();
        for (String kv : kvs = data.split(CONST)) {
            if (!kv.startsWith(key + " = {")) continue;
            String json = kv.substring(kv.indexOf(EQUALS) + 1).trim();
            log.debug((Object)("json = " + json));
            return this.toJsonNode(json);
        }
        return null;
    }

    protected JsonNode toJsonNode(String json) {
        try {
            JsonParser parser = this.factory.createParser(json);
            return (JsonNode)this.mapper.readTree(parser);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String readDataFromUrl() throws MalformedURLException, IOException {
        try (Scanner scanner = new Scanner(this.uri.toURL().openStream(), StandardCharsets.UTF_8.toString());){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : null;
            return string;
        }
    }
}

