/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.MemorySize;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.undertow.runtime.DelegatingResourceManager;
import io.quarkus.undertow.runtime.KnownPathResourceManager;
import io.quarkus.undertow.runtime.QuarkusAuthMechanism;
import io.quarkus.undertow.runtime.QuarkusErrorServlet;
import io.quarkus.undertow.runtime.QuarkusExceptionHandler;
import io.quarkus.undertow.runtime.QuarkusInstanceFactory;
import io.quarkus.undertow.runtime.QuarkusUndertowAccount;
import io.quarkus.undertow.runtime.ServletHttpSecurityPolicy;
import io.quarkus.undertow.runtime.ServletRuntimeConfig;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.VertxHttpRecorder;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.undertow.httpcore.BufferAllocator;
import io.undertow.httpcore.HttpExchange;
import io.undertow.httpcore.UndertowOptionMap;
import io.undertow.httpcore.UndertowOptions;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityNotification;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.DefaultExchangeHandler;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.resource.CachingResourceManager;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.session.SessionIdGenerator;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.ExceptionHandler;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.api.ServletSessionConfig;
import io.undertow.servlet.api.ThreadSetupHandler;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.util.AttachmentKey;
import io.undertow.util.ImmediateAuthenticationMechanismFactory;
import io.undertow.vertx.VertxHttpExchange;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigInteger;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SessionTrackingMode;
import org.jboss.logging.Logger;

@Recorder
public class UndertowDeploymentRecorder {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.undertow");
    public static final HttpHandler ROOT_HANDLER = new HttpHandler(){

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            currentRoot.handleRequest(exchange);
        }
    };
    private static final List<HandlerWrapper> hotDeploymentWrappers = new CopyOnWriteArrayList<HandlerWrapper>();
    private static volatile List<Path> hotDeploymentResourcePaths;
    private static volatile HttpHandler currentRoot;
    private static volatile ServletContextImpl servletContext;
    private static final AttachmentKey<InjectableContext.ContextState> REQUEST_CONTEXT;
    protected static final int DEFAULT_BUFFER_SIZE;
    protected static final boolean DEFAULT_DIRECT_BUFFERS;
    final RuntimeValue<HttpConfiguration> httpConfiguration;

    public UndertowDeploymentRecorder(RuntimeValue<HttpConfiguration> httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
    }

    public static void setHotDeploymentResources(List<Path> resources) {
        hotDeploymentResourcePaths = resources;
    }

    public RuntimeValue<DeploymentInfo> createDeployment(String name, Set<String> knownFile, Set<String> knownDirectories, LaunchMode launchMode, ShutdownContext context, String mountPoint, String defaultCharset, String requestCharacterEncoding, String responseCharacterEncoding, boolean proactiveAuth, List<String> welcomeFiles, boolean hasSecurityCapability) {
        Object resourceManager;
        DeploymentInfo d = new DeploymentInfo();
        d.setDefaultRequestEncoding(requestCharacterEncoding);
        d.setDefaultResponseEncoding(responseCharacterEncoding);
        d.setDefaultEncoding(defaultCharset);
        d.setSessionIdGenerator((SessionIdGenerator)new QuarkusSessionIdGenerator());
        d.setClassLoader(this.getClass().getClassLoader());
        d.setDeploymentName(name);
        d.setContextPath(mountPoint);
        d.setEagerFilterInit(true);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = new ClassLoader(){};
        }
        d.setClassLoader(cl);
        if (hotDeploymentResourcePaths == null) {
            resourceManager = new KnownPathResourceManager(knownFile, knownDirectories, (ResourceManager)new ClassPathResourceManager(d.getClassLoader(), "META-INF/resources"));
        } else {
            ArrayList<Object> managers = new ArrayList<Object>();
            for (Path i : hotDeploymentResourcePaths) {
                managers.add(new PathResourceManager(i));
            }
            managers.add(new ClassPathResourceManager(d.getClassLoader(), "META-INF/resources"));
            resourceManager = new DelegatingResourceManager(managers.toArray(new ResourceManager[0]));
        }
        if (launchMode == LaunchMode.NORMAL) {
            resourceManager = new CachingResourceManager(1000, 0L, null, (ResourceManager)resourceManager, 2000);
        }
        d.setResourceManager((ResourceManager)resourceManager);
        if (welcomeFiles != null) {
            d.addWelcomePages(welcomeFiles);
        } else {
            d.addWelcomePages(new String[]{"index.html", "index.htm"});
        }
        d.addServlet(new ServletInfo("default", DefaultServlet.class).setAsyncSupported(true));
        for (HandlerWrapper i : hotDeploymentWrappers) {
            d.addOuterHandlerChainWrapper(i);
        }
        d.addAuthenticationMechanism("QUARKUS", (AuthenticationMechanismFactory)new ImmediateAuthenticationMechanismFactory((AuthenticationMechanism)QuarkusAuthMechanism.INSTANCE));
        d.setLoginConfig(new LoginConfig("QUARKUS", "QUARKUS"));
        context.addShutdownTask((Runnable)new ShutdownContext.CloseRunnable((Closeable)d.getResourceManager()));
        d.addNotificationReceiver(new NotificationReceiver(){

            public void handleNotification(SecurityNotification notification) {
                if (notification.getEventType() == SecurityNotification.EventType.AUTHENTICATED) {
                    QuarkusUndertowAccount account = (QuarkusUndertowAccount)notification.getAccount();
                    Instance instance = CDI.current().select(CurrentIdentityAssociation.class, new Annotation[0]);
                    if (instance.isResolvable()) {
                        ((CurrentIdentityAssociation)instance.get()).setIdentity(account.getSecurityIdentity());
                    }
                }
            }
        });
        if (proactiveAuth) {
            d.setAuthenticationMode(AuthenticationMode.PRO_ACTIVE);
        } else {
            d.setAuthenticationMode(AuthenticationMode.CONSTRAINT_DRIVEN);
        }
        if (hasSecurityCapability) {
            d.setIdentityManager((IdentityManager)CDI.current().select(IdentityManager.class, new Annotation[0]).get());
        }
        return new RuntimeValue((Object)d);
    }

    public static SocketAddress getHttpAddress() {
        return null;
    }

    public RuntimeValue<ServletInfo> registerServlet(RuntimeValue<DeploymentInfo> deploymentInfo, String name, Class<?> servletClass, boolean asyncSupported, int loadOnStartup, BeanContainer beanContainer, InstanceFactory<? extends Servlet> instanceFactory) throws Exception {
        QuarkusInstanceFactory factory = instanceFactory != null ? instanceFactory : new QuarkusInstanceFactory(beanContainer.beanInstanceFactory(servletClass, new Annotation[0]));
        ServletInfo servletInfo = new ServletInfo(name, servletClass, factory);
        ((DeploymentInfo)deploymentInfo.getValue()).addServlet(servletInfo);
        servletInfo.setAsyncSupported(asyncSupported);
        if (loadOnStartup > 0) {
            servletInfo.setLoadOnStartup(Integer.valueOf(loadOnStartup));
        }
        return new RuntimeValue((Object)servletInfo);
    }

    public void addServletInitParam(RuntimeValue<ServletInfo> info, String name, String value) {
        ((ServletInfo)info.getValue()).addInitParam(name, value);
    }

    public void addServletMapping(RuntimeValue<DeploymentInfo> info, String name, String mapping) throws Exception {
        ServletInfo sv = (ServletInfo)((DeploymentInfo)info.getValue()).getServlets().get(name);
        if (sv != null) {
            sv.addMapping(mapping);
        }
    }

    public void setMultipartConfig(RuntimeValue<ServletInfo> sref, String location, long fileSize, long maxRequestSize, int fileSizeThreshold) {
        MultipartConfigElement mp = new MultipartConfigElement(location, fileSize, maxRequestSize, fileSizeThreshold);
        ((ServletInfo)sref.getValue()).setMultipartConfig(mp);
    }

    public void setSecurityInfo(RuntimeValue<ServletInfo> sref, ServletSecurityInfo securityInfo) {
        ((ServletInfo)sref.getValue()).setServletSecurityInfo(securityInfo);
    }

    public void addSecurityRoleRef(RuntimeValue<ServletInfo> sref, String roleName, String roleLink) {
        ((ServletInfo)sref.getValue()).addSecurityRoleRef(roleName, roleLink);
    }

    public RuntimeValue<FilterInfo> registerFilter(RuntimeValue<DeploymentInfo> info, String name, Class<?> filterClass, boolean asyncSupported, BeanContainer beanContainer, InstanceFactory<? extends Filter> instanceFactory) throws Exception {
        QuarkusInstanceFactory factory = instanceFactory != null ? instanceFactory : new QuarkusInstanceFactory(beanContainer.beanInstanceFactory(filterClass, new Annotation[0]));
        FilterInfo filterInfo = new FilterInfo(name, filterClass, factory);
        ((DeploymentInfo)info.getValue()).addFilter(filterInfo);
        filterInfo.setAsyncSupported(asyncSupported);
        return new RuntimeValue((Object)filterInfo);
    }

    public void addFilterInitParam(RuntimeValue<FilterInfo> info, String name, String value) {
        ((FilterInfo)info.getValue()).addInitParam(name, value);
    }

    public void addFilterURLMapping(RuntimeValue<DeploymentInfo> info, String name, String mapping, DispatcherType dispatcherType) throws Exception {
        ((DeploymentInfo)info.getValue()).addFilterUrlMapping(name, mapping, dispatcherType);
    }

    public void addFilterServletNameMapping(RuntimeValue<DeploymentInfo> info, String name, String mapping, DispatcherType dispatcherType) throws Exception {
        ((DeploymentInfo)info.getValue()).addFilterServletNameMapping(name, mapping, dispatcherType);
    }

    public void registerListener(RuntimeValue<DeploymentInfo> info, Class<?> listenerClass, BeanContainer factory) {
        ((DeploymentInfo)info.getValue()).addListener(new ListenerInfo(listenerClass, new QuarkusInstanceFactory(factory.beanInstanceFactory(listenerClass, new Annotation[0]))));
    }

    public void addMimeMapping(RuntimeValue<DeploymentInfo> info, String extension, String mimeType) throws Exception {
        ((DeploymentInfo)info.getValue()).addMimeMapping(new MimeMapping(extension, mimeType));
    }

    public void addServletInitParameter(RuntimeValue<DeploymentInfo> info, String name, String value) {
        ((DeploymentInfo)info.getValue()).addInitParameter(name, value);
    }

    public void setupSecurity(DeploymentManager manager) {
        ((ServletHttpSecurityPolicy)CDI.current().select(ServletHttpSecurityPolicy.class, new Annotation[0]).get()).setDeployment(manager.getDeployment());
    }

    public Handler<RoutingContext> startUndertow(ShutdownContext shutdown, final ExecutorService executorService, final DeploymentManager manager, List<HandlerWrapper> wrappers, ServletRuntimeConfig servletRuntimeConfig) throws Exception {
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                try {
                    manager.stop();
                }
                catch (ServletException e) {
                    log.error((Object)"Failed to stop deployment", (Throwable)e);
                }
                manager.undeploy();
            }
        });
        HttpHandler main = manager.getDeployment().getHandler();
        for (HandlerWrapper i : wrappers) {
            main = i.wrap(main);
        }
        if (!manager.getDeployment().getDeploymentInfo().getContextPath().equals("/")) {
            PathHandler pathHandler = new PathHandler().addPrefixPath(manager.getDeployment().getDeploymentInfo().getContextPath(), main);
            main = pathHandler;
        }
        currentRoot = main = new CanonicalPathHandler(main);
        final DefaultExchangeHandler defaultHandler = new DefaultExchangeHandler(ROOT_HANDLER);
        final UndertowBufferAllocator allocator = new UndertowBufferAllocator(servletRuntimeConfig.directBuffers.orElse(DEFAULT_DIRECT_BUFFERS), (int)servletRuntimeConfig.bufferSize.orElse(new MemorySize(BigInteger.valueOf(DEFAULT_BUFFER_SIZE))).asLongValue());
        UndertowOptionMap.Builder undertowOptions = UndertowOptionMap.builder();
        undertowOptions.set(UndertowOptions.MAX_PARAMETERS, (Object)servletRuntimeConfig.maxParameters);
        final UndertowOptionMap undertowOptionMap = undertowOptions.getMap();
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                if (!event.request().isEnded()) {
                    event.request().pause();
                }
                event.remove("io.quarkus.vertx.http.auth-failure-handler");
                final VertxHttpExchange exchange = new VertxHttpExchange(event.request(), (BufferAllocator)allocator, (Executor)executorService, (Object)event, event.getBody());
                exchange.setPushHandler(VertxHttpRecorder.getRootHandler());
                Optional maxBodySize = ((HttpConfiguration)UndertowDeploymentRecorder.this.httpConfiguration.getValue()).limits.maxBodySize;
                if (maxBodySize.isPresent()) {
                    exchange.setMaxEntitySize(((MemorySize)maxBodySize.get()).asLongValue());
                }
                Duration readTimeout = ((HttpConfiguration)UndertowDeploymentRecorder.this.httpConfiguration.getValue()).readTimeout;
                exchange.setReadTimeout(readTimeout.toMillis());
                exchange.setUndertowOptions(undertowOptionMap);
                if (BlockingOperationControl.isBlockingAllowed()) {
                    defaultHandler.handle((HttpExchange)exchange);
                } else {
                    executorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            defaultHandler.handle((HttpExchange)exchange);
                        }
                    });
                }
            }
        };
    }

    public static void addHotDeploymentWrapper(HandlerWrapper handlerWrapper) {
        hotDeploymentWrappers.add(handlerWrapper);
    }

    public Supplier<ServletContext> servletContextSupplier() {
        return new ServletContextSupplier();
    }

    public DeploymentManager bootServletContainer(RuntimeValue<DeploymentInfo> info, final BeanContainer beanContainer, LaunchMode launchMode, ShutdownContext shutdownContext) {
        if (((DeploymentInfo)info.getValue()).getExceptionHandler() == null) {
            boolean alreadyMapped = false;
            for (ErrorPage i : ((DeploymentInfo)info.getValue()).getErrorPages()) {
                if (i.getErrorCode() == null || i.getErrorCode() != 500) continue;
                alreadyMapped = true;
                break;
            }
            if (!alreadyMapped || launchMode.isDevOrTest()) {
                ((DeploymentInfo)info.getValue()).setExceptionHandler((ExceptionHandler)new QuarkusExceptionHandler());
                ((DeploymentInfo)info.getValue()).addErrorPage(new ErrorPage("/@QuarkusError", 500));
                ((DeploymentInfo)info.getValue()).addServlet(new ServletInfo("@QuarkusError", QuarkusErrorServlet.class).addMapping("/@QuarkusError").setAsyncSupported(true).addInitParam("show-stack", Boolean.toString(launchMode.isDevOrTest())));
            }
        }
        this.setupRequestScope((DeploymentInfo)info.getValue(), beanContainer);
        try {
            final ClassIntrospecter defaultVal = ((DeploymentInfo)info.getValue()).getClassIntrospecter();
            ((DeploymentInfo)info.getValue()).setClassIntrospecter(new ClassIntrospecter(){

                public <T> InstanceFactory<T> createInstanceFactory(Class<T> clazz) throws NoSuchMethodException {
                    final BeanContainer.Factory res = beanContainer.beanInstanceFactory(clazz, new Annotation[0]);
                    if (res == null) {
                        return defaultVal.createInstanceFactory(clazz);
                    }
                    return new InstanceFactory<T>(){

                        public InstanceHandle<T> createInstance() throws InstantiationException {
                            final BeanContainer.Instance ih = res.create();
                            return new InstanceHandle<T>(){

                                public T getInstance() {
                                    return ih.get();
                                }

                                public void release() {
                                    ih.close();
                                }
                            };
                        }
                    };
                }
            });
            final ExceptionHandler existing = ((DeploymentInfo)info.getValue()).getExceptionHandler();
            ((DeploymentInfo)info.getValue()).setExceptionHandler(new ExceptionHandler(){

                public boolean handleThrowable(HttpServerExchange exchange, ServletRequest request, ServletResponse response, Throwable throwable) {
                    String location;
                    if (throwable instanceof AuthenticationFailedException || throwable instanceof UnauthorizedException) {
                        String location2 = servletContext.getDeployment().getErrorPages().getErrorLocation(throwable);
                        if (location2 == null || location2.equals("/@QuarkusError")) {
                            if (throwable instanceof AuthenticationFailedException || exchange.getSecurityContext().getAuthenticatedAccount() == null) {
                                if (!exchange.isResponseStarted()) {
                                    exchange.getSecurityContext().setAuthenticationRequired();
                                    if (exchange.getSecurityContext().authenticate()) {
                                        exchange.setStatusCode(403);
                                    }
                                }
                            } else {
                                exchange.setStatusCode(403);
                            }
                            return true;
                        }
                    } else if (throwable instanceof ForbiddenException && ((location = servletContext.getDeployment().getErrorPages().getErrorLocation(throwable)) == null || location.equals("/@QuarkusError"))) {
                        exchange.setStatusCode(403);
                        return true;
                    }
                    return existing.handleThrowable(exchange, request, response, throwable);
                }
            });
            ServletContainer servletContainer = Servlets.defaultContainer();
            DeploymentManager manager = servletContainer.addDeployment((DeploymentInfo)info.getValue());
            manager.deploy();
            manager.start();
            servletContext = manager.getDeployment().getServletContext();
            shutdownContext.addShutdownTask(new Runnable(){

                @Override
                public void run() {
                    servletContext = null;
                }
            });
            return manager;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addServletContextAttribute(RuntimeValue<DeploymentInfo> deployment, String key, Object value1) {
        if (value1 instanceof RuntimeValue) {
            ((DeploymentInfo)deployment.getValue()).addServletContextAttribute(key, ((RuntimeValue)value1).getValue());
        } else {
            ((DeploymentInfo)deployment.getValue()).addServletContextAttribute(key, value1);
        }
    }

    public void addServletExtension(RuntimeValue<DeploymentInfo> deployment, ServletExtension extension) {
        ((DeploymentInfo)deployment.getValue()).addServletExtension(extension);
    }

    public void setupRequestScope(DeploymentInfo deploymentInfo, final BeanContainer beanContainer) {
        final CurrentVertxRequest currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
        Instance identityAssociations = CDI.current().select(CurrentIdentityAssociation.class, new Annotation[0]);
        final CurrentIdentityAssociation association = identityAssociations.isResolvable() ? (CurrentIdentityAssociation)identityAssociations.get() : null;
        deploymentInfo.addThreadSetupAction(new ThreadSetupHandler(){

            public <T, C> ThreadSetupHandler.Action<T, C> create(final ThreadSetupHandler.Action<T, C> action) {
                return new ThreadSetupHandler.Action<T, C>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public T call(HttpServerExchange exchange, C context) throws Exception {
                        Object object;
                        ManagedContext requestContext = beanContainer.requestContext();
                        if (requestContext.isActive()) {
                            if (currentVertxRequest.getCurrent() == null && exchange != null && exchange.getDelegate() instanceof VertxHttpExchange) {
                                this.addEventToVertxRequest(exchange);
                            }
                            return action.call(exchange, context);
                        }
                        if (exchange == null) {
                            requestContext.activate();
                            try {
                                Object object2 = action.call(exchange, context);
                                return object2;
                            }
                            finally {
                                requestContext.terminate();
                            }
                        }
                        InjectableContext.ContextState existingRequestContext = (InjectableContext.ContextState)exchange.getAttachment(REQUEST_CONTEXT);
                        try {
                            requestContext.activate(existingRequestContext);
                            RoutingContext rc = this.addEventToVertxRequest(exchange);
                            if (association != null) {
                                QuarkusHttpUser existing = (QuarkusHttpUser)rc.user();
                                if (existing != null) {
                                    SecurityIdentity identity = existing.getSecurityIdentity();
                                    association.setIdentity(identity);
                                } else {
                                    association.setIdentity(QuarkusHttpUser.getSecurityIdentity((RoutingContext)rc, null));
                                }
                            }
                            object = action.call(exchange, context);
                        }
                        catch (Throwable throwable) {
                            ServletRequestContext src = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                            HttpServletRequestImpl req = src.getOriginalRequest();
                            if (req.isAsyncStarted()) {
                                exchange.putAttachment(REQUEST_CONTEXT, (Object)requestContext.getState());
                                requestContext.deactivate();
                                if (existingRequestContext == null) {
                                    req.getAsyncContextInternal().addListener(new AsyncListener(requestContext, exchange){
                                        final /* synthetic */ ManagedContext val$requestContext;
                                        final /* synthetic */ HttpServerExchange val$exchange;
                                        {
                                            this.val$requestContext = managedContext;
                                            this.val$exchange = httpServerExchange;
                                        }

                                        public void onComplete(AsyncEvent event) throws IOException {
                                            this.val$requestContext.activate((InjectableContext.ContextState)this.val$exchange.getAttachment(REQUEST_CONTEXT));
                                            this.val$requestContext.terminate();
                                        }

                                        public void onTimeout(AsyncEvent event) throws IOException {
                                            this.onComplete(event);
                                        }

                                        public void onError(AsyncEvent event) throws IOException {
                                            this.onComplete(event);
                                        }

                                        public void onStartAsync(AsyncEvent event) throws IOException {
                                        }
                                    });
                                }
                            } else {
                                requestContext.terminate();
                            }
                            throw throwable;
                        }
                        ServletRequestContext src = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                        HttpServletRequestImpl req = src.getOriginalRequest();
                        if (req.isAsyncStarted()) {
                            exchange.putAttachment(REQUEST_CONTEXT, (Object)requestContext.getState());
                            requestContext.deactivate();
                            if (existingRequestContext == null) {
                                req.getAsyncContextInternal().addListener(new /* invalid duplicate definition of identical inner class */);
                            }
                        } else {
                            requestContext.terminate();
                        }
                        return object;
                    }

                    private RoutingContext addEventToVertxRequest(HttpServerExchange exchange) {
                        VertxHttpExchange delegate = (VertxHttpExchange)exchange.getDelegate();
                        RoutingContext rc = (RoutingContext)delegate.getContext();
                        currentVertxRequest.setCurrent(rc);
                        return rc;
                    }
                };
            }
        });
    }

    public void addServletContainerInitializer(RuntimeValue<DeploymentInfo> deployment, Class<? extends ServletContainerInitializer> sciClass, Set<Class<?>> handlesTypes) {
        ((DeploymentInfo)deployment.getValue()).addServletContainerInitializer(new ServletContainerInitializerInfo(sciClass, handlesTypes));
    }

    public void addContextParam(RuntimeValue<DeploymentInfo> deployment, String paramName, String paramValue) {
        ((DeploymentInfo)deployment.getValue()).addInitParameter(paramName, paramValue);
    }

    public void setDenyUncoveredHttpMethods(RuntimeValue<DeploymentInfo> deployment, boolean denyUncoveredHttpMethods) {
        ((DeploymentInfo)deployment.getValue()).setDenyUncoveredHttpMethods(denyUncoveredHttpMethods);
    }

    public void addSecurityConstraint(RuntimeValue<DeploymentInfo> deployment, SecurityConstraint securityConstraint) {
        ((DeploymentInfo)deployment.getValue()).addSecurityConstraint(securityConstraint);
    }

    public void addSecurityConstraint(RuntimeValue<DeploymentInfo> deployment, SecurityInfo.EmptyRoleSemantic emptyRoleSemantic, TransportGuaranteeType transportGuaranteeType, Set<String> rolesAllowed, Set<WebResourceCollection> webResourceCollections) {
        SecurityConstraint securityConstraint = ((SecurityConstraint)((SecurityConstraint)((SecurityConstraint)new SecurityConstraint().setEmptyRoleSemantic(emptyRoleSemantic)).addRolesAllowed(rolesAllowed)).setTransportGuaranteeType(transportGuaranteeType)).addWebResourceCollections(webResourceCollections.toArray(new WebResourceCollection[0]));
        ((DeploymentInfo)deployment.getValue()).addSecurityConstraint(securityConstraint);
    }

    public void setSessionTimeout(RuntimeValue<DeploymentInfo> deployment, int sessionTimeout) {
        ((DeploymentInfo)deployment.getValue()).setDefaultSessionTimeout(sessionTimeout * 60);
    }

    public ServletSessionConfig sessionConfig(RuntimeValue<DeploymentInfo> deployment) {
        ServletSessionConfig config = new ServletSessionConfig();
        ((DeploymentInfo)deployment.getValue()).setServletSessionConfig(config);
        return config;
    }

    public void setSessionTracking(ServletSessionConfig config, Set<SessionTrackingMode> modes) {
        config.setSessionTrackingModes(modes);
    }

    public void setSessionCookieConfig(ServletSessionConfig config, String name, String path, String comment, String domain, Boolean httpOnly, Integer maxAge, Boolean secure) {
        if (name != null) {
            config.setName(name);
        }
        if (path != null) {
            config.setPath(path);
        }
        if (comment != null) {
            config.setComment(comment);
        }
        if (domain != null) {
            config.setDomain(domain);
        }
        if (httpOnly != null) {
            config.setHttpOnly(httpOnly.booleanValue());
        }
        if (maxAge != null) {
            config.setMaxAge(maxAge.intValue());
        }
        if (secure != null) {
            config.setSecure(secure.booleanValue());
        }
    }

    static {
        currentRoot = ResponseCodeHandler.HANDLE_404;
        REQUEST_CONTEXT = AttachmentKey.create(InjectableContext.ContextState.class);
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory < 0x4000000L) {
            DEFAULT_DIRECT_BUFFERS = false;
            DEFAULT_BUFFER_SIZE = 512;
        } else if (maxMemory < 0x8000000L) {
            DEFAULT_DIRECT_BUFFERS = true;
            DEFAULT_BUFFER_SIZE = 1024;
        } else {
            DEFAULT_DIRECT_BUFFERS = true;
            DEFAULT_BUFFER_SIZE = 16364;
        }
    }

    private static class UndertowBufferAllocator
    implements BufferAllocator {
        private final boolean defaultDirectBuffers;
        private final int defaultBufferSize;

        private UndertowBufferAllocator(boolean defaultDirectBuffers, int defaultBufferSize) {
            this.defaultDirectBuffers = defaultDirectBuffers;
            this.defaultBufferSize = defaultBufferSize;
        }

        public ByteBuf allocateBuffer() {
            return this.allocateBuffer(this.defaultDirectBuffers);
        }

        public ByteBuf allocateBuffer(boolean direct) {
            if (direct) {
                return ByteBufAllocator.DEFAULT.directBuffer(this.defaultBufferSize);
            }
            return ByteBufAllocator.DEFAULT.heapBuffer(this.defaultBufferSize);
        }

        public ByteBuf allocateBuffer(int bufferSize) {
            return this.allocateBuffer(this.defaultDirectBuffers, bufferSize);
        }

        public ByteBuf allocateBuffer(boolean direct, int bufferSize) {
            if (direct) {
                return ByteBufAllocator.DEFAULT.directBuffer(bufferSize);
            }
            return ByteBufAllocator.DEFAULT.heapBuffer(bufferSize);
        }

        public int getBufferSize() {
            return this.defaultBufferSize;
        }
    }

    public static class ServletContextSupplier
    implements Supplier<ServletContext> {
        @Override
        public ServletContext get() {
            return servletContext;
        }
    }

    private static class QuarkusSessionIdGenerator
    implements SessionIdGenerator {
        private volatile SecureRandom random;
        private volatile int length = 30;
        private static final char[] SESSION_ID_ALPHABET;
        private static final String ALPHABET_PROPERTY = "io.undertow.server.session.SecureRandomSessionIdGenerator.ALPHABET";

        private QuarkusSessionIdGenerator() {
        }

        public String createSessionId() {
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            byte[] bytes = new byte[this.length];
            this.random.nextBytes(bytes);
            return new String(this.encode(bytes));
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        private char[] encode(byte[] data) {
            char[] out = new char[(data.length + 2) / 3 * 4];
            char[] alphabet = SESSION_ID_ALPHABET;
            int i = 0;
            int index = 0;
            while (i < data.length) {
                boolean quad = false;
                boolean trip = false;
                int val = 0xFF & data[i];
                val <<= 8;
                if (i + 1 < data.length) {
                    val |= 0xFF & data[i + 1];
                    trip = true;
                }
                val <<= 8;
                if (i + 2 < data.length) {
                    val |= 0xFF & data[i + 2];
                    quad = true;
                }
                out[index + 3] = alphabet[quad ? val & 0x3F : 63];
                out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 63];
                out[index + 1] = alphabet[(val >>= 6) & 0x3F];
                out[index] = alphabet[(val >>= 6) & 0x3F];
                i += 3;
                index += 4;
            }
            return out;
        }

        static {
            String alphabet = System.getProperty(ALPHABET_PROPERTY, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_");
            if (alphabet.length() != 64) {
                throw new RuntimeException("io.undertow.server.session.SecureRandomSessionIdGenerator must be exactly 64 characters long");
            }
            SESSION_ID_ALPHABET = alphabet.toCharArray();
        }
    }
}

