/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.ConfigInjectionStaticInitBuildItem;
import io.quarkus.arc.deployment.ContextRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.CustomScopeBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.ContextConfigurator;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ObjectSubstitutionBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.undertow.deployment.FilterBuildItem;
import io.quarkus.undertow.deployment.HttpHandlerWrapperBuildItem;
import io.quarkus.undertow.deployment.IgnoredServletContainerInitializerBuildItem;
import io.quarkus.undertow.deployment.KnownPathsBuildItem;
import io.quarkus.undertow.deployment.ListenerBuildItem;
import io.quarkus.undertow.deployment.ServletBuildItem;
import io.quarkus.undertow.deployment.ServletConfig;
import io.quarkus.undertow.deployment.ServletContainerInitializerBuildItem;
import io.quarkus.undertow.deployment.ServletContextAttributeBuildItem;
import io.quarkus.undertow.deployment.ServletContextPathBuildItem;
import io.quarkus.undertow.deployment.ServletDeploymentManagerBuildItem;
import io.quarkus.undertow.deployment.ServletExtensionBuildItem;
import io.quarkus.undertow.deployment.ServletInitParamBuildItem;
import io.quarkus.undertow.deployment.WebMetadataBuildItem;
import io.quarkus.undertow.runtime.HttpSessionContext;
import io.quarkus.undertow.runtime.QuarkusIdentityManager;
import io.quarkus.undertow.runtime.ServletHttpSecurityPolicy;
import io.quarkus.undertow.runtime.ServletProducer;
import io.quarkus.undertow.runtime.ServletRuntimeConfig;
import io.quarkus.undertow.runtime.ServletSecurityInfoProxy;
import io.quarkus.undertow.runtime.ServletSecurityInfoSubstitution;
import io.quarkus.undertow.runtime.UndertowDeploymentRecorder;
import io.quarkus.undertow.runtime.UndertowHandlersConfServletExtension;
import io.quarkus.vertx.http.deployment.DefaultRouteBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.HttpMethodSecurityInfo;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.api.ServletSessionConfig;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.handlers.DefaultServlet;
import io.vertx.core.Handler;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.Typed;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.annotation.HandlesTypes;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.annotation.WebListener;
import jakarta.servlet.annotation.WebServlet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.annotation.javaee.DisplayNames;
import org.jboss.annotation.javaee.Icons;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.DescriptionImpl;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.javaee.spec.DisplayNameImpl;
import org.jboss.metadata.javaee.spec.DisplayNamesImpl;
import org.jboss.metadata.javaee.spec.IconImpl;
import org.jboss.metadata.javaee.spec.IconsImpl;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.RunAsMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.spec.AnnotationMetaData;
import org.jboss.metadata.web.spec.AnnotationsMetaData;
import org.jboss.metadata.web.spec.CookieConfigMetaData;
import org.jboss.metadata.web.spec.DispatcherType;
import org.jboss.metadata.web.spec.EmptyRoleSemanticType;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.metadata.web.spec.HttpMethodConstraintMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.MimeMappingMetaData;
import org.jboss.metadata.web.spec.MultipartConfigMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.ServletSecurityMetaData;
import org.jboss.metadata.web.spec.ServletsMetaData;
import org.jboss.metadata.web.spec.SessionConfigMetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;

public class UndertowBuildStep {
    public static final DotName WEB_FILTER = DotName.createSimple((String)WebFilter.class.getName());
    public static final DotName WEB_LISTENER = DotName.createSimple((String)WebListener.class.getName());
    public static final DotName WEB_SERVLET = DotName.createSimple((String)WebServlet.class.getName());
    public static final DotName RUN_AS = DotName.createSimple((String)RunAs.class.getName());
    public static final DotName DECLARE_ROLES = DotName.createSimple((String)DeclareRoles.class.getName());
    public static final DotName MULTIPART_CONFIG = DotName.createSimple((String)MultipartConfig.class.getName());
    public static final DotName SERVLET_SECURITY = DotName.createSimple((String)ServletSecurity.class.getName());
    public static final DotName TYPED = DotName.createSimple((String)Typed.class.getName());
    protected static final String SERVLET_CONTAINER_INITIALIZER = "META-INF/services/jakarta.servlet.ServletContainerInitializer";
    protected static final DotName HANDLES_TYPES = DotName.createSimple((String)HandlesTypes.class.getName());
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;

    @BuildStep
    public FeatureBuildItem setupCapability() {
        return new FeatureBuildItem(Feature.SERVLET);
    }

    @BuildStep
    void build(CurateOutcomeBuildItem curateOutcomeBuildItem, BuildProducer<RuntimeInitializedClassBuildItem> producer) {
        if (!this.jacksonOnClasspath(curateOutcomeBuildItem)) {
            producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.vertx.core.json.Json"));
            producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.vertx.core.spi.JsonFactory"));
        }
    }

    private boolean jacksonOnClasspath(CurateOutcomeBuildItem curateOutcomeBuildItem) {
        for (ResolvedDependency appDep : curateOutcomeBuildItem.getApplicationModel().getRuntimeDependencies()) {
            if (!appDep.getArtifactId().equals("jackson-core")) continue;
            return true;
        }
        return false;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public ServiceStartBuildItem boot(UndertowDeploymentRecorder recorder, ServletDeploymentManagerBuildItem servletDeploymentManagerBuildItem, List<HttpHandlerWrapperBuildItem> wrappers, ShutdownContextBuildItem shutdown, Consumer<DefaultRouteBuildItem> undertowProducer, BuildProducer<RouteBuildItem> routeProducer, ExecutorBuildItem executorBuildItem, ServletRuntimeConfig servletRuntimeConfig, ServletContextPathBuildItem servletContextPathBuildItem, Capabilities capabilities, HttpBuildTimeConfig httpBuildTimeConfig) throws Exception {
        if (capabilities.isPresent("io.quarkus.security")) {
            recorder.setupSecurity(servletDeploymentManagerBuildItem.getDeploymentManager());
        }
        Handler ut = recorder.startUndertow((ShutdownContext)shutdown, (ExecutorService)executorBuildItem.getExecutorProxy(), servletDeploymentManagerBuildItem.getDeploymentManager(), wrappers.stream().map(HttpHandlerWrapperBuildItem::getValue).collect(Collectors.toList()), servletRuntimeConfig, httpBuildTimeConfig);
        if (servletContextPathBuildItem.getServletContextPath().equals("/")) {
            undertowProducer.accept(new DefaultRouteBuildItem(ut));
        } else {
            routeProducer.produce((BuildItem)RouteBuildItem.builder().route(servletContextPathBuildItem.getServletContextPath() + "/*").handler(ut).build());
            routeProducer.produce((BuildItem)RouteBuildItem.builder().route(servletContextPathBuildItem.getServletContextPath()).handler(ut).build());
        }
        return new ServiceStartBuildItem("undertow");
    }

    @BuildStep
    void integrateCdi(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ListenerBuildItem> listeners, Capabilities capabilities) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{ServletProducer.class}));
        if (capabilities.isPresent("io.quarkus.security")) {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(ServletHttpSecurityPolicy.class));
        }
        listeners.produce((BuildItem)new ListenerBuildItem(HttpSessionContext.class.getName()));
    }

    @BuildStep
    ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem registerContext(ContextRegistrationPhaseBuildItem phase) {
        return new ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem(new ContextConfigurator[]{phase.getContext().configure(SessionScoped.class).normal().contextClass(HttpSessionContext.class)});
    }

    @BuildStep
    CustomScopeBuildItem customScope() {
        return new CustomScopeBuildItem(DotName.createSimple((String)SessionScoped.class.getName()));
    }

    @BuildStep
    public void registerUndertowHandlersConf(BuildProducer<ServletExtensionBuildItem> producer, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFile, BuildProducer<NativeImageResourceBuildItem> nativeImageResourceBuildItemBuildProducer) {
        watchedFile.produce((BuildItem)new HotDeploymentWatchedFileBuildItem("META-INF/undertow-handlers.conf"));
        boolean handlerPath = (Boolean)applicationArchivesBuildItem.getRootArchive().apply(tree -> tree.contains("META-INF/undertow-handlers.conf"));
        if (handlerPath) {
            producer.produce((BuildItem)new ServletExtensionBuildItem((ServletExtension)new UndertowHandlersConfServletExtension()));
            nativeImageResourceBuildItemBuildProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/undertow-handlers.conf"}));
        }
    }

    @BuildStep
    public List<ServletContainerInitializerBuildItem> servletContainerInitializer(CombinedIndexBuildItem combinedIndexBuildItem, List<IgnoredServletContainerInitializerBuildItem> ignoredScis, BuildProducer<AdditionalBeanBuildItem> beans) throws IOException {
        HashSet<String> ignoredClassNames = new HashSet<String>();
        for (IgnoredServletContainerInitializerBuildItem bi : ignoredScis) {
            ignoredClassNames.add(bi.getSciClass());
        }
        ArrayList<ServletContainerInitializerBuildItem> ret = new ArrayList<ServletContainerInitializerBuildItem>();
        Set initializers = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)SERVLET_CONTAINER_INITIALIZER);
        for (String initializer : initializers) {
            if (ignoredClassNames.contains(initializer)) continue;
            beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)initializer));
            ClassInfo sci = combinedIndexBuildItem.getIndex().getClassByName(DotName.createSimple((String)initializer));
            if (sci != null) {
                AnnotationInstance handles = sci.declaredAnnotation(HANDLES_TYPES);
                HashSet<String> handledTypes = new HashSet<String>();
                if (handles != null) {
                    Type[] types;
                    for (Type handledType : types = handles.value().asClassArray()) {
                        DotName typeName = handledType.asClassType().name();
                        for (ClassInfo classInfo : combinedIndexBuildItem.getIndex().getAllKnownSubclasses(typeName)) {
                            handledTypes.add(classInfo.name().toString());
                        }
                        for (ClassInfo classInfo : combinedIndexBuildItem.getIndex().getAllKnownImplementors(typeName)) {
                            handledTypes.add(classInfo.name().toString());
                        }
                        for (AnnotationInstance annotationInstance : combinedIndexBuildItem.getIndex().getAnnotations(typeName)) {
                            if (annotationInstance.target().kind() == AnnotationTarget.Kind.CLASS) {
                                handledTypes.add(annotationInstance.target().asClass().name().toString());
                                continue;
                            }
                            if (annotationInstance.target().kind() == AnnotationTarget.Kind.METHOD) {
                                handledTypes.add(annotationInstance.target().asMethod().declaringClass().name().toString());
                                continue;
                            }
                            if (annotationInstance.target().kind() == AnnotationTarget.Kind.FIELD) {
                                handledTypes.add(annotationInstance.target().asField().declaringClass().name().toString());
                                continue;
                            }
                            if (annotationInstance.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER) continue;
                            handledTypes.add(annotationInstance.target().asMethodParameter().method().declaringClass().name().toString());
                        }
                    }
                }
                ret.add(new ServletContainerInitializerBuildItem(initializer, handledTypes));
                continue;
            }
            ret.add(new ServletContainerInitializerBuildItem(initializer, Collections.emptySet()));
        }
        return ret;
    }

    @BuildStep
    public ServletContextPathBuildItem contextPath(ServletConfig servletConfig, WebMetadataBuildItem webMetadataBuildItem) {
        String contextPath = servletConfig.contextPath.isPresent() ? servletConfig.contextPath.get() : (webMetadataBuildItem.getWebMetaData().getDefaultContextPath() != null ? webMetadataBuildItem.getWebMetaData().getDefaultContextPath() : "/");
        return new ServletContextPathBuildItem(contextPath);
    }

    @BuildStep
    public void produceIdentityManager(Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        if (!this.hasSecurityCapability(capabilities)) {
            return;
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(QuarkusIdentityManager.class));
    }

    private boolean hasSecurityCapability(Capabilities capabilities) {
        return capabilities.isCapabilityWithPrefixPresent("io.quarkus.security");
    }

    @BuildStep
    public void addTypedAnnotations(BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                ClassInfo clazz = context.getTarget().asClass();
                if ((clazz.declaredAnnotation(WEB_SERVLET) != null || clazz.declaredAnnotation(WEB_FILTER) != null || clazz.declaredAnnotation(WEB_LISTENER) != null) && clazz.declaredAnnotation(TYPED) == null) {
                    ((Transformation)context.transform().add(UndertowBuildStep.this.createTypedAnnotationInstance(clazz))).done();
                }
            }
        }));
    }

    private AnnotationInstance createTypedAnnotationInstance(ClassInfo clazz) {
        return AnnotationInstance.create((DotName)TYPED, (AnnotationTarget)clazz, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createArrayValue((String)"value", (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createClassValue((String)"value", (Type)Type.create((DotName)clazz.name(), (Type.Kind)Type.Kind.CLASS))})});
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    public ServletDeploymentManagerBuildItem build(List<ServletBuildItem> servlets, List<FilterBuildItem> filters, List<ListenerBuildItem> listeners, List<ServletInitParamBuildItem> initParams, List<ServletContextAttributeBuildItem> contextParams, List<ServletContainerInitializerBuildItem> servletContainerInitializerBuildItems, UndertowDeploymentRecorder recorder, RecorderContext context, List<ServletExtensionBuildItem> extensions, BeanContainerBuildItem bc, ServletContextPathBuildItem servletContextPathBuildItem, WebMetadataBuildItem webMetadataBuildItem, BuildProducer<ObjectSubstitutionBuildItem> substitutions, Consumer<ReflectiveClassBuildItem> reflectiveClasses, LaunchModeBuildItem launchMode, ShutdownContextBuildItem shutdownContext, KnownPathsBuildItem knownPaths, HttpBuildTimeConfig httpBuildTimeConfig, HttpRootPathBuildItem httpRootPath, ServletConfig servletConfig, Capabilities capabilities) throws Exception {
        RuntimeValue sref;
        ObjectSubstitutionBuildItem.Holder holder = new ObjectSubstitutionBuildItem.Holder(ServletSecurityInfo.class, ServletSecurityInfoProxy.class, ServletSecurityInfoSubstitution.class);
        substitutions.produce((BuildItem)new ObjectSubstitutionBuildItem(holder));
        reflectiveClasses.accept(ReflectiveClassBuildItem.builder((String[])new String[]{DefaultServlet.class.getName()}).build());
        WebMetaData webMetaData = webMetadataBuildItem.getWebMetaData();
        IndexView index = this.combinedIndexBuildItem.getIndex();
        this.processAnnotations(index, webMetaData);
        String contextPath = servletContextPathBuildItem.getServletContextPath();
        RuntimeValue deployment = recorder.createDeployment("test", knownPaths.knownFiles, knownPaths.knownDirectories, launchMode.getLaunchMode(), (ShutdownContext)shutdownContext, httpRootPath.relativePath(contextPath), servletConfig.defaultCharset, webMetaData.getRequestCharacterEncoding(), webMetaData.getResponseCharacterEncoding(), httpBuildTimeConfig.auth.proactive, webMetaData.getWelcomeFileList() != null ? webMetaData.getWelcomeFileList().getWelcomeFiles() : null, this.hasSecurityCapability(capabilities));
        if (webMetaData.getContextParams() != null) {
            for (ParamValueMetaData paramValueMetaData : webMetaData.getContextParams()) {
                recorder.addContextParam(deployment, paramValueMetaData.getParamName(), paramValueMetaData.getParamValue());
            }
        }
        if (webMetaData.getServlets() != null) {
            for (ServletMetaData servletMetaData : webMetaData.getServlets()) {
                reflectiveClasses.accept(ReflectiveClassBuildItem.builder((String[])new String[]{servletMetaData.getServletClass()}).build());
                sref = recorder.registerServlet(deployment, servletMetaData.getServletName(), context.classProxy(servletMetaData.getServletClass()), servletMetaData.isAsyncSupported(), servletMetaData.getLoadOnStartupInt(), bc.getValue(), null);
                if (servletMetaData.getInitParam() != null) {
                    for (Object init : servletMetaData.getInitParam()) {
                        recorder.addServletInitParam(sref, init.getParamName(), init.getParamValue());
                    }
                }
                if (webMetaData.getAnnotations() != null) {
                    for (AnnotationMetaData amd : webMetaData.getAnnotations()) {
                        MultipartConfigMetaData mcmd;
                        ServletSecurityMetaData servletSecurityMetaData = amd.getServletSecurity();
                        if (servletSecurityMetaData != null && amd.getClassName().equals(servletMetaData.getServletClass())) {
                            ServletSecurityInfo securityInfo = new ServletSecurityInfo();
                            securityInfo.setEmptyRoleSemantic(servletSecurityMetaData.getEmptyRoleSemantic() == EmptyRoleSemanticType.DENY ? SecurityInfo.EmptyRoleSemantic.DENY : SecurityInfo.EmptyRoleSemantic.PERMIT);
                            ((ServletSecurityInfo)securityInfo.setTransportGuaranteeType(UndertowBuildStep.transportGuaranteeType(servletSecurityMetaData.getTransportGuarantee()))).addRolesAllowed((Collection)servletSecurityMetaData.getRolesAllowed());
                            if (servletSecurityMetaData.getHttpMethodConstraints() != null) {
                                for (HttpMethodConstraintMetaData method : servletSecurityMetaData.getHttpMethodConstraints()) {
                                    securityInfo.addHttpMethodSecurityInfo(((HttpMethodSecurityInfo)((HttpMethodSecurityInfo)((HttpMethodSecurityInfo)new HttpMethodSecurityInfo().setEmptyRoleSemantic(method.getEmptyRoleSemantic() == EmptyRoleSemanticType.DENY ? SecurityInfo.EmptyRoleSemantic.DENY : SecurityInfo.EmptyRoleSemantic.PERMIT)).setTransportGuaranteeType(UndertowBuildStep.transportGuaranteeType(method.getTransportGuarantee()))).addRolesAllowed((Collection)method.getRolesAllowed())).setMethod(method.getMethod()));
                                }
                            }
                            recorder.setSecurityInfo(sref, securityInfo);
                        }
                        if ((mcmd = amd.getMultipartConfig()) == null || !amd.getClassName().equals(servletMetaData.getServletClass())) continue;
                        servletMetaData.setMultipartConfig(mcmd);
                    }
                }
                if (servletMetaData.getSecurityRoleRefs() != null) {
                    for (SecurityRoleRefMetaData ref : servletMetaData.getSecurityRoleRefs()) {
                        recorder.addSecurityRoleRef(sref, ref.getRoleName(), ref.getRoleLink());
                    }
                }
                if (servletMetaData.getMultipartConfig() == null) continue;
                recorder.setMultipartConfig(sref, servletMetaData.getMultipartConfig().getLocation(), servletMetaData.getMultipartConfig().getMaxFileSize(), servletMetaData.getMultipartConfig().getMaxRequestSize(), servletMetaData.getMultipartConfig().getFileSizeThreshold());
            }
        }
        if (webMetaData.getServletMappings() != null) {
            for (ServletMappingMetaData servletMappingMetaData : webMetaData.getServletMappings()) {
                for (Object m : servletMappingMetaData.getUrlPatterns()) {
                    recorder.addServletMapping(deployment, servletMappingMetaData.getServletName(), (String)m);
                }
            }
        }
        if (webMetaData.getFilters() != null) {
            for (FilterMetaData filterMetaData : webMetaData.getFilters()) {
                reflectiveClasses.accept(ReflectiveClassBuildItem.builder((String[])new String[]{filterMetaData.getFilterClass()}).build());
                sref = recorder.registerFilter(deployment, filterMetaData.getFilterName(), context.classProxy(filterMetaData.getFilterClass()), filterMetaData.isAsyncSupported(), bc.getValue(), null);
                if (filterMetaData.getInitParam() == null) continue;
                for (Object init : filterMetaData.getInitParam()) {
                    recorder.addFilterInitParam(sref, init.getParamName(), init.getParamValue());
                }
            }
        }
        if (webMetaData.getFilterMappings() != null) {
            for (FilterMappingMetaData filterMappingMetaData : webMetaData.getFilterMappings()) {
                List urlPatterns = filterMappingMetaData.getUrlPatterns();
                List servletNames = filterMappingMetaData.getServletNames();
                if (urlPatterns != null && !urlPatterns.isEmpty()) {
                    for (String string : urlPatterns) {
                        if (filterMappingMetaData.getDispatchers() == null || filterMappingMetaData.getDispatchers().isEmpty()) {
                            recorder.addFilterURLMapping(deployment, filterMappingMetaData.getFilterName(), string, jakarta.servlet.DispatcherType.REQUEST);
                            continue;
                        }
                        for (DispatcherType dispatcher : filterMappingMetaData.getDispatchers()) {
                            recorder.addFilterURLMapping(deployment, filterMappingMetaData.getFilterName(), string, jakarta.servlet.DispatcherType.valueOf((String)dispatcher.name()));
                        }
                    }
                    continue;
                }
                if (servletNames == null || servletNames.isEmpty()) continue;
                for (String string : servletNames) {
                    if (filterMappingMetaData.getDispatchers() == null || filterMappingMetaData.getDispatchers().isEmpty()) {
                        recorder.addFilterServletNameMapping(deployment, filterMappingMetaData.getFilterName(), string, jakarta.servlet.DispatcherType.REQUEST);
                        continue;
                    }
                    for (DispatcherType dispatcher : filterMappingMetaData.getDispatchers()) {
                        recorder.addFilterServletNameMapping(deployment, filterMappingMetaData.getFilterName(), string, jakarta.servlet.DispatcherType.valueOf((String)dispatcher.name()));
                    }
                }
            }
        }
        if (webMetaData.getDenyUncoveredHttpMethods() != null) {
            recorder.setDenyUncoveredHttpMethods(deployment, webMetaData.getDenyUncoveredHttpMethods().booleanValue());
        }
        if (webMetaData.getSecurityConstraints() != null) {
            for (SecurityConstraintMetaData securityConstraintMetaData : webMetaData.getSecurityConstraints()) {
                SecurityConstraint securityConstraint = (SecurityConstraint)new SecurityConstraint().setTransportGuaranteeType(UndertowBuildStep.transportGuaranteeType(securityConstraintMetaData.getTransportGuarantee()));
                List roleNames = securityConstraintMetaData.getRoleNames();
                if (securityConstraintMetaData.getAuthConstraint() == null) {
                    securityConstraint.setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.PERMIT);
                } else if (roleNames.size() == 1 && roleNames.contains("*")) {
                    securityConstraint.setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.AUTHENTICATE);
                } else {
                    securityConstraint.addRolesAllowed((Collection)roleNames);
                }
                if (securityConstraintMetaData.getResourceCollections() != null) {
                    for (WebResourceCollectionMetaData webResourceCollectionMetaData : securityConstraintMetaData.getResourceCollections()) {
                        securityConstraint.addWebResourceCollection(new WebResourceCollection().addHttpMethods((Collection)webResourceCollectionMetaData.getHttpMethods()).addHttpMethodOmissions((Collection)webResourceCollectionMetaData.getHttpMethodOmissions()).addUrlPatterns((Collection)webResourceCollectionMetaData.getUrlPatterns()));
                    }
                }
                recorder.addSecurityConstraint(deployment, securityConstraint.getEmptyRoleSemantic(), securityConstraint.getTransportGuaranteeType(), securityConstraint.getRolesAllowed(), securityConstraint.getWebResourceCollections());
            }
        }
        if (webMetaData.getListeners() != null) {
            for (ListenerMetaData listenerMetaData : webMetaData.getListeners()) {
                reflectiveClasses.accept(ReflectiveClassBuildItem.builder((String[])new String[]{listenerMetaData.getListenerClass()}).build());
                recorder.registerListener(deployment, context.classProxy(listenerMetaData.getListenerClass()), bc.getValue());
            }
        }
        if (webMetaData.getMimeMappings() != null) {
            for (MimeMappingMetaData mimeMappingMetaData : webMetaData.getMimeMappings()) {
                recorder.addMimeMapping(deployment, mimeMappingMetaData.getExtension(), mimeMappingMetaData.getMimeType());
            }
        }
        for (ServletBuildItem servletBuildItem : servlets) {
            String servletClass = servletBuildItem.getServletClass();
            if (servletBuildItem.getLoadOnStartup() == 0) {
                reflectiveClasses.accept(ReflectiveClassBuildItem.builder((String[])new String[]{servletBuildItem.getServletClass()}).build());
            }
            RuntimeValue s2 = recorder.registerServlet(deployment, servletBuildItem.getName(), context.classProxy(servletClass), servletBuildItem.isAsyncSupported(), servletBuildItem.getLoadOnStartup(), bc.getValue(), servletBuildItem.getInstanceFactory());
            for (String string : servletBuildItem.getMappings()) {
                recorder.addServletMapping(deployment, servletBuildItem.getName(), string);
            }
            for (Map.Entry entry : servletBuildItem.getInitParams().entrySet()) {
                recorder.addServletInitParam(s2, (String)entry.getKey(), (String)entry.getValue());
            }
            if (servletBuildItem.getMultipartConfig() == null) continue;
            recorder.setMultipartConfig(s2, servletBuildItem.getMultipartConfig().getLocation(), servletBuildItem.getMultipartConfig().getMaxFileSize(), servletBuildItem.getMultipartConfig().getMaxRequestSize(), servletBuildItem.getMultipartConfig().getFileSizeThreshold());
        }
        for (FilterBuildItem filterBuildItem : filters) {
            String filterClass = filterBuildItem.getFilterClass();
            reflectiveClasses.accept(ReflectiveClassBuildItem.builder((String[])new String[]{filterClass}).build());
            RuntimeValue f = recorder.registerFilter(deployment, filterBuildItem.getName(), context.classProxy(filterClass), filterBuildItem.isAsyncSupported(), bc.getValue(), filterBuildItem.getInstanceFactory());
            for (FilterBuildItem.FilterMappingInfo filterMappingInfo : filterBuildItem.getMappings()) {
                if (filterMappingInfo.getMappingType() == FilterBuildItem.FilterMappingInfo.MappingType.URL) {
                    recorder.addFilterURLMapping(deployment, filterBuildItem.getName(), filterMappingInfo.getMapping(), filterMappingInfo.getDispatcher());
                    continue;
                }
                recorder.addFilterServletNameMapping(deployment, filterBuildItem.getName(), filterMappingInfo.getMapping(), filterMappingInfo.getDispatcher());
            }
            for (Map.Entry entry : filterBuildItem.getInitParams().entrySet()) {
                recorder.addFilterInitParam(f, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (ServletInitParamBuildItem servletInitParamBuildItem : initParams) {
            recorder.addServletInitParameter(deployment, servletInitParamBuildItem.getKey(), servletInitParamBuildItem.getValue());
        }
        for (ServletContextAttributeBuildItem servletContextAttributeBuildItem : contextParams) {
            recorder.addServletContextAttribute(deployment, servletContextAttributeBuildItem.getKey(), servletContextAttributeBuildItem.getValue());
        }
        for (ServletExtensionBuildItem servletExtensionBuildItem : extensions) {
            recorder.addServletExtension(deployment, servletExtensionBuildItem.getValue());
        }
        for (ListenerBuildItem listenerBuildItem : listeners) {
            reflectiveClasses.accept(ReflectiveClassBuildItem.builder((String[])new String[]{listenerBuildItem.getListenerClass()}).build());
            recorder.registerListener(deployment, context.classProxy(listenerBuildItem.getListenerClass()), bc.getValue());
        }
        for (ServletContainerInitializerBuildItem servletContainerInitializerBuildItem : servletContainerInitializerBuildItems) {
            HashSet<Class> handlesTypes = new HashSet<Class>();
            for (String handledType : servletContainerInitializerBuildItem.handlesTypes) {
                handlesTypes.add(context.classProxy(handledType));
            }
            recorder.addServletContainerInitializer(deployment, context.classProxy(servletContainerInitializerBuildItem.sciClass), handlesTypes);
        }
        SessionConfigMetaData sessionConfig = webMetaData.getSessionConfig();
        if (sessionConfig != null) {
            if (sessionConfig.getSessionTimeoutSet()) {
                recorder.setSessionTimeout(deployment, sessionConfig.getSessionTimeout());
            }
            CookieConfigMetaData cookieConfigMetaData = sessionConfig.getCookieConfig();
            if (sessionConfig.getSessionTrackingModes() != null || cookieConfigMetaData != null) {
                ServletSessionConfig config = recorder.sessionConfig(deployment);
                if (sessionConfig.getSessionTrackingModes() != null) {
                    recorder.setSessionTracking(config, sessionConfig.getSessionTrackingModes().stream().map(s -> SessionTrackingMode.valueOf((String)s.toString())).collect(Collectors.toSet()));
                }
                if (cookieConfigMetaData != null) {
                    recorder.setSessionCookieConfig(config, cookieConfigMetaData.getName(), cookieConfigMetaData.getPath(), cookieConfigMetaData.getComment(), cookieConfigMetaData.getDomain(), cookieConfigMetaData.getHttpOnlySet() ? Boolean.valueOf(cookieConfigMetaData.getHttpOnly()) : null, cookieConfigMetaData.getMaxAgeSet() ? Integer.valueOf(cookieConfigMetaData.getMaxAge()) : null, cookieConfigMetaData.getSecureSet() ? Boolean.valueOf(cookieConfigMetaData.getSecure()) : null);
                }
            }
        }
        return new ServletDeploymentManagerBuildItem(recorder.bootServletContainer(deployment, bc.getValue(), launchMode.getLaunchMode(), (ShutdownContext)shutdownContext));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    SyntheticBeanBuildItem servletContextBean(UndertowDeploymentRecorder recorder) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(ServletContext.class).scope(ApplicationScoped.class)).supplier(recorder.servletContextSupplier()).done();
    }

    @BuildStep
    ConfigInjectionStaticInitBuildItem configInjectionStaticInitAnnotations() {
        return new ConfigInjectionStaticInitBuildItem(WEB_FILTER);
    }

    private void processAnnotations(IndexView index, WebMetaData metaData) {
        Collection servletSecurityAnnotations;
        Collection multipartConfigAnnotations;
        Collection declareRolesAnnotations;
        Collection runAsAnnotations;
        Collection webListenerAnnotations;
        ClassInfo classInfo;
        AnnotationTarget target;
        Collection webFilterAnnotations;
        ArrayList urlPatterns;
        DescriptionGroupMetaData descriptionGroup;
        AnnotationValue largeIconValue;
        AnnotationValue smallIconValue;
        AnnotationValue displayNameValue;
        AnnotationValue descriptionValue;
        AnnotationValue initParamsValue;
        AnnotationValue asyncSupported;
        Collection webServletAnnotations = index.getAnnotations(WEB_SERVLET);
        if (webServletAnnotations != null && webServletAnnotations.size() > 0) {
            ArrayList<ServletMappingMetaData> servletMappings;
            ServletsMetaData servlets = metaData.getServlets();
            if (servlets == null) {
                servlets = new ServletsMetaData();
                metaData.setServlets(servlets);
            }
            if ((servletMappings = metaData.getServletMappings()) == null) {
                servletMappings = new ArrayList<ServletMappingMetaData>();
                metaData.setServletMappings(servletMappings);
            }
            for (Object annotation : webServletAnnotations) {
                ServletMetaData servlet = new ServletMetaData();
                AnnotationTarget target2 = annotation.target();
                ClassInfo classInfo2 = (ClassInfo)ClassInfo.class.cast(target2);
                servlet.setServletClass(classInfo2.toString());
                AnnotationValue nameValue = annotation.value("name");
                if (nameValue == null || nameValue.asString().isEmpty()) {
                    servlet.setName(classInfo2.toString());
                } else {
                    servlet.setName(nameValue.asString());
                }
                AnnotationValue loadOnStartup = annotation.value("loadOnStartup");
                if (loadOnStartup != null && loadOnStartup.asInt() >= 0) {
                    servlet.setLoadOnStartupInt(loadOnStartup.asInt());
                }
                if ((asyncSupported = annotation.value("asyncSupported")) != null) {
                    servlet.setAsyncSupported(asyncSupported.asBoolean());
                }
                initParamsValue = annotation.value("initParams");
                servlet.setInitParam(this.getInitParams(initParamsValue));
                descriptionValue = annotation.value("description");
                displayNameValue = annotation.value("displayName");
                smallIconValue = annotation.value("smallIcon");
                largeIconValue = annotation.value("largeIcon");
                descriptionGroup = this.getDescriptionGroup(descriptionValue == null ? "" : descriptionValue.asString(), displayNameValue == null ? "" : displayNameValue.asString(), smallIconValue == null ? "" : smallIconValue.asString(), largeIconValue == null ? "" : largeIconValue.asString());
                if (descriptionGroup != null) {
                    servlet.setDescriptionGroup(descriptionGroup);
                }
                ServletMappingMetaData servletMapping = new ServletMappingMetaData();
                servletMapping.setServletName(servlet.getName());
                urlPatterns = new ArrayList();
                AnnotationValue urlPatternsValue = annotation.value("urlPatterns");
                if (urlPatternsValue != null) {
                    Collections.addAll(urlPatterns, urlPatternsValue.asStringArray());
                }
                if ((urlPatternsValue = annotation.value()) != null) {
                    Collections.addAll(urlPatterns, urlPatternsValue.asStringArray());
                }
                if (urlPatterns.size() > 0) {
                    servletMapping.setUrlPatterns(urlPatterns);
                    servletMappings.add(servletMapping);
                }
                servlets.add((MappableMetaData)servlet);
            }
        }
        if ((webFilterAnnotations = index.getAnnotations(WEB_FILTER)) != null && webFilterAnnotations.size() > 0) {
            ArrayList<FilterMappingMetaData> filterMappings;
            FiltersMetaData filters = metaData.getFilters();
            if (filters == null) {
                filters = new FiltersMetaData();
                metaData.setFilters(filters);
            }
            if ((filterMappings = metaData.getFilterMappings()) == null) {
                filterMappings = new ArrayList<FilterMappingMetaData>();
                metaData.setFilterMappings(filterMappings);
            }
            for (Object annotation : webFilterAnnotations) {
                AnnotationValue dispatcherTypesValue;
                AnnotationValue servletNamesValue;
                FilterMetaData filter = new FilterMetaData();
                target = annotation.target();
                classInfo = (ClassInfo)ClassInfo.class.cast(target);
                filter.setFilterClass(classInfo.toString());
                AnnotationValue nameValue = annotation.value("filterName");
                if (nameValue == null || nameValue.asString().isEmpty()) {
                    filter.setName(classInfo.toString());
                } else {
                    filter.setName(nameValue.asString());
                }
                asyncSupported = annotation.value("asyncSupported");
                if (asyncSupported != null) {
                    filter.setAsyncSupported(asyncSupported.asBoolean());
                }
                initParamsValue = annotation.value("initParams");
                filter.setInitParam(this.getInitParams(initParamsValue));
                descriptionValue = annotation.value("description");
                displayNameValue = annotation.value("displayName");
                smallIconValue = annotation.value("smallIcon");
                largeIconValue = annotation.value("largeIcon");
                descriptionGroup = this.getDescriptionGroup(descriptionValue == null ? "" : descriptionValue.asString(), displayNameValue == null ? "" : displayNameValue.asString(), smallIconValue == null ? "" : smallIconValue.asString(), largeIconValue == null ? "" : largeIconValue.asString());
                if (descriptionGroup != null) {
                    filter.setDescriptionGroup(descriptionGroup);
                }
                filters.add((MappableMetaData)filter);
                FilterMappingMetaData filterMapping = new FilterMappingMetaData();
                filterMapping.setFilterName(filter.getName());
                urlPatterns = new ArrayList();
                ArrayList servletNames = new ArrayList();
                ArrayList<DispatcherType> dispatchers = new ArrayList<DispatcherType>();
                AnnotationValue urlPatternsValue = annotation.value("urlPatterns");
                if (urlPatternsValue != null) {
                    Collections.addAll(urlPatterns, urlPatternsValue.asStringArray());
                }
                if ((urlPatternsValue = annotation.value()) != null) {
                    Collections.addAll(urlPatterns, urlPatternsValue.asStringArray());
                }
                if (urlPatterns.size() > 0) {
                    filterMapping.setUrlPatterns(urlPatterns);
                }
                if ((servletNamesValue = annotation.value("servletNames")) != null) {
                    Collections.addAll(servletNames, servletNamesValue.asStringArray());
                }
                if (servletNames.size() > 0) {
                    filterMapping.setServletNames(servletNames);
                }
                if ((dispatcherTypesValue = annotation.value("dispatcherTypes")) != null) {
                    for (String dispatcherValue : dispatcherTypesValue.asEnumArray()) {
                        dispatchers.add(DispatcherType.valueOf((String)dispatcherValue));
                    }
                }
                if (dispatchers.size() > 0) {
                    filterMapping.setDispatchers(dispatchers);
                }
                if (urlPatterns.size() <= 0 && servletNames.size() <= 0) continue;
                filterMappings.add(filterMapping);
            }
        }
        if ((webListenerAnnotations = index.getAnnotations(WEB_LISTENER)) != null && webListenerAnnotations.size() > 0) {
            ArrayList<ListenerMetaData> listeners = metaData.getListeners();
            if (listeners == null) {
                listeners = new ArrayList<ListenerMetaData>();
                metaData.setListeners(listeners);
            }
            for (Object annotation : webListenerAnnotations) {
                DescriptionGroupMetaData descriptionGroup2;
                ListenerMetaData listener = new ListenerMetaData();
                target = annotation.target();
                classInfo = (ClassInfo)ClassInfo.class.cast(target);
                listener.setListenerClass(classInfo.toString());
                AnnotationValue descriptionValue2 = annotation.value();
                if (descriptionValue2 != null && (descriptionGroup2 = this.getDescriptionGroup(descriptionValue2.asString())) != null) {
                    listener.setDescriptionGroup(descriptionGroup2);
                }
                listeners.add(listener);
            }
        }
        if ((runAsAnnotations = index.getAnnotations(RUN_AS)) != null && runAsAnnotations.size() > 0) {
            AnnotationsMetaData annotations = metaData.getAnnotations();
            if (annotations == null) {
                annotations = new AnnotationsMetaData();
                metaData.setAnnotations(annotations);
            }
            for (AnnotationInstance annotation : runAsAnnotations) {
                target = annotation.target();
                if (!(target instanceof ClassInfo)) continue;
                classInfo = (ClassInfo)ClassInfo.class.cast(target);
                AnnotationMetaData annotationMD = (AnnotationMetaData)annotations.get(classInfo.toString());
                if (annotationMD == null) {
                    annotationMD = new AnnotationMetaData();
                    annotationMD.setClassName(classInfo.toString());
                    annotations.add((MappableMetaData)annotationMD);
                }
                RunAsMetaData runAs = new RunAsMetaData();
                runAs.setRoleName(annotation.value().asString());
                annotationMD.setRunAs(runAs);
            }
        }
        if ((declareRolesAnnotations = index.getAnnotations(DECLARE_ROLES)) != null && declareRolesAnnotations.size() > 0) {
            SecurityRolesMetaData securityRoles = metaData.getSecurityRoles();
            if (securityRoles == null) {
                securityRoles = new SecurityRolesMetaData();
                metaData.setSecurityRoles(securityRoles);
            }
            for (AnnotationInstance annotation : declareRolesAnnotations) {
                for (ClassInfo role : annotation.value().asStringArray()) {
                    SecurityRoleMetaData sr = new SecurityRoleMetaData();
                    sr.setRoleName((String)role);
                    securityRoles.add((MappableMetaData)sr);
                }
            }
        }
        if ((multipartConfigAnnotations = index.getAnnotations(MULTIPART_CONFIG)) != null && multipartConfigAnnotations.size() > 0) {
            AnnotationsMetaData annotations = metaData.getAnnotations();
            if (annotations == null) {
                annotations = new AnnotationsMetaData();
                metaData.setAnnotations(annotations);
            }
            for (AnnotationInstance annotation : multipartConfigAnnotations) {
                AnnotationValue fileSizeThresholdValue;
                AnnotationValue maxRequestSizeValue;
                AnnotationValue maxFileSizeValue;
                AnnotationTarget target3 = annotation.target();
                ClassInfo classInfo3 = (ClassInfo)ClassInfo.class.cast(target3);
                AnnotationMetaData annotationMD = (AnnotationMetaData)annotations.get(classInfo3.toString());
                if (annotationMD == null) {
                    annotationMD = new AnnotationMetaData();
                    annotationMD.setClassName(classInfo3.toString());
                    annotations.add((MappableMetaData)annotationMD);
                }
                MultipartConfigMetaData multipartConfig = new MultipartConfigMetaData();
                AnnotationValue locationValue = annotation.value("location");
                if (locationValue != null && locationValue.asString().length() > 0) {
                    multipartConfig.setLocation(locationValue.asString());
                }
                if ((maxFileSizeValue = annotation.value("maxFileSize")) != null && maxFileSizeValue.asLong() != -1L) {
                    multipartConfig.setMaxFileSize(maxFileSizeValue.asLong());
                }
                if ((maxRequestSizeValue = annotation.value("maxRequestSize")) != null && maxRequestSizeValue.asLong() != -1L) {
                    multipartConfig.setMaxRequestSize(maxRequestSizeValue.asLong());
                }
                if ((fileSizeThresholdValue = annotation.value("fileSizeThreshold")) != null && fileSizeThresholdValue.asInt() != 0) {
                    multipartConfig.setFileSizeThreshold(fileSizeThresholdValue.asInt());
                }
                annotationMD.setMultipartConfig(multipartConfig);
            }
        }
        if ((servletSecurityAnnotations = index.getAnnotations(SERVLET_SECURITY)) != null && servletSecurityAnnotations.size() > 0) {
            AnnotationsMetaData annotations = metaData.getAnnotations();
            if (annotations == null) {
                annotations = new AnnotationsMetaData();
                metaData.setAnnotations(annotations);
            }
            for (AnnotationInstance annotation : servletSecurityAnnotations) {
                AnnotationInstance[] httpMethodConstraints;
                AnnotationTarget target4 = annotation.target();
                ClassInfo classInfo4 = (ClassInfo)ClassInfo.class.cast(target4);
                AnnotationMetaData annotationMD = (AnnotationMetaData)annotations.get(classInfo4.toString());
                if (annotationMD == null) {
                    annotationMD = new AnnotationMetaData();
                    annotationMD.setClassName(classInfo4.toString());
                    annotations.add((MappableMetaData)annotationMD);
                }
                ServletSecurityMetaData servletSecurity = new ServletSecurityMetaData();
                AnnotationValue httpConstraintValue = annotation.value();
                ArrayList rolesAllowed = new ArrayList();
                if (httpConstraintValue != null) {
                    AnnotationValue rolesAllowedValue;
                    AnnotationValue httpConstraintTGValue;
                    AnnotationInstance httpConstraint = httpConstraintValue.asNested();
                    AnnotationValue httpConstraintERSValue = httpConstraint.value();
                    if (httpConstraintERSValue != null) {
                        servletSecurity.setEmptyRoleSemantic(EmptyRoleSemanticType.valueOf((String)httpConstraintERSValue.asEnum()));
                    }
                    if ((httpConstraintTGValue = httpConstraint.value("transportGuarantee")) != null) {
                        servletSecurity.setTransportGuarantee(org.jboss.metadata.web.spec.TransportGuaranteeType.valueOf((String)httpConstraintTGValue.asEnum()));
                    }
                    if ((rolesAllowedValue = httpConstraint.value("rolesAllowed")) != null) {
                        Collections.addAll(rolesAllowed, rolesAllowedValue.asStringArray());
                    }
                }
                servletSecurity.setRolesAllowed(rolesAllowed);
                AnnotationValue httpMethodConstraintsValue = annotation.value("httpMethodConstraints");
                if (httpMethodConstraintsValue != null && (httpMethodConstraints = httpMethodConstraintsValue.asNestedArray()).length > 0) {
                    ArrayList<HttpMethodConstraintMetaData> methodConstraints = new ArrayList<HttpMethodConstraintMetaData>();
                    for (AnnotationInstance httpMethodConstraint : httpMethodConstraints) {
                        AnnotationValue httpMethodConstraintTGValue;
                        AnnotationValue httpMethodConstraintERSValue;
                        HttpMethodConstraintMetaData methodConstraint = new HttpMethodConstraintMetaData();
                        AnnotationValue httpMethodConstraintValue = httpMethodConstraint.value();
                        if (httpMethodConstraintValue != null) {
                            methodConstraint.setMethod(httpMethodConstraintValue.asString());
                        }
                        if ((httpMethodConstraintERSValue = httpMethodConstraint.value("emptyRoleSemantic")) != null) {
                            methodConstraint.setEmptyRoleSemantic(EmptyRoleSemanticType.valueOf((String)httpMethodConstraintERSValue.asEnum()));
                        }
                        if ((httpMethodConstraintTGValue = httpMethodConstraint.value("transportGuarantee")) != null) {
                            methodConstraint.setTransportGuarantee(org.jboss.metadata.web.spec.TransportGuaranteeType.valueOf((String)httpMethodConstraintTGValue.asEnum()));
                        }
                        AnnotationValue rolesAllowedValue = httpMethodConstraint.value("rolesAllowed");
                        rolesAllowed = new ArrayList();
                        if (rolesAllowedValue != null) {
                            Collections.addAll(rolesAllowed, rolesAllowedValue.asStringArray());
                        }
                        methodConstraint.setRolesAllowed(rolesAllowed);
                        methodConstraints.add(methodConstraint);
                    }
                    servletSecurity.setHttpMethodConstraints(methodConstraints);
                }
                annotationMD.setServletSecurity(servletSecurity);
            }
        }
    }

    private List<ParamValueMetaData> getInitParams(AnnotationValue initParamsValue) {
        ArrayList<ParamValueMetaData> paramValuesMetaData = new ArrayList<ParamValueMetaData>();
        if (initParamsValue == null) {
            return paramValuesMetaData;
        }
        AnnotationInstance[] initParamsAnnotations = initParamsValue.asNestedArray();
        if (initParamsAnnotations != null && initParamsAnnotations.length > 0) {
            for (AnnotationInstance initParamsAnnotation : initParamsAnnotations) {
                Descriptions descriptions;
                ParamValueMetaData initParam = new ParamValueMetaData();
                AnnotationValue initParamName = initParamsAnnotation.value("name");
                AnnotationValue initParamValue = initParamsAnnotation.value();
                AnnotationValue initParamDescription = initParamsAnnotation.value("description");
                initParam.setParamName(initParamName.asString());
                initParam.setParamValue(initParamValue.asString());
                if (initParamDescription != null && (descriptions = this.getDescription(initParamDescription.asString())) != null) {
                    initParam.setDescriptions(descriptions);
                }
                paramValuesMetaData.add(initParam);
            }
        }
        return paramValuesMetaData;
    }

    private static TransportGuaranteeType transportGuaranteeType(org.jboss.metadata.web.spec.TransportGuaranteeType type) {
        if (type == null) {
            return TransportGuaranteeType.NONE;
        }
        switch (type) {
            case CONFIDENTIAL: {
                return TransportGuaranteeType.CONFIDENTIAL;
            }
            case INTEGRAL: {
                return TransportGuaranteeType.INTEGRAL;
            }
            case NONE: {
                return TransportGuaranteeType.NONE;
            }
        }
        throw new RuntimeException("UNREACHABLE");
    }

    protected Descriptions getDescription(String description) {
        DescriptionsImpl descriptions = null;
        if (description.length() > 0) {
            DescriptionImpl di = new DescriptionImpl();
            di.setDescription(description);
            descriptions = new DescriptionsImpl();
            descriptions.add((MappableMetaData)di);
        }
        return descriptions;
    }

    protected DisplayNames getDisplayName(String displayName) {
        DisplayNamesImpl displayNames = null;
        if (displayName.length() > 0) {
            DisplayNameImpl dn = new DisplayNameImpl();
            dn.setDisplayName(displayName);
            displayNames = new DisplayNamesImpl();
            displayNames.add((MappableMetaData)dn);
        }
        return displayNames;
    }

    protected Icons getIcons(String smallIcon, String largeIcon) {
        IconsImpl icons = null;
        if (smallIcon.length() > 0 || largeIcon.length() > 0) {
            IconImpl i = new IconImpl();
            i.setSmallIcon(smallIcon);
            i.setLargeIcon(largeIcon);
            icons = new IconsImpl();
            icons.add((MappableMetaData)i);
        }
        return icons;
    }

    protected DescriptionGroupMetaData getDescriptionGroup(String description) {
        DescriptionGroupMetaData dg = null;
        if (description.length() > 0) {
            dg = new DescriptionGroupMetaData();
            Descriptions descriptions = this.getDescription(description);
            dg.setDescriptions(descriptions);
        }
        return dg;
    }

    protected DescriptionGroupMetaData getDescriptionGroup(String description, String displayName, String smallIcon, String largeIcon) {
        DescriptionGroupMetaData dg = null;
        if (description.length() > 0 || displayName.length() > 0 || smallIcon.length() > 0 || largeIcon.length() > 0) {
            Icons icons;
            DisplayNames displayNames;
            dg = new DescriptionGroupMetaData();
            Descriptions descriptions = this.getDescription(description);
            if (descriptions != null) {
                dg.setDescriptions(descriptions);
            }
            if ((displayNames = this.getDisplayName(displayName)) != null) {
                dg.setDisplayNames(displayNames);
            }
            if ((icons = this.getIcons(smallIcon, largeIcon)) != null) {
                dg.setIcons(icons);
            }
        }
        return dg;
    }
}

