/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.vertx;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.test.TestMethodInvoker;
import io.quarkus.test.TestReactiveTransaction;
import io.quarkus.test.vertx.DefaultUniAsserter;
import io.quarkus.test.vertx.RunOnVertxContext;
import io.quarkus.test.vertx.UniAsserter;
import io.quarkus.vertx.core.runtime.VertxCoreRecorder;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;

public class RunOnVertxContextTestMethodInvoker
implements TestMethodInvoker {
    private DefaultUniAsserter uniAsserter;

    public boolean handlesMethodParamType(String paramClassName) {
        return UniAsserter.class.getName().equals(paramClassName);
    }

    public Object methodParamInstance(String paramClassName) {
        if (!this.handlesMethodParamType(paramClassName)) {
            throw new IllegalStateException("RunOnVertxContextTestMethodInvoker does not handle '" + paramClassName + "' method param types");
        }
        this.uniAsserter = new DefaultUniAsserter();
        return this.uniAsserter;
    }

    public boolean supportsMethod(Class<?> originalTestClass, Method originalTestMethod) {
        return this.hasAnnotation(RunOnVertxContext.class, originalTestMethod.getAnnotations()) || this.hasAnnotation(RunOnVertxContext.class, originalTestClass.getAnnotations()) || this.hasAnnotation("io.quarkus.hibernate.reactive.panache.common.runtime.ReactiveTransactional", originalTestMethod.getAnnotations()) || this.hasAnnotation("io.quarkus.hibernate.reactive.panache.common.runtime.ReactiveTransactional", originalTestClass.getAnnotations()) || this.hasAnnotation(TestReactiveTransaction.class, originalTestMethod.getAnnotations()) || this.hasAnnotation(TestReactiveTransaction.class, originalTestClass.getAnnotations());
    }

    private boolean hasAnnotation(Class<? extends Annotation> annotation, Annotation[] annotations) {
        return this.hasAnnotation(annotation.getName(), annotations);
    }

    private boolean hasAnnotation(String annotationName, Annotation[] annotations) {
        if (annotations != null) {
            for (Annotation methodAnnotation : annotations) {
                if (!annotationName.equals(methodAnnotation.annotationType().getName())) continue;
                return true;
            }
        }
        return false;
    }

    public Object invoke(Object actualTestInstance, Method actualTestMethod, List<Object> actualTestMethodArgs, String testClassName) throws Throwable {
        Vertx vertx = (Vertx)VertxCoreRecorder.getVertx().get();
        if (vertx == null) {
            throw new IllegalStateException("Vert.x instance has not been created before attempting to run test method '" + actualTestMethod.getName() + "' of test class '" + testClassName + "'");
        }
        CompletableFuture<Object> cf = new CompletableFuture<Object>();
        RunTestMethodOnContextHandler handler = new RunTestMethodOnContextHandler(actualTestInstance, actualTestMethod, actualTestMethodArgs, this.uniAsserter, cf);
        Context context = vertx.getOrCreateContext();
        boolean shouldDuplicateContext = this.shouldContextBeDuplicated(actualTestInstance != null ? actualTestInstance.getClass() : Object.class, actualTestMethod);
        if (shouldDuplicateContext) {
            context = VertxContext.getOrCreateDuplicatedContext((Context)context);
            VertxContextSafetyToggle.setContextSafe((Context)context, (boolean)true);
        }
        context.runOnContext((Handler)handler);
        try {
            return cf.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    private boolean shouldContextBeDuplicated(Class<?> c, Method m) {
        RunOnVertxContext runOnVertxContext = m.getAnnotation(RunOnVertxContext.class);
        if (runOnVertxContext == null) {
            runOnVertxContext = c.getAnnotation(RunOnVertxContext.class);
        }
        if (runOnVertxContext == null) {
            return false;
        }
        return runOnVertxContext.duplicateContext();
    }

    public static class RunTestMethodOnContextHandler
    implements Handler<Void> {
        private static final Runnable DO_NOTHING = new Runnable(){

            @Override
            public void run() {
            }
        };
        private final Object testInstance;
        private final Method targetMethod;
        private final List<Object> methodArgs;
        private final DefaultUniAsserter uniAsserter;
        private final CompletableFuture<Object> future;

        public RunTestMethodOnContextHandler(Object testInstance, Method targetMethod, List<Object> methodArgs, DefaultUniAsserter uniAsserter, CompletableFuture<Object> future) {
            this.testInstance = testInstance;
            this.future = future;
            this.targetMethod = targetMethod;
            this.methodArgs = methodArgs;
            this.uniAsserter = uniAsserter;
        }

        public void handle(Void event) {
            final ManagedContext requestContext = Arc.container().requestContext();
            if (requestContext.isActive()) {
                this.doRun(DO_NOTHING);
            } else {
                requestContext.activate();
                this.doRun(new Runnable(){

                    @Override
                    public void run() {
                        requestContext.terminate();
                    }
                });
            }
        }

        private void doRun(final Runnable onTerminate) {
            try {
                final Object testMethodResult = this.targetMethod.invoke(this.testInstance, this.methodArgs.toArray(new Object[0]));
                if (this.uniAsserter != null) {
                    this.uniAsserter.execution.subscribe().with((Consumer)new Consumer<Object>(){

                        @Override
                        public void accept(Object o) {
                            onTerminate.run();
                            future.complete(testMethodResult);
                        }
                    }, (Consumer)new Consumer<Throwable>(){

                        @Override
                        public void accept(Throwable t) {
                            onTerminate.run();
                            future.completeExceptionally(t);
                        }
                    });
                } else {
                    onTerminate.run();
                    this.future.complete(testMethodResult);
                }
            }
            catch (Throwable t) {
                onTerminate.run();
                this.future.completeExceptionally(t.getCause());
            }
        }
    }
}

