/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.infinispan.client;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.infinispan.commons.util.Version;
import org.infinispan.server.test.core.InfinispanContainer;
import org.jboss.logging.Logger;

public class InfinispanTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = Logger.getLogger(InfinispanTestResource.class);
    public static final String PORT_ARG = "port";
    public static final String USER_ARG = "user";
    public static final String PASSWORD_ARG = "password";
    public static final String ARTIFACTS_ARG = "artifacts";
    private static final int DEFAULT_PORT = 11222;
    private static final String DEFAULT_USER = "admin";
    private static final String DEFAULT_PASSWORD = "password";
    private static InfinispanContainer INFINISPAN;
    private String USER;
    private String PASSWORD;
    private String[] ARTIFACTS;
    private Integer HOTROD_PORT;

    public void init(Map<String, String> initArgs) {
        this.HOTROD_PORT = Optional.ofNullable(initArgs.get(PORT_ARG)).map(Integer::parseInt).orElse(11222);
        this.USER = Optional.ofNullable(initArgs.get(USER_ARG)).orElse(DEFAULT_USER);
        this.PASSWORD = Optional.ofNullable(initArgs.get("password")).orElse("password");
        String artifacts = initArgs.get(ARTIFACTS_ARG);
        this.ARTIFACTS = artifacts == null ? new String[0] : artifacts.split(",");
    }

    public Map<String, String> start() {
        INFINISPAN = new InfinispanContainer();
        INFINISPAN.withUser(this.USER).withPassword(this.PASSWORD).withArtifacts(this.ARTIFACTS);
        LOGGER.infof("Starting Infinispan Server %s on port %s with user %s and password %s", new Object[]{Version.getMajorMinor(), this.HOTROD_PORT, this.USER, this.PASSWORD});
        INFINISPAN.start();
        String hosts = INFINISPAN.getHost() + ":" + INFINISPAN.getMappedPort(this.HOTROD_PORT.intValue());
        return Collections.singletonMap("quarkus.infinispan-client.hosts", hosts);
    }

    public void stop() {
        if (INFINISPAN != null) {
            INFINISPAN.stop();
        }
    }
}

