/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.jpa.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.TrustedAuthenticationRequest;
import io.quarkus.security.jpa.common.runtime.JpaIdentityProviderUtil;
import io.smallrye.mutiny.Uni;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jboss.logging.Logger;

public abstract class JpaTrustedIdentityProvider
implements IdentityProvider<TrustedAuthenticationRequest> {
    private static Logger log = Logger.getLogger(JpaTrustedIdentityProvider.class);
    @Inject
    SessionFactory sessionFactory;

    public Class<TrustedAuthenticationRequest> getRequestType() {
        return TrustedAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(final TrustedAuthenticationRequest request, AuthenticationRequestContext context) {
        return context.runBlocking((Supplier)new Supplier<SecurityIdentity>(){

            @Override
            public SecurityIdentity get() {
                if (JpaTrustedIdentityProvider.this.requireActiveCDIRequestContext() && !Arc.container().requestContext().isActive()) {
                    ManagedContext requestContext = Arc.container().requestContext();
                    requestContext.activate();
                    try {
                        SecurityIdentity securityIdentity = JpaTrustedIdentityProvider.this.authenticate(request);
                        return securityIdentity;
                    }
                    finally {
                        requestContext.terminate();
                    }
                }
                return JpaTrustedIdentityProvider.this.authenticate(request);
            }
        });
    }

    private SecurityIdentity authenticate(TrustedAuthenticationRequest request) {
        SecurityIdentity securityIdentity;
        block8: {
            Session session = this.sessionFactory.openSession();
            try {
                session.setHibernateFlushMode(FlushMode.MANUAL);
                session.setDefaultReadOnly(true);
                securityIdentity = this.authenticate((EntityManager)session, request);
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SecurityException e) {
                    log.debug((Object)"Authentication failed", (Throwable)e);
                    throw new AuthenticationFailedException();
                }
            }
            session.close();
        }
        return securityIdentity;
    }

    protected boolean requireActiveCDIRequestContext() {
        return false;
    }

    protected <T> T getSingleUser(Query query) {
        List results = query.getResultList();
        return (T)JpaIdentityProviderUtil.getSingleUser((List)results);
    }

    public abstract SecurityIdentity authenticate(EntityManager var1, TrustedAuthenticationRequest var2);
}

