/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.jpa.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.panache.common.deployment.PanacheEntityClassesBuildItem;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.TrustedAuthenticationRequest;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import io.quarkus.security.jpa.PasswordProvider;
import io.quarkus.security.jpa.common.deployment.JpaSecurityDefinition;
import io.quarkus.security.jpa.common.deployment.JpaSecurityDefinitionBuildItem;
import io.quarkus.security.jpa.common.deployment.JpaSecurityIdentityUtil;
import io.quarkus.security.jpa.common.deployment.PanacheEntityPredicateBuildItem;
import io.quarkus.security.jpa.runtime.JpaIdentityProvider;
import io.quarkus.security.jpa.runtime.JpaTrustedIdentityProvider;
import jakarta.inject.Singleton;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.SimpleNaturalIdLoadAccess;
import org.hibernate.annotations.NaturalId;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

class QuarkusSecurityJpaProcessor {
    private static final DotName DOTNAME_NATURAL_ID = DotName.createSimple((String)NaturalId.class.getName());

    QuarkusSecurityJpaProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.SECURITY_JPA);
    }

    @BuildStep
    void configureJpaAuthConfig(ApplicationIndexBuildItem index, BuildProducer<GeneratedBeanBuildItem> beanProducer, Optional<JpaSecurityDefinitionBuildItem> jpaSecurityDefinitionBuildItem, PanacheEntityPredicateBuildItem panacheEntityPredicate) {
        if (jpaSecurityDefinitionBuildItem.isPresent()) {
            JpaSecurityDefinition jpaSecurityDefinition = jpaSecurityDefinitionBuildItem.get().get();
            this.generateIdentityProvider(index.getIndex(), jpaSecurityDefinition, jpaSecurityDefinition.passwordType(), jpaSecurityDefinition.customPasswordProvider(), beanProducer, panacheEntityPredicate);
            this.generateTrustedIdentityProvider(index.getIndex(), jpaSecurityDefinition, beanProducer, panacheEntityPredicate);
        }
    }

    @BuildStep
    PanacheEntityPredicateBuildItem panacheEntityPredicate(List<PanacheEntityClassesBuildItem> panacheEntityClasses) {
        return new PanacheEntityPredicateBuildItem(this.collectPanacheEntities(panacheEntityClasses));
    }

    private Set<String> collectPanacheEntities(List<PanacheEntityClassesBuildItem> panacheEntityClassesBuildItems) {
        HashSet<String> modelClasses = new HashSet<String>();
        for (PanacheEntityClassesBuildItem panacheEntityClasses : panacheEntityClassesBuildItems) {
            modelClasses.addAll(panacheEntityClasses.getEntityClasses());
        }
        return modelClasses;
    }

    private void generateIdentityProvider(Index index, JpaSecurityDefinition jpaSecurityDefinition, AnnotationValue passwordTypeValue, AnnotationValue passwordProviderValue, BuildProducer<GeneratedBeanBuildItem> beanProducer, PanacheEntityPredicateBuildItem panacheEntityPredicate) {
        GeneratedBeanGizmoAdaptor gizmoAdaptor = new GeneratedBeanGizmoAdaptor(beanProducer);
        String name = jpaSecurityDefinition.annotatedClass.name() + "__JpaIdentityProviderImpl";
        try (ClassCreator classCreator = ClassCreator.builder().className(name).superClass(JpaIdentityProvider.class).classOutput((ClassOutput)gizmoAdaptor).build();){
            classCreator.addAnnotation(Singleton.class);
            FieldDescriptor passwordProviderField = ((FieldCreator)classCreator.getFieldCreator("passwordProvider", PasswordProvider.class).setModifiers(2)).getFieldDescriptor();
            try (MethodCreator methodCreator = classCreator.getMethodCreator("authenticate", SecurityIdentity.class, new Class[]{EntityManager.class, UsernamePasswordAuthenticationRequest.class});){
                methodCreator.setModifiers(1);
                ResultHandle username = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(UsernamePasswordAuthenticationRequest.class, (String)"getUsername", String.class, (Class[])new Class[0]), methodCreator.getMethodParam(1), new ResultHandle[0]);
                AnnotationInstance naturalIdAnnotation = jpaSecurityDefinition.username.annotation(DOTNAME_NATURAL_ID);
                ResultHandle user = this.lookupUserById(jpaSecurityDefinition, name, methodCreator, username, naturalIdAnnotation);
                String declaringClassName = jpaSecurityDefinition.annotatedClass.name().toString();
                String declaringClassTypeDescriptor = "L" + declaringClassName.replace('.', '/') + ";";
                AssignableResultHandle userVar = methodCreator.createVariable(declaringClassTypeDescriptor);
                methodCreator.assign(userVar, methodCreator.checkCast(user, declaringClassName));
                JpaSecurityIdentityUtil.buildIdentity((Index)index, (JpaSecurityDefinition)jpaSecurityDefinition, (AnnotationValue)passwordTypeValue, (AnnotationValue)passwordProviderValue, (PanacheEntityPredicateBuildItem)panacheEntityPredicate, (FieldDescriptor)passwordProviderField, (MethodCreator)methodCreator, (ResultHandle)userVar, (BytecodeCreator)methodCreator);
            }
        }
    }

    private void generateTrustedIdentityProvider(Index index, JpaSecurityDefinition jpaSecurityDefinition, BuildProducer<GeneratedBeanBuildItem> beanProducer, PanacheEntityPredicateBuildItem panacheEntityPredicate) {
        GeneratedBeanGizmoAdaptor gizmoAdaptor = new GeneratedBeanGizmoAdaptor(beanProducer);
        String name = jpaSecurityDefinition.annotatedClass.name() + "__JpaTrustedIdentityProviderImpl";
        try (ClassCreator classCreator = ClassCreator.builder().className(name).superClass(JpaTrustedIdentityProvider.class).classOutput((ClassOutput)gizmoAdaptor).build();){
            classCreator.addAnnotation(Singleton.class);
            try (MethodCreator methodCreator = classCreator.getMethodCreator("authenticate", SecurityIdentity.class, new Class[]{EntityManager.class, TrustedAuthenticationRequest.class});){
                methodCreator.setModifiers(1);
                ResultHandle username = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(TrustedAuthenticationRequest.class, (String)"getPrincipal", String.class, (Class[])new Class[0]), methodCreator.getMethodParam(1), new ResultHandle[0]);
                AnnotationInstance naturalIdAnnotation = jpaSecurityDefinition.username.annotation(DOTNAME_NATURAL_ID);
                ResultHandle user = this.lookupUserById(jpaSecurityDefinition, name, methodCreator, username, naturalIdAnnotation);
                String declaringClassName = jpaSecurityDefinition.annotatedClass.name().toString();
                String declaringClassTypeDescriptor = "L" + declaringClassName.replace('.', '/') + ";";
                AssignableResultHandle userVar = methodCreator.createVariable(declaringClassTypeDescriptor);
                methodCreator.assign(userVar, methodCreator.checkCast(user, declaringClassName));
                JpaSecurityIdentityUtil.buildTrustedIdentity((Index)index, (JpaSecurityDefinition)jpaSecurityDefinition, (PanacheEntityPredicateBuildItem)panacheEntityPredicate, (MethodCreator)methodCreator, (ResultHandle)userVar, (BytecodeCreator)methodCreator);
            }
        }
    }

    private ResultHandle lookupUserById(JpaSecurityDefinition jpaSecurityDefinition, String name, MethodCreator methodCreator, ResultHandle username, AnnotationInstance naturalIdAnnotation) {
        ResultHandle user;
        if (naturalIdAnnotation != null) {
            ResultHandle session = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(EntityManager.class, (String)"unwrap", Object.class, (Class[])new Class[]{Class.class}), methodCreator.getMethodParam(0), new ResultHandle[]{methodCreator.loadClassFromTCCL(Session.class)});
            ResultHandle naturalIdLoadAccess = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Session.class, (String)"bySimpleNaturalId", SimpleNaturalIdLoadAccess.class, (Class[])new Class[]{Class.class}), methodCreator.checkCast(session, Session.class), new ResultHandle[]{methodCreator.loadClassFromTCCL(jpaSecurityDefinition.annotatedClass.name().toString())});
            user = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(SimpleNaturalIdLoadAccess.class, (String)"load", Object.class, (Class[])new Class[]{Object.class}), naturalIdLoadAccess, new ResultHandle[]{username});
        } else {
            String hql = "FROM " + jpaSecurityDefinition.annotatedClass.simpleName() + " WHERE " + jpaSecurityDefinition.username.name() + " = :name";
            ResultHandle query = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(EntityManager.class, (String)"createQuery", Query.class, (Class[])new Class[]{String.class}), methodCreator.getMethodParam(0), new ResultHandle[]{methodCreator.load(hql)});
            ResultHandle query2 = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Query.class, (String)"setParameter", Query.class, (Class[])new Class[]{String.class, Object.class}), query, new ResultHandle[]{methodCreator.load("name"), username});
            user = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)name, (String)"getSingleUser", Object.class, (Object[])new Object[]{Query.class}), methodCreator.getThis(), new ResultHandle[]{query2});
        }
        return user;
    }
}

