/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.jpa.common.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.security.jpa.Password;
import io.quarkus.security.jpa.Roles;
import io.quarkus.security.jpa.UserDefinition;
import io.quarkus.security.jpa.Username;
import io.quarkus.security.jpa.common.deployment.JpaSecurityDefinition;
import io.quarkus.security.jpa.common.deployment.JpaSecurityDefinitionBuildItem;
import io.quarkus.security.jpa.common.deployment.JpaSecurityIdentityUtil;
import io.quarkus.security.jpa.common.deployment.PanacheEntityPredicateBuildItem;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

class QuarkusSecurityJpaCommonProcessor {
    private static final DotName DOTNAME_USER_DEFINITION = DotName.createSimple((String)UserDefinition.class.getName());
    private static final DotName DOTNAME_USERNAME = DotName.createSimple((String)Username.class.getName());
    private static final DotName DOTNAME_ROLES = DotName.createSimple((String)Roles.class.getName());
    static final DotName DOTNAME_PASSWORD = DotName.createSimple((String)Password.class.getName());

    QuarkusSecurityJpaCommonProcessor() {
    }

    @BuildStep
    void provideJpaSecurityDefinition(ApplicationIndexBuildItem index, PanacheEntityPredicateBuildItem panacheEntityPredicate, BuildProducer<JpaSecurityDefinitionBuildItem> producer) {
        List userDefinitions = index.getIndex().getAnnotations(DOTNAME_USER_DEFINITION);
        if (userDefinitions.size() > 1) {
            throw new RuntimeException("You can only annotate one class with @UserDefinition");
        }
        if (!userDefinitions.isEmpty()) {
            ClassInfo userDefinitionClass = ((AnnotationInstance)userDefinitions.get(0)).target().asClass();
            AnnotationTarget annotatedUsername = JpaSecurityIdentityUtil.getSingleAnnotatedElement(index.getIndex(), DOTNAME_USERNAME);
            AnnotationTarget annotatedPassword = JpaSecurityIdentityUtil.getSingleAnnotatedElement(index.getIndex(), DOTNAME_PASSWORD);
            AnnotationTarget annotatedRoles = JpaSecurityIdentityUtil.getSingleAnnotatedElement(index.getIndex(), DOTNAME_ROLES);
            JpaSecurityDefinition jpaSecurityDefinition = new JpaSecurityDefinition(index.getIndex(), userDefinitionClass, panacheEntityPredicate.isPanache(userDefinitionClass), annotatedUsername, annotatedPassword, annotatedRoles);
            producer.produce((BuildItem)new JpaSecurityDefinitionBuildItem(jpaSecurityDefinition));
        }
    }
}

