/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.servlet.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.resteasy.reactive.server.deployment.RequestContextFactoryBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveDeploymentBuildItem;
import io.quarkus.resteasy.reactive.server.servlet.runtime.ResteasyReactiveFilter;
import io.quarkus.resteasy.reactive.server.servlet.runtime.ResteasyReactiveServlet;
import io.quarkus.resteasy.reactive.server.servlet.runtime.ResteasyReactiveServletRecorder;
import io.quarkus.resteasy.reactive.server.servlet.runtime.ServletRequestContextFactory;
import io.quarkus.undertow.deployment.FilterBuildItem;
import io.quarkus.undertow.deployment.ServletBuildItem;
import jakarta.servlet.DispatcherType;
import jakarta.ws.rs.core.Application;
import org.jboss.resteasy.reactive.server.core.RequestContextFactory;

public class ResteasyReactiveServletProcessor {
    private static final String JAVAX_WS_RS_APPLICATION;
    private static final String JAX_RS_FILTER_NAME;
    private static final String JAX_RS_SERVLET_NAME;

    @BuildStep
    public RequestContextFactoryBuildItem contextFactoryBuildItem() {
        return new RequestContextFactoryBuildItem((RequestContextFactory)ServletRequestContextFactory.INSTANCE);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(ResteasyReactiveServletRecorder restRecorder, ResteasyReactiveDeploymentBuildItem deploymentBuildItem, BuildProducer<FilterBuildItem> filter, BuildProducer<ServletBuildItem> servlet) throws Exception {
        if (deploymentBuildItem == null) {
            return;
        }
        String path = deploymentBuildItem.getApplicationPath();
        if (path.equals("/") || path.isEmpty()) {
            filter.produce((BuildItem)FilterBuildItem.builder((String)JAX_RS_FILTER_NAME, (String)ResteasyReactiveFilter.class.getName()).setLoadOnStartup(1).addFilterServletNameMapping("default", DispatcherType.REQUEST).addFilterServletNameMapping("default", DispatcherType.FORWARD).addFilterServletNameMapping("default", DispatcherType.INCLUDE).setInstanceFactory(restRecorder.filter(deploymentBuildItem.getDeployment())).setAsyncSupported(true).build());
        } else {
            String mappingPath = deploymentBuildItem.getApplicationPath();
            servlet.produce((BuildItem)ServletBuildItem.builder((String)JAX_RS_SERVLET_NAME, (String)ResteasyReactiveServlet.class.getName()).setInstanceFactory(restRecorder.servlet(deploymentBuildItem.getDeployment())).setLoadOnStartup(1).addMapping(mappingPath + "/*").setAsyncSupported(true).build());
        }
    }

    static {
        JAX_RS_FILTER_NAME = JAVAX_WS_RS_APPLICATION = Application.class.getName();
        JAX_RS_SERVLET_NAME = JAVAX_WS_RS_APPLICATION;
    }
}

