/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.runtime;

import io.quarkus.restclient.runtime.BuilderResolver;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.ws.rs.RuntimeType;
import java.util.Set;
import org.eclipse.microprofile.rest.client.spi.RestClientBuilderResolver;
import org.jboss.resteasy.client.jaxrs.internal.ResteasyClientBuilderImpl;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.microprofile.client.RestClientBuilderImpl;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Recorder
public class RestClientRecorder {
    public static ResteasyProviderFactory providerFactory;

    public void setRestClientBuilderResolver() {
        RestClientBuilderResolver.setInstance((RestClientBuilderResolver)new BuilderResolver());
    }

    public void initializeResteasyProviderFactory(final RuntimeValue<InjectorFactory> ifc, boolean useBuiltIn, Set<String> providersToRegister, Set<String> contributedProviders) {
        ResteasyProviderFactoryImpl clientProviderFactory = new ResteasyProviderFactoryImpl(RuntimeType.CLIENT, (ResteasyProviderFactory)new ResteasyProviderFactoryImpl()){

            public RuntimeType getRuntimeType() {
                return RuntimeType.CLIENT;
            }

            public InjectorFactory getInjectorFactory() {
                return (InjectorFactory)ifc.getValue();
            }
        };
        RestClientRecorder.registerProviders((ResteasyProviderFactory)clientProviderFactory, useBuiltIn, providersToRegister, contributedProviders);
        RestClientBuilderImpl.setProviderFactory((ResteasyProviderFactory)clientProviderFactory);
        ResteasyClientBuilderImpl.setProviderFactory((ResteasyProviderFactory)clientProviderFactory);
        providerFactory = clientProviderFactory;
    }

    public void setResteasyProviderFactoryInstance() {
        ResteasyProviderFactory.setInstance((ResteasyProviderFactory)providerFactory);
    }

    private static void registerProviders(ResteasyProviderFactory providerFactory, boolean useBuiltIn, Set<String> providersToRegister, Set<String> contributedProviders) {
        if (useBuiltIn) {
            RegisterBuiltin.register((ResteasyProviderFactory)providerFactory);
        } else {
            providersToRegister.removeAll(contributedProviders);
            RestClientRecorder.registerProviders(providerFactory, providersToRegister, true);
        }
        RestClientRecorder.registerProviders(providerFactory, contributedProviders, false);
    }

    private static void registerProviders(ResteasyProviderFactory providerFactory, Set<String> providersToRegister, Boolean isBuiltIn) {
        for (String providerToRegister : providersToRegister) {
            try {
                providerFactory.registerProvider(Thread.currentThread().getContextClassLoader().loadClass(providerToRegister.trim()), isBuiltIn.booleanValue());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to find class for provider " + providerToRegister, e);
            }
        }
    }
}

