/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.search;

import io.quarkus.redis.runtime.datasource.Validation;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SpellCheckResponse {
    private final Map<String, List<SpellCheckSuggestion>> response;

    public SpellCheckResponse(Map<String, List<SpellCheckSuggestion>> response) {
        this.response = response;
    }

    public List<SpellCheckSuggestion> suggestions(String name) {
        return this.response.get(Validation.notNullOrBlank(name, "name"));
    }

    public Set<String> misspelledWords() {
        return this.response.keySet();
    }

    public boolean isCorrect() {
        return this.response.keySet().isEmpty();
    }

    public static class SpellCheckSuggestion {
        private final String word;
        private final double distance;

        public SpellCheckSuggestion(String word, double distance) {
            this.word = word;
            this.distance = distance;
        }

        public String word() {
            return this.word;
        }

        public double distance() {
            return this.distance;
        }
    }
}

