/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.cuckoo.CfInsertArgs;
import io.quarkus.redis.datasource.cuckoo.CfReserveArgs;
import io.quarkus.redis.datasource.cuckoo.ReactiveTransactionalCuckooCommands;
import io.quarkus.redis.datasource.cuckoo.TransactionalCuckooCommands;
import io.quarkus.redis.datasource.transactions.TransactionalRedisDataSource;
import io.quarkus.redis.runtime.datasource.AbstractTransactionalRedisCommandGroup;
import java.time.Duration;

public class BlockingTransactionalCuckooCommandsImpl<K, V>
extends AbstractTransactionalRedisCommandGroup
implements TransactionalCuckooCommands<K, V> {
    private final ReactiveTransactionalCuckooCommands<K, V> reactive;

    public BlockingTransactionalCuckooCommandsImpl(TransactionalRedisDataSource ds, ReactiveTransactionalCuckooCommands<K, V> reactive, Duration timeout) {
        super(ds, timeout);
        this.reactive = reactive;
    }

    @Override
    public void cfadd(K key, V value) {
        this.reactive.cfadd(key, value).await().atMost(this.timeout);
    }

    @Override
    public void cfaddnx(K key, V value) {
        this.reactive.cfaddnx(key, value).await().atMost(this.timeout);
    }

    @Override
    public void cfcount(K key, V value) {
        this.reactive.cfcount(key, value).await().atMost(this.timeout);
    }

    @Override
    public void cfdel(K key, V value) {
        this.reactive.cfdel(key, value).await().atMost(this.timeout);
    }

    @Override
    public void cfexists(K key, V value) {
        this.reactive.cfexists(key, value).await().atMost(this.timeout);
    }

    @Override
    public void cfinsert(K key, V ... values) {
        this.reactive.cfinsert(key, values).await().atMost(this.timeout);
    }

    @Override
    public void cfinsert(K key, CfInsertArgs args, V ... values) {
        this.reactive.cfinsert(key, args, values).await().atMost(this.timeout);
    }

    @Override
    public void cfinsertnx(K key, V ... values) {
        this.reactive.cfinsertnx(key, values).await().atMost(this.timeout);
    }

    @Override
    public void cfinsertnx(K key, CfInsertArgs args, V ... values) {
        this.reactive.cfinsertnx(key, args, values).await().atMost(this.timeout);
    }

    @Override
    public void cfmexists(K key, V ... values) {
        this.reactive.cfmexists(key, values).await().atMost(this.timeout);
    }

    @Override
    public void cfreserve(K key, long capacity) {
        this.reactive.cfreserve(key, capacity).await().atMost(this.timeout);
    }

    @Override
    public void cfreserve(K key, long capacity, CfReserveArgs args) {
        this.reactive.cfreserve(key, capacity, args).await().atMost(this.timeout);
    }
}

