/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.mysql.client.runtime.health;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.datasource.runtime.DataSourcesHealthSupport;
import io.quarkus.reactive.datasource.runtime.ReactiveDatasourceHealthCheck;
import io.vertx.mysqlclient.MySQLPool;
import io.vertx.sqlclient.Pool;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
class ReactiveMySQLDataSourcesHealthCheck
extends ReactiveDatasourceHealthCheck {
    public ReactiveMySQLDataSourcesHealthCheck() {
        super("Reactive MySQL connections health check", "SELECT 1");
    }

    @PostConstruct
    protected void init() {
        ArcContainer container = Arc.container();
        DataSourcesHealthSupport excluded = (DataSourcesHealthSupport)container.instance(DataSourcesHealthSupport.class, new Annotation[0]).get();
        Set excludedNames = excluded.getExcludedNames();
        for (InstanceHandle handle : container.select(MySQLPool.class, new Annotation[]{Any.Literal.INSTANCE}).handles()) {
            String poolName = this.getPoolName((Bean)handle.getBean());
            if (excludedNames.contains(poolName)) continue;
            this.addPool(poolName, (Pool)handle.get());
        }
    }
}

