/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.i18n;

import io.quarkus.arc.WithCaching;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.Variant;
import io.quarkus.qute.runtime.MessageBundleRecorder;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;

@Singleton
public class MessageTemplateLocator
implements TemplateLocator {
    @WithCaching
    @Inject
    Instance<MessageBundleRecorder.BundleContext> bundleContext;

    public int getPriority() {
        return 0;
    }

    public Optional<TemplateLocator.TemplateLocation> locate(String id) {
        String template;
        if (this.bundleContext.isResolvable() && (template = ((MessageBundleRecorder.BundleContext)this.bundleContext.get()).getMessageTemplates().get(id)) != null) {
            return Optional.of(new MessageTemplateLocation(template));
        }
        return Optional.empty();
    }

    static final class MessageTemplateLocation
    implements TemplateLocator.TemplateLocation {
        private final String content;

        private MessageTemplateLocation(String content) {
            this.content = content;
        }

        public Reader read() {
            return new StringReader(this.content);
        }

        public Optional<Variant> getVariant() {
            return Optional.empty();
        }
    }
}

